/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.core.IKeyResolver;
import com.microsoft.azure.keyvault.extensions.FutureAdapter;
import com.microsoft.azure.keyvault.extensions.FutureImmediate;
import com.microsoft.azure.keyvault.extensions.KeyVaultKey;
import com.microsoft.azure.keyvault.extensions.SymmetricKey;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyIdentifier;
import com.microsoft.azure.keyvault.models.Secret;
import com.microsoft.azure.keyvault.models.SecretIdentifier;
import java.util.concurrent.Future;
import org.apache.commons.codec.binary.Base64;

public class KeyVaultKeyResolver
implements IKeyResolver {
    private final KeyVaultClient _client;

    public KeyVaultKeyResolver(KeyVaultClient client) {
        this._client = client;
    }

    private Future<IKey> resolveKeyFromSecretAsync(String kid) {
        return new FutureKeyFromSecret(this._client.getSecretAsync(kid));
    }

    private Future<IKey> resolveKeyFromKeyAsync(String kid) {
        return new FutureKeyFromKey(this._client.getKeyAsync(kid));
    }

    public Future<IKey> resolveKeyAsync(String kid) {
        if (KeyIdentifier.isKeyIdentifier((String)kid)) {
            return this.resolveKeyFromKeyAsync(kid);
        }
        if (SecretIdentifier.isSecretIdentifier((String)kid)) {
            return this.resolveKeyFromSecretAsync(kid);
        }
        return new FutureImmediate<Object>(null);
    }

    static class FutureKeyFromSecret
    extends FutureAdapter<Secret, IKey> {
        static final Base64 _base64 = new Base64(-1, null, true);

        protected FutureKeyFromSecret(Future<Secret> inner) {
            super(inner);
        }

        @Override
        protected IKey translate(Secret secretBundle) {
            byte[] keyBytes;
            if (secretBundle != null && secretBundle.getContentType().equalsIgnoreCase("application/octet-stream") && (keyBytes = _base64.decode(secretBundle.getValue())) != null) {
                return new SymmetricKey(secretBundle.getId(), keyBytes);
            }
            return null;
        }
    }

    class FutureKeyFromKey
    extends FutureAdapter<KeyBundle, IKey> {
        protected FutureKeyFromKey(Future<KeyBundle> inner) {
            super(inner);
        }

        @Override
        protected IKey translate(KeyBundle keyBundle) {
            if (keyBundle != null) {
                return new KeyVaultKey(KeyVaultKeyResolver.this._client, keyBundle);
            }
            return null;
        }
    }
}

