/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.extensions.FutureBase;
import com.microsoft.azure.keyvault.extensions.FutureExecutionException;
import com.microsoft.azure.keyvault.extensions.Strings;
import com.microsoft.azure.keyvault.extensions.cryptography.Algorithm;
import com.microsoft.azure.keyvault.extensions.cryptography.AlgorithmResolver;
import com.microsoft.azure.keyvault.extensions.cryptography.AsymmetricEncryptionAlgorithm;
import com.microsoft.azure.keyvault.extensions.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class RsaKey
implements IKey {
    public static int KeySize1024 = 1024;
    public static int KeySize2048 = 2048;
    private final String _kid;
    private final KeyPair _keyPair;

    public static int getDefaultKeySize() {
        return KeySize2048;
    }

    public RsaKey(String kid) throws NoSuchAlgorithmException {
        this(kid, RsaKey.getDefaultKeySize());
    }

    public RsaKey(String kid, int keySize) throws NoSuchAlgorithmException {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("kid");
        }
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(keySize);
        this._keyPair = generator.generateKeyPair();
        this._kid = kid;
    }

    public RsaKey(String kid, KeyPair keyPair) {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("kid");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("kid");
        }
        if (keyPair.getPublic() == null || !(keyPair.getPublic() instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("keyPair");
        }
        this._keyPair = keyPair;
        this._kid = kid;
    }

    public RsaKey(JsonWebKey key) {
        this._keyPair = key.toRSA(true);
        this._kid = key.getKid();
    }

    public String getDefaultEncryptionAlgorithm() {
        return "RSA-OAEP";
    }

    public String getDefaultKeyWrapAlgorithm() {
        return "RSA-OAEP";
    }

    public String getDefaultSignatureAlgorithm() {
        return "RS256";
    }

    public String getKid() {
        return this._kid;
    }

    public Future<byte[]> decryptAsync(byte[] ciphertext, byte[] iv, byte[] authenticationData, byte[] authenticationTag, String algorithm) throws NoSuchAlgorithmException {
        FutureBase result;
        if (ciphertext == null) {
            throw new IllegalArgumentException("ciphertext");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateDecryptor(this._keyPair);
            result = new FutureDecrypt(transform, ciphertext);
        }
        catch (Exception e) {
            result = new FutureExecutionException<byte[]>(e);
        }
        return result;
    }

    public Future<Triple<byte[], byte[], String>> encryptAsync(byte[] plaintext, byte[] iv, byte[] authenticationData, String algorithm) throws NoSuchAlgorithmException {
        FutureBase result;
        if (plaintext == null) {
            throw new IllegalArgumentException("plaintext");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultEncryptionAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateEncryptor(this._keyPair);
            result = new FutureEncrypt(algorithmName, plaintext, transform);
        }
        catch (Exception e) {
            result = new FutureExecutionException<Triple<byte[], byte[], String>>(e);
        }
        return result;
    }

    public Future<Pair<byte[], String>> wrapKeyAsync(byte[] key, String algorithm) throws NoSuchAlgorithmException {
        FutureBase result;
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultKeyWrapAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateEncryptor(this._keyPair);
            result = new FutureWrap(algorithmName, key, transform);
        }
        catch (Exception e) {
            result = new FutureExecutionException<Pair<byte[], String>>(e);
        }
        return result;
    }

    public Future<byte[]> unwrapKeyAsync(byte[] encryptedKey, String algorithm) throws NoSuchAlgorithmException {
        FutureBase result;
        if (encryptedKey == null) {
            throw new IllegalArgumentException("encryptedKey ");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateDecryptor(this._keyPair);
            result = new FutureDecrypt(transform, encryptedKey);
        }
        catch (Exception e) {
            result = new FutureExecutionException<byte[]>(e);
        }
        return result;
    }

    public Future<Pair<byte[], String>> signAsync(byte[] digest, String algorithm) {
        return null;
    }

    public Future<Boolean> verifyAsync(byte[] digest, byte[] signature, String algorithm) {
        return null;
    }

    public void close() throws IOException {
    }

    class FutureWrap
    extends FutureBase<Pair<byte[], String>> {
        private final String _algorithm;
        private final byte[] _data;
        private final ICryptoTransform _transform;

        FutureWrap(String algorithm, byte[] data, ICryptoTransform transform) {
            this._algorithm = algorithm;
            this._data = data;
            this._transform = transform;
        }

        @Override
        public Pair<byte[], String> get() throws InterruptedException, ExecutionException {
            try {
                return Pair.of((Object)this._transform.doFinal(this._data), (Object)this._algorithm);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public Pair<byte[], String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return Pair.of((Object)this._transform.doFinal(this._data), (Object)this._algorithm);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    class FutureEncrypt
    extends FutureBase<Triple<byte[], byte[], String>> {
        private final String _algorithm;
        private final byte[] _data;
        private final ICryptoTransform _transform;

        FutureEncrypt(String algorithm, byte[] data, ICryptoTransform transform) {
            this._algorithm = algorithm;
            this._data = data;
            this._transform = transform;
        }

        @Override
        public Triple<byte[], byte[], String> get() throws InterruptedException, ExecutionException {
            try {
                return Triple.of((Object)this._transform.doFinal(this._data), (Object)null, (Object)this._algorithm);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public Triple<byte[], byte[], String> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return Triple.of((Object)this._transform.doFinal(this._data), (Object)null, (Object)this._algorithm);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }

    class FutureDecrypt
    extends FutureBase<byte[]> {
        private final byte[] _data;
        private final ICryptoTransform _transform;

        FutureDecrypt(ICryptoTransform transform, byte[] data) {
            this._data = data;
            this._transform = transform;
        }

        @Override
        public byte[] get() throws InterruptedException, ExecutionException {
            try {
                return this._transform.doFinal(this._data);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public byte[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this._transform.doFinal(this._data);
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
    }
}

