/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.extensions.FutureExecutionException;
import com.microsoft.azure.keyvault.extensions.FutureImmediate;
import com.microsoft.azure.keyvault.extensions.Strings;
import com.microsoft.azure.keyvault.extensions.cryptography.Algorithm;
import com.microsoft.azure.keyvault.extensions.cryptography.AlgorithmResolver;
import com.microsoft.azure.keyvault.extensions.cryptography.IAuthenticatedCryptoTransform;
import com.microsoft.azure.keyvault.extensions.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.extensions.cryptography.KeyWrapAlgorithm;
import com.microsoft.azure.keyvault.extensions.cryptography.SymmetricEncryptionAlgorithm;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class SymmetricKey
implements IKey {
    public static final int KeySize128 = 16;
    public static final int KeySize192 = 24;
    public static final int KeySize256 = 32;
    public static final int KeySize384 = 48;
    public static final int KeySize512 = 64;
    private static final int DefaultKeySize = 32;
    private final String _kid;
    private final byte[] _key;
    private final Provider _provider;

    public SymmetricKey(String kid, byte[] keyBytes) {
        this(kid, keyBytes, null);
    }

    public SymmetricKey(String kid, byte[] keyBytes, Provider provider) {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("kid");
        }
        if (keyBytes == null) {
            throw new IllegalArgumentException("keyBytes");
        }
        if (keyBytes.length != 16 && keyBytes.length != 24 && keyBytes.length != 32 && keyBytes.length != 48 && keyBytes.length != 64) {
            throw new IllegalArgumentException("The key material must be 128, 192, 256, 384 or 512 bits of data");
        }
        this._kid = kid;
        this._key = keyBytes;
        this._provider = provider;
    }

    public String getDefaultEncryptionAlgorithm() {
        switch (this._key.length) {
            case 16: {
                return "A128CBC";
            }
            case 24: {
                return "A192CBC";
            }
            case 32: {
                return "A128CBC-HS256";
            }
            case 48: {
                return "A192CBC-HS384";
            }
            case 64: {
                return "A256CBC-HS512";
            }
        }
        return null;
    }

    public String getDefaultKeyWrapAlgorithm() {
        switch (this._key.length) {
            case 16: {
                return "A128KW";
            }
            case 24: {
                return "A192KW";
            }
            case 32: {
                return "A256KW";
            }
            case 48: {
                return "A256KW";
            }
            case 64: {
                return "A256KW";
            }
        }
        return null;
    }

    public String getDefaultSignatureAlgorithm() {
        return null;
    }

    public String getKid() {
        return this._kid;
    }

    public Future<byte[]> decryptAsync(byte[] ciphertext, byte[] iv, byte[] authenticationData, byte[] authenticationTag, String algorithm) throws NoSuchAlgorithmException {
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        if (ciphertext == null) {
            throw new IllegalArgumentException("ciphertext");
        }
        if (iv == null) {
            throw new IllegalArgumentException("iv");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        SymmetricEncryptionAlgorithm algo = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateDecryptor(this._key, iv, authenticationData);
        }
        catch (Exception e) {
            return new FutureExecutionException<byte[]>(e);
        }
        byte[] result = null;
        try {
            result = transform.doFinal(ciphertext);
        }
        catch (Exception e) {
            return new FutureExecutionException<byte[]>(e);
        }
        if (transform instanceof IAuthenticatedCryptoTransform) {
            IAuthenticatedCryptoTransform authenticatedTransform = (IAuthenticatedCryptoTransform)transform;
            if (authenticationData == null || authenticationTag == null) {
                throw new IllegalArgumentException("AuthenticatingCryptoTransform requires authenticationData and authenticationTag");
            }
            if (!SymmetricKey.sequenceEqualConstantTime(authenticationTag, authenticatedTransform.getTag())) {
                throw new IllegalArgumentException("Data is not authentic");
            }
        }
        return new FutureImmediate<byte[]>(result);
    }

    public Future<Triple<byte[], byte[], String>> encryptAsync(byte[] plaintext, byte[] iv, byte[] authenticationData, String algorithm) throws NoSuchAlgorithmException {
        if (plaintext == null) {
            throw new IllegalArgumentException("plaintext");
        }
        if (iv == null) {
            throw new IllegalArgumentException("iv");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultEncryptionAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof SymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        SymmetricEncryptionAlgorithm algo = (SymmetricEncryptionAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateEncryptor(this._key, iv, authenticationData);
        }
        catch (Exception e) {
            return new FutureExecutionException<Triple<byte[], byte[], String>>(e);
        }
        byte[] cipherText = null;
        try {
            cipherText = transform.doFinal(plaintext);
        }
        catch (Exception e) {
            return new FutureExecutionException<Triple<byte[], byte[], String>>(e);
        }
        byte[] authenticationTag = null;
        if (transform instanceof IAuthenticatedCryptoTransform) {
            IAuthenticatedCryptoTransform authenticatedTransform = (IAuthenticatedCryptoTransform)transform;
            authenticationTag = (byte[])authenticatedTransform.getTag().clone();
        }
        return new FutureImmediate<Triple<byte[], byte[], String>>(Triple.of((Object)cipherText, authenticationTag, (Object)algorithm));
    }

    public Future<Pair<byte[], String>> wrapKeyAsync(byte[] key, String algorithm) throws NoSuchAlgorithmException {
        if (key == null || key.length == 0) {
            throw new IllegalArgumentException("key");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultKeyWrapAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof KeyWrapAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        KeyWrapAlgorithm algo = (KeyWrapAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateEncryptor(this._key, null, this._provider);
        }
        catch (Exception e) {
            return new FutureExecutionException<Pair<byte[], String>>(e);
        }
        byte[] encrypted = null;
        try {
            encrypted = transform.doFinal(key);
        }
        catch (Exception e) {
            return new FutureExecutionException<Pair<byte[], String>>(e);
        }
        return new FutureImmediate<Pair<byte[], String>>(Pair.of((Object)encrypted, (Object)algorithmName));
    }

    public Future<byte[]> unwrapKeyAsync(byte[] encryptedKey, String algorithm) throws NoSuchAlgorithmException {
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        if (encryptedKey == null || encryptedKey.length == 0) {
            throw new IllegalArgumentException("wrappedKey");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof KeyWrapAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        KeyWrapAlgorithm algo = (KeyWrapAlgorithm)baseAlgorithm;
        ICryptoTransform transform = null;
        try {
            transform = algo.CreateDecryptor(this._key, null, this._provider);
        }
        catch (Exception e) {
            return new FutureExecutionException<byte[]>(e);
        }
        byte[] decrypted = null;
        try {
            decrypted = transform.doFinal(encryptedKey);
        }
        catch (Exception e) {
            return new FutureExecutionException<byte[]>(e);
        }
        return new FutureImmediate<byte[]>(decrypted);
    }

    public Future<Pair<byte[], String>> signAsync(byte[] digest, String algorithm) {
        return null;
    }

    public Future<Boolean> verifyAsync(byte[] digest, byte[] signature, String algorithm) {
        return null;
    }

    public void close() throws IOException {
    }

    public static boolean sequenceEqualConstantTime(byte[] self, byte[] other) {
        if (self == null) {
            throw new IllegalArgumentException("self");
        }
        if (other == null) {
            throw new IllegalArgumentException("other");
        }
        long difference = (long)self.length & 0xFFFFFFFFL ^ (long)other.length & 0xFFFFFFFFL;
        for (int i = 0; i < self.length && i < other.length; ++i) {
            difference |= (long)self[i] & 0xFFFFFFFFL ^ (long)other[i] & 0xFFFFFFFFL;
        }
        return difference == 0L;
    }
}

