/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions.cryptography;

import com.microsoft.azure.keyvault.extensions.cryptography.Algorithm;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.Aes128Cbc;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.Aes128CbcHmacSha256;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.Aes192Cbc;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.Aes192CbcHmacSha384;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.Aes256Cbc;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.Aes256CbcHmacSha512;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.AesKw128;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.AesKw192;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.AesKw256;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.Rsa15;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.RsaOaep;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AlgorithmResolver {
    public static final AlgorithmResolver Default = new AlgorithmResolver();
    private final ConcurrentMap<String, Algorithm> _algorithms = new ConcurrentHashMap<String, Algorithm>();

    public Algorithm get(String algorithmName) {
        return (Algorithm)this._algorithms.get(algorithmName);
    }

    public void put(String algorithmName, Algorithm provider) {
        this._algorithms.put(algorithmName, provider);
    }

    public void remove(String algorithmName) {
        this._algorithms.remove(algorithmName);
    }

    static {
        Default.put("A128CBC-HS256", new Aes128CbcHmacSha256());
        Default.put("A192CBC-HS384", new Aes192CbcHmacSha384());
        Default.put("A256CBC-HS512", new Aes256CbcHmacSha512());
        Default.put("A128CBC", new Aes128Cbc());
        Default.put("A192CBC", new Aes192Cbc());
        Default.put("A256CBC", new Aes256Cbc());
        Default.put("A128KW", new AesKw128());
        Default.put("A192KW", new AesKw192());
        Default.put("A256KW", new AesKw256());
        Default.put("RSA1_5", new Rsa15());
        Default.put("RSA-OAEP", new RsaOaep());
    }
}

