/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions.cryptography.algorithms;

import com.microsoft.azure.keyvault.extensions.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.AesKw;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.NoSuchPaddingException;

public final class AesKw256
extends AesKw {
    public static final String AlgorithmName = "A256KW";

    public AesKw256() {
        super(AlgorithmName);
    }

    @Override
    public ICryptoTransform CreateEncryptor(byte[] key, byte[] iv) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (key.length << 3 != 256) {
            throw new IllegalArgumentException("key must be 256 bits long");
        }
        return super.CreateEncryptor(key, iv);
    }

    @Override
    public ICryptoTransform CreateDecryptor(byte[] key, byte[] iv) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (key.length << 3 != 256) {
            throw new IllegalArgumentException("key must be 256 bits long");
        }
        return super.CreateDecryptor(key, iv);
    }
}

