/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions.cryptography.algorithms;

import com.microsoft.azure.keyvault.extensions.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.extensions.cryptography.algorithms.RsaEncryption;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public final class RsaOaep
extends RsaEncryption {
    static final String RSAOAEP = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    public static final String AlgorithmName = "RSA-OAEP";

    public RsaOaep() {
        super(AlgorithmName);
    }

    @Override
    public ICryptoTransform CreateEncryptor(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.CreateEncryptor(keyPair, null);
    }

    @Override
    public ICryptoTransform CreateEncryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return new RsaOaepEncryptor(keyPair, provider);
    }

    @Override
    public ICryptoTransform CreateDecryptor(KeyPair keyPair) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return this.CreateDecryptor(keyPair, null);
    }

    @Override
    public ICryptoTransform CreateDecryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        return new RsaOaepDecryptor(keyPair, provider);
    }

    class RsaOaepEncryptor
    implements ICryptoTransform {
        private final Cipher _cipher;

        RsaOaepEncryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
            this._cipher = provider == null ? Cipher.getInstance(RsaOaep.RSAOAEP) : Cipher.getInstance(RsaOaep.RSAOAEP, provider);
            this._cipher.init(1, keyPair.getPublic());
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this._cipher.doFinal(plaintext);
        }
    }

    class RsaOaepDecryptor
    implements ICryptoTransform {
        private final Cipher _cipher;

        RsaOaepDecryptor(KeyPair keyPair, Provider provider) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
            this._cipher = provider == null ? Cipher.getInstance(RsaOaep.RSAOAEP) : Cipher.getInstance(RsaOaep.RSAOAEP, provider);
            this._cipher.init(2, keyPair.getPrivate());
        }

        @Override
        public byte[] doFinal(byte[] plaintext) throws IllegalBlockSizeException, BadPaddingException {
            return this._cipher.doFinal(plaintext);
        }
    }
}

