/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.core.IKeyResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AggregateKeyResolver
implements IKeyResolver {
    private final List<IKeyResolver> resolvers = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IKeyResolver resolver) {
        List<IKeyResolver> list = this.resolvers;
        synchronized (list) {
            this.resolvers.add(resolver);
        }
    }

    public ListenableFuture<IKey> resolveKeyAsync(String kid) {
        return new FutureKey(kid);
    }

    class FutureKey
    extends AbstractFuture<IKey> {
        private final String kid;
        private boolean isCancelled = false;
        private boolean isDone = false;
        private IKey result = null;

        FutureKey(String kid) {
            this.kid = kid;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            this.isCancelled = true;
            return this.isCancelled;
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public boolean isDone() {
            return this.isDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IKey get() throws InterruptedException, ExecutionException {
            if (this.isCancelled) {
                throw new InterruptedException();
            }
            List list = AggregateKeyResolver.this.resolvers;
            synchronized (list) {
                for (IKeyResolver resolver : AggregateKeyResolver.this.resolvers) {
                    ListenableFuture futureKey = resolver.resolveKeyAsync(this.kid);
                    this.result = (IKey)futureKey.get();
                    if (this.result == null) continue;
                    break;
                }
            }
            this.isDone = true;
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IKey get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.isCancelled) {
                throw new InterruptedException();
            }
            List list = AggregateKeyResolver.this.resolvers;
            synchronized (list) {
                for (IKeyResolver resolver : AggregateKeyResolver.this.resolvers) {
                    ListenableFuture futureKey = resolver.resolveKeyAsync(this.kid);
                    this.result = (IKey)futureKey.get(timeout, unit);
                    if (this.result == null) continue;
                    break;
                }
            }
            this.isDone = true;
            return this.result;
        }
    }
}

