/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.core.IKeyResolver;
import java.util.concurrent.ExecutionException;

public class CachingKeyResolver
implements IKeyResolver {
    private final IKeyResolver keyResolver;
    private final LoadingCache<String, ListenableFuture<IKey>> cache;

    public CachingKeyResolver(int capacity, IKeyResolver keyResolver) {
        this.keyResolver = keyResolver;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)capacity).build((CacheLoader)new CachingKeyResolverCacheLoader(keyResolver));
    }

    public ListenableFuture<IKey> resolveKeyAsync(String kid) {
        KeyIdentifier keyIdentifier = new KeyIdentifier(kid);
        if (keyIdentifier.version() == null) {
            final ListenableFuture key = this.keyResolver.resolveKeyAsync(kid);
            key.addListener(new Runnable(){

                @Override
                public void run() {
                    try {
                        CachingKeyResolver.this.cache.put((Object)((IKey)key.get()).getKid(), (Object)key);
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        // empty catch block
                    }
                }
            }, MoreExecutors.directExecutor());
            return key;
        }
        return (ListenableFuture)this.cache.getUnchecked((Object)kid);
    }

    private static class CachingKeyResolverCacheLoader
    extends CacheLoader<String, ListenableFuture<IKey>> {
        private final IKeyResolver keyResolver;

        CachingKeyResolverCacheLoader(IKeyResolver keyResolver) {
            this.keyResolver = keyResolver;
        }

        public ListenableFuture<IKey> load(String kid) {
            return this.keyResolver.resolveKeyAsync(kid);
        }
    }
}

