/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.cryptography.RsaKey;
import com.microsoft.azure.keyvault.extensions.Strings;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.KeyOperationResult;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyEncryptionAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeySignatureAlgorithm;
import com.microsoft.azure.keyvault.webkey.JsonWebKeyType;
import com.microsoft.rest.ServiceFuture;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class KeyVaultKey
implements IKey {
    private final KeyVaultClient client;
    private IKey implementation;

    protected KeyVaultKey(KeyVaultClient client, KeyBundle keyBundle) {
        if (client == null) {
            throw new IllegalArgumentException("client");
        }
        if (keyBundle == null) {
            throw new IllegalArgumentException("keyBundle");
        }
        JsonWebKey key = keyBundle.key();
        if (key == null) {
            throw new IllegalArgumentException("keyBundle must contain a key");
        }
        if (key.kty().equals((Object)JsonWebKeyType.RSA)) {
            this.implementation = new RsaKey(key.kid(), key.toRSA(false));
        } else if (key.kty().equals((Object)JsonWebKeyType.RSA_HSM)) {
            this.implementation = new RsaKey(key.kid(), key.toRSA(false));
        }
        if (this.implementation == null) {
            throw new IllegalArgumentException(String.format("The key type %s is not supported", key.kty()));
        }
        this.client = client;
    }

    public void close() throws IOException {
        if (this.implementation != null) {
            this.implementation.close();
        }
    }

    public String getDefaultEncryptionAlgorithm() {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.getDefaultEncryptionAlgorithm();
    }

    public String getDefaultKeyWrapAlgorithm() {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.getDefaultKeyWrapAlgorithm();
    }

    public String getDefaultSignatureAlgorithm() {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.getDefaultSignatureAlgorithm();
    }

    public String getKid() {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.getKid();
    }

    public ListenableFuture<byte[]> decryptAsync(byte[] ciphertext, byte[] iv, byte[] authenticationData, byte[] authenticationTag, String algorithm) {
        if (this.implementation == null) {
            return null;
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            algorithm = this.getDefaultEncryptionAlgorithm();
        }
        ServiceFuture futureCall = this.client.decryptAsync(this.implementation.getKid(), new JsonWebKeyEncryptionAlgorithm(algorithm), ciphertext, null);
        return Futures.transform((ListenableFuture)futureCall, (Function)new DecryptResultTransform(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Triple<byte[], byte[], String>> encryptAsync(byte[] plaintext, byte[] iv, byte[] authenticationData, String algorithm) throws NoSuchAlgorithmException {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.encryptAsync(plaintext, iv, authenticationData, algorithm);
    }

    public ListenableFuture<Pair<byte[], String>> wrapKeyAsync(byte[] plaintext, String algorithm) throws NoSuchAlgorithmException {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.wrapKeyAsync(plaintext, algorithm);
    }

    public ListenableFuture<byte[]> unwrapKeyAsync(byte[] ciphertext, String algorithm) {
        if (this.implementation == null) {
            return null;
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            algorithm = this.getDefaultKeyWrapAlgorithm();
        }
        ServiceFuture futureCall = this.client.unwrapKeyAsync(this.implementation.getKid(), new JsonWebKeyEncryptionAlgorithm(algorithm), ciphertext, null);
        return Futures.transform((ListenableFuture)futureCall, (Function)new DecryptResultTransform(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Pair<byte[], String>> signAsync(byte[] digest, String algorithm) throws NoSuchAlgorithmException {
        if (this.implementation == null) {
            return null;
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            algorithm = this.getDefaultSignatureAlgorithm();
        }
        ServiceFuture futureCall = this.client.signAsync(this.implementation.getKid(), new JsonWebKeySignatureAlgorithm(algorithm), digest, null);
        return Futures.transform((ListenableFuture)futureCall, (Function)new SignResultTransform(algorithm), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<Boolean> verifyAsync(byte[] digest, byte[] signature, String algorithm) throws NoSuchAlgorithmException {
        if (this.implementation == null) {
            return null;
        }
        return this.implementation.verifyAsync(digest, signature, algorithm);
    }

    static class SignResultTransform
    implements Function<KeyOperationResult, Pair<byte[], String>> {
        private final String algorithm;

        SignResultTransform(String algorithm) {
            this.algorithm = algorithm;
        }

        public Pair<byte[], String> apply(KeyOperationResult input) {
            Objects.requireNonNull(input, "Parameter 'input' should not be null");
            return Pair.of((Object)input.result(), (Object)this.algorithm);
        }
    }

    static class DecryptResultTransform
    implements Function<KeyOperationResult, byte[]> {
        DecryptResultTransform() {
        }

        public byte[] apply(KeyOperationResult result) {
            Objects.requireNonNull(result, "Parameter 'result' should not be null");
            return result.result();
        }
    }
}

