/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.extensions;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.microsoft.azure.keyvault.KeyIdentifier;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.SecretIdentifier;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.core.IKeyResolver;
import com.microsoft.azure.keyvault.cryptography.SymmetricKey;
import com.microsoft.azure.keyvault.extensions.KeyVaultKey;
import com.microsoft.azure.keyvault.models.KeyBundle;
import com.microsoft.azure.keyvault.models.SecretBundle;
import com.microsoft.rest.ServiceFuture;
import java.security.Provider;
import java.util.concurrent.Executor;
import org.apache.commons.codec.binary.Base64;

public class KeyVaultKeyResolver
implements IKeyResolver {
    static final Base64 BASE64 = new Base64(-1, null, true);
    private final KeyVaultClient client;
    private final Provider provider;

    public KeyVaultKeyResolver(KeyVaultClient client) {
        this.client = client;
        this.provider = null;
    }

    public KeyVaultKeyResolver(KeyVaultClient client, Provider provider) {
        this.client = client;
        this.provider = provider;
    }

    private ListenableFuture<IKey> resolveKeyFromSecretAsync(String kid) {
        ServiceFuture futureCall = this.client.getSecretAsync(kid, null);
        return Futures.transform((ListenableFuture)futureCall, (Function)new FutureKeyFromSecret(), (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<IKey> resolveKeyFromKeyAsync(String kid) {
        ServiceFuture futureCall = this.client.getKeyAsync(kid, null);
        return Futures.transform((ListenableFuture)futureCall, (Function)new FutureKeyFromKey(), (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<IKey> resolveKeyAsync(String kid) {
        if (KeyIdentifier.isKeyIdentifier((String)kid)) {
            return this.resolveKeyFromKeyAsync(kid);
        }
        if (SecretIdentifier.isSecretIdentifier((String)kid)) {
            return this.resolveKeyFromSecretAsync(kid);
        }
        return Futures.immediateFuture(null);
    }

    class FutureKeyFromSecret
    implements Function<SecretBundle, IKey> {
        protected FutureKeyFromSecret() {
        }

        public IKey apply(SecretBundle secretBundle) {
            byte[] keyBytes;
            if (secretBundle != null && secretBundle.contentType().equalsIgnoreCase("application/octet-stream") && (keyBytes = BASE64.decode(secretBundle.value())) != null) {
                return new SymmetricKey(secretBundle.id(), keyBytes, KeyVaultKeyResolver.this.provider);
            }
            return null;
        }
    }

    class FutureKeyFromKey
    implements Function<KeyBundle, IKey> {
        protected FutureKeyFromKey() {
        }

        public IKey apply(KeyBundle keyBundle) {
            if (keyBundle != null) {
                return new KeyVaultKey(KeyVaultKeyResolver.this.client, keyBundle);
            }
            return null;
        }
    }
}

