/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.artifacthandler;

import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.artifacthandler.ArtifactHandler;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;

public abstract class ArtifactHandlerBase
implements ArtifactHandler {
    protected static final String DEPLOY_START = "Trying to deploy artifact to %s...";
    protected static final String DEPLOY_FINISH = "Successfully deployed the artifact to https://%s";
    protected static final String DEPLOY_ABORT = "Deployment is aborted.";
    protected MavenProject project;
    protected MavenSession session;
    protected MavenResourcesFiltering filtering;
    protected List<Resource> resources;
    protected String stagingDirectoryPath;
    protected String buildDirectoryAbsolutePath;
    protected Log log;

    protected ArtifactHandlerBase(Builder<?> builder) {
        this.project = ((Builder)builder).project;
        this.session = ((Builder)builder).session;
        this.filtering = ((Builder)builder).filtering;
        this.resources = ((Builder)builder).resources;
        this.stagingDirectoryPath = ((Builder)builder).stagingDirectoryPath;
        this.buildDirectoryAbsolutePath = ((Builder)builder).buildDirectoryAbsolutePath;
        this.log = ((Builder)builder).log;
    }

    protected void assureStagingDirectoryNotEmpty() throws MojoExecutionException {
        File stagingDirectory = new File(this.stagingDirectoryPath);
        File[] files = stagingDirectory.listFiles();
        if (!stagingDirectory.exists() || !stagingDirectory.isDirectory() || files == null || files.length == 0) {
            throw new MojoExecutionException(String.format("Staging directory: '%s' is empty.", stagingDirectory.getAbsolutePath()));
        }
    }

    protected void prepareResources() throws IOException, MojoExecutionException {
        if (this.resources == null || this.resources.isEmpty()) {
            throw new MojoExecutionException("<resources> is empty. Please make sure it is configured in pom.xml.");
        }
        Utils.copyResources(this.project, this.session, this.filtering, this.resources, this.stagingDirectoryPath);
    }

    public static abstract class Builder<T extends Builder<T>> {
        private MavenProject project;
        private MavenSession session;
        private MavenResourcesFiltering filtering;
        private List<Resource> resources;
        private String stagingDirectoryPath;
        private String buildDirectoryAbsolutePath;
        private Log log;

        protected abstract T self();

        public abstract ArtifactHandlerBase build();

        public T project(MavenProject value) {
            this.project = value;
            return this.self();
        }

        public T session(MavenSession value) {
            this.session = value;
            return this.self();
        }

        public T filtering(MavenResourcesFiltering value) {
            this.filtering = value;
            return this.self();
        }

        public T resources(List<Resource> value) {
            this.resources = value;
            return this.self();
        }

        public T stagingDirectoryPath(String value) {
            this.stagingDirectoryPath = value;
            return this.self();
        }

        public T buildDirectoryAbsolutePath(String value) {
            this.buildDirectoryAbsolutePath = value;
            return this.self();
        }

        public T log(Log value) {
            this.log = value;
            return this.self();
        }
    }
}

