/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.auth;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureCliCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.credentials.MSICredentials;
import com.microsoft.azure.management.Azure;
import com.microsoft.azure.maven.Utils;
import com.microsoft.azure.maven.auth.AuthConfiguration;
import com.microsoft.azure.maven.auth.AuthenticationSetting;
import com.microsoft.rest.LogLevel;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.StringUtils;

public class AzureAuthHelper {
    public static final String CLIENT_ID = "client";
    public static final String TENANT_ID = "tenant";
    public static final String KEY = "key";
    public static final String CERTIFICATE = "certificate";
    public static final String CERTIFICATE_PASSWORD = "certificatePassword";
    public static final String ENVIRONMENT = "environment";
    public static final String CLOUD_SHELL_ENV_KEY = "ACC_CLOUD";
    public static final String AUTH_WITH_SERVER_ID = "Authenticate with ServerId: ";
    public static final String AUTH_WITH_FILE = "Authenticate with file: ";
    public static final String AUTH_WITH_AZURE_CLI = "Authenticate with Azure CLI 2.0";
    public static final String AUTH_WITH_MSI = "In the Azure Cloud Shell, use MSI to authenticate.";
    public static final String USE_KEY_TO_AUTH = "Use key to get Azure authentication token: ";
    public static final String USE_CERTIFICATE_TO_AUTH = "Use certificate to get Azure authentication token.";
    public static final String SERVER_ID_NOT_CONFIG = "ServerId is not configured for Azure authentication.";
    public static final String CLIENT_ID_NOT_CONFIG = "Client Id of your service principal is not configured.";
    public static final String TENANT_ID_NOT_CONFIG = "Tenant Id of your service principal is not configured.";
    public static final String KEY_NOT_CONFIG = "Key of your service principal is not configured.";
    public static final String CERTIFICATE_FILE_NOT_CONFIG = "Certificate of your service principal is not configured.";
    public static final String CERTIFICATE_FILE_READ_FAIL = "Failed to read certificate file: ";
    public static final String AZURE_AUTH_INVALID = "Authentication info for Azure is not valid. ServerId=";
    public static final String AUTH_FILE_NOT_CONFIG = "Authentication file is not configured.";
    public static final String AUTH_FILE_NOT_EXIST = "Authentication file does not exist: ";
    public static final String AUTH_FILE_READ_FAIL = "Failed to read authentication file: ";
    public static final String AZURE_CLI_AUTH_FAIL = "Failed to authenticate with Azure CLI 2.0";
    protected AuthConfiguration config;

    public AzureAuthHelper(AuthConfiguration config) {
        if (config == null) {
            throw new NullPointerException();
        }
        this.config = config;
    }

    public Azure getAzureClient() {
        Azure.Authenticated auth = this.getAuthObj();
        if (auth == null) {
            return null;
        }
        try {
            String subscriptionId = this.config.getSubscriptionId();
            return StringUtils.isEmpty((String)subscriptionId) ? auth.withDefaultSubscription() : auth.withSubscription(subscriptionId);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            return null;
        }
    }

    private Log getLog() {
        return this.config.getLog();
    }

    protected LogLevel getLogLevel() {
        return this.getLog().isDebugEnabled() ? LogLevel.BODY_AND_HEADERS : LogLevel.NONE;
    }

    protected Azure.Configurable azureConfigure() {
        String httpProxyHost = this.config.getHttpProxyHost();
        int httpProxyPort = this.config.getHttpProxyPort();
        Azure.Configurable configurable = (Azure.Configurable)((Azure.Configurable)Azure.configure().withLogLevel(this.getLogLevel())).withUserAgent(this.config.getUserAgent());
        return StringUtils.isNotEmpty((String)httpProxyHost) ? (Azure.Configurable)configurable.withProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, httpProxyPort))) : configurable;
    }

    protected AzureEnvironment getAzureEnvironment(String environment) {
        if (StringUtils.isEmpty((String)environment)) {
            return AzureEnvironment.AZURE;
        }
        switch (environment.toUpperCase(Locale.ENGLISH)) {
            case "AZURE_CHINA": {
                return AzureEnvironment.AZURE_CHINA;
            }
            case "AZURE_GERMANY": {
                return AzureEnvironment.AZURE_GERMANY;
            }
            case "AZURE_US_GOVERNMENT": {
                return AzureEnvironment.AZURE_US_GOVERNMENT;
            }
        }
        return AzureEnvironment.AZURE;
    }

    protected Azure.Authenticated getAuthObj() {
        Azure.Authenticated auth;
        AuthenticationSetting authSetting = this.config.getAuthenticationSetting();
        if (authSetting != null) {
            auth = this.getAuthObjFromServerId(this.config.getSettings(), authSetting.getServerId());
            if (auth == null) {
                auth = this.getAuthObjFromFile(authSetting.getFile());
            }
        } else {
            auth = this.getAuthObjFromAzureCli();
        }
        return auth;
    }

    protected Azure.Authenticated getAuthObjFromServerId(Settings settings, String serverId) {
        if (StringUtils.isEmpty((String)serverId)) {
            this.getLog().debug((CharSequence)SERVER_ID_NOT_CONFIG);
            return null;
        }
        Server server = Utils.getServer(settings, serverId);
        try {
            Utils.assureServerExist(server, serverId);
        }
        catch (MojoExecutionException ex) {
            this.getLog().error((CharSequence)ex.getMessage());
            return null;
        }
        ApplicationTokenCredentials credential = this.getAppTokenCredentialsFromServer(server);
        if (credential == null) {
            this.getLog().error((CharSequence)(AZURE_AUTH_INVALID + serverId));
            return null;
        }
        Azure.Authenticated auth = this.azureConfigure().authenticate((AzureTokenCredentials)credential);
        if (auth != null) {
            this.getLog().info((CharSequence)(AUTH_WITH_SERVER_ID + serverId));
        }
        return auth;
    }

    protected Azure.Authenticated getAuthObjFromFile(File authFile) {
        if (authFile == null) {
            this.getLog().debug((CharSequence)AUTH_FILE_NOT_CONFIG);
            return null;
        }
        if (!authFile.exists()) {
            this.getLog().error((CharSequence)(AUTH_FILE_NOT_EXIST + authFile.getAbsolutePath()));
            return null;
        }
        try {
            Azure.Authenticated auth = this.azureConfigure().authenticate(authFile);
            if (auth != null) {
                this.getLog().info((CharSequence)(AUTH_WITH_FILE + authFile.getAbsolutePath()));
            }
            return auth;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)(AUTH_FILE_READ_FAIL + authFile.getAbsolutePath()));
            this.getLog().error((Throwable)e);
            return null;
        }
    }

    protected Azure.Authenticated getAuthObjFromAzureCli() {
        try {
            Azure.Authenticated auth;
            Azure.Configurable azureConfigurable = this.azureConfigure();
            if (AzureAuthHelper.isInCloudShell()) {
                this.getLog().info((CharSequence)AUTH_WITH_MSI);
                auth = azureConfigurable.authenticate((AzureTokenCredentials)new MSICredentials());
            } else {
                this.getLog().info((CharSequence)AUTH_WITH_AZURE_CLI);
                auth = azureConfigurable.authenticate((AzureTokenCredentials)AzureCliCredentials.create());
            }
            return auth;
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)AZURE_CLI_AUTH_FAIL);
            this.getLog().debug((Throwable)e);
            return null;
        }
    }

    protected ApplicationTokenCredentials getAppTokenCredentialsFromServer(Server server) {
        if (server == null) {
            return null;
        }
        String clientId = Utils.getValueFromServerConfiguration(server, CLIENT_ID);
        if (StringUtils.isEmpty((String)clientId)) {
            this.getLog().debug((CharSequence)CLIENT_ID_NOT_CONFIG);
            return null;
        }
        String tenantId = Utils.getValueFromServerConfiguration(server, TENANT_ID);
        if (StringUtils.isEmpty((String)tenantId)) {
            this.getLog().debug((CharSequence)TENANT_ID_NOT_CONFIG);
            return null;
        }
        String environment = Utils.getValueFromServerConfiguration(server, ENVIRONMENT);
        AzureEnvironment azureEnvironment = this.getAzureEnvironment(environment);
        this.getLog().debug((CharSequence)("Azure Management Endpoint: " + azureEnvironment.managementEndpoint()));
        String key = Utils.getValueFromServerConfiguration(server, KEY);
        if (!StringUtils.isEmpty((String)key)) {
            this.getLog().debug((CharSequence)USE_KEY_TO_AUTH);
            return new ApplicationTokenCredentials(clientId, tenantId, key, azureEnvironment);
        }
        this.getLog().debug((CharSequence)KEY_NOT_CONFIG);
        String certificate = Utils.getValueFromServerConfiguration(server, CERTIFICATE);
        if (StringUtils.isEmpty((String)certificate)) {
            this.getLog().debug((CharSequence)CERTIFICATE_FILE_NOT_CONFIG);
            return null;
        }
        String certificatePassword = Utils.getValueFromServerConfiguration(server, CERTIFICATE_PASSWORD);
        try {
            byte[] cert = Files.readAllBytes(Paths.get(certificate, new String[0]));
            this.getLog().debug((CharSequence)(USE_CERTIFICATE_TO_AUTH + certificate));
            return new ApplicationTokenCredentials(clientId, tenantId, cert, certificatePassword, azureEnvironment);
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)(CERTIFICATE_FILE_READ_FAIL + certificate));
            return null;
        }
    }

    private static boolean isInCloudShell() {
        return System.getenv(CLOUD_SHELL_ENV_KEY) != null;
    }
}

