/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.microsoft.azure.management.Azure;
import com.microsoft.azure.management.appservice.AppServicePlan;
import java.util.UUID;
import org.codehaus.plexus.util.StringUtils;

public class AppServiceUtils {
    public static AppServicePlan getAppServicePlan(String servicePlanName, Azure azureClient, String resourceGroup, String servicePlanResourceGroup) {
        if (StringUtils.isNotEmpty((String)servicePlanName)) {
            String servicePlanResGrp = AppServiceUtils.getAppServicePlanResourceGroup(resourceGroup, servicePlanResourceGroup);
            return (AppServicePlan)azureClient.appServices().appServicePlans().getByResourceGroup(servicePlanResGrp, servicePlanName);
        }
        return null;
    }

    public static String getAppServicePlanResourceGroup(String resourceGroup, String appServicePlanResGrp) {
        return StringUtils.isEmpty((String)appServicePlanResGrp) ? resourceGroup : appServicePlanResGrp;
    }

    public static String getAppServicePlanName(String servicePlanName) {
        return StringUtils.isEmpty((String)servicePlanName) ? AppServiceUtils.generateRandomServicePlanName() : servicePlanName;
    }

    private static String generateRandomServicePlanName() {
        return "ServicePlan" + UUID.randomUUID().toString().substring(0, 18);
    }
}

