/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.authentication;

import com.microsoft.aad.adal4j.AsymmetricKeyCredential;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.windowsazure.services.media.authentication.AzureAdClientSymmetricKey;
import com.microsoft.windowsazure.services.media.authentication.AzureAdClientUsernamePassword;
import com.microsoft.windowsazure.services.media.authentication.AzureAdTokenCredentialType;
import com.microsoft.windowsazure.services.media.authentication.AzureEnvironment;

public class AzureAdTokenCredentials {
    private String tenant;
    private ClientCredential clientKey;
    private AsymmetricKeyCredential asymmetricKeyCredential;
    private AzureAdClientUsernamePassword azureAdClientUsernamePassword;
    private AzureAdTokenCredentialType credentialType;
    private AzureEnvironment azureEnvironment;

    public String getTenant() {
        return this.tenant;
    }

    public AzureAdClientUsernamePassword getAzureAdClientUsernamePassword() {
        return this.azureAdClientUsernamePassword;
    }

    public ClientCredential getClientKey() {
        return this.clientKey;
    }

    public AsymmetricKeyCredential getAsymmetricKeyCredential() {
        return this.asymmetricKeyCredential;
    }

    public AzureAdTokenCredentialType getCredentialType() {
        return this.credentialType;
    }

    public AzureEnvironment getAzureEnvironment() {
        return this.azureEnvironment;
    }

    public AzureAdTokenCredentials(String tenant, AzureAdClientUsernamePassword azureAdClientUsernamePassword, AzureEnvironment azureEnvironment) {
        if (tenant == null || tenant.trim().isEmpty()) {
            throw new IllegalArgumentException("tenant");
        }
        if (azureAdClientUsernamePassword == null) {
            throw new NullPointerException("azureAdClientUsernamePassword");
        }
        if (azureEnvironment == null) {
            throw new NullPointerException("azureEnvironment");
        }
        this.tenant = tenant;
        this.azureAdClientUsernamePassword = azureAdClientUsernamePassword;
        this.azureEnvironment = azureEnvironment;
        this.credentialType = AzureAdTokenCredentialType.UserSecretCredential;
    }

    public AzureAdTokenCredentials(String tenant, AzureEnvironment azureEnvironment) {
        if (tenant == null || tenant.trim().isEmpty()) {
            throw new IllegalArgumentException("tenant");
        }
        if (azureEnvironment == null) {
            throw new NullPointerException("azureEnvironment");
        }
        this.tenant = tenant;
        this.azureEnvironment = azureEnvironment;
        this.credentialType = AzureAdTokenCredentialType.UserSecretCredential;
    }

    public AzureAdTokenCredentials(String tenant, AzureAdClientSymmetricKey azureAdClientSymmetricKey, AzureEnvironment azureEnvironment) {
        if (tenant == null || tenant.trim().isEmpty()) {
            throw new IllegalArgumentException("tenant");
        }
        if (azureAdClientSymmetricKey == null) {
            throw new NullPointerException("azureAdClientSymmetricKey");
        }
        if (azureEnvironment == null) {
            throw new NullPointerException("azureEnvironment");
        }
        this.tenant = tenant;
        this.azureEnvironment = azureEnvironment;
        this.clientKey = new ClientCredential(azureAdClientSymmetricKey.getClientId(), azureAdClientSymmetricKey.getClientKey());
        this.credentialType = AzureAdTokenCredentialType.ServicePrincipalWithClientSymmetricKey;
    }

    public AzureAdTokenCredentials(String tenant, AsymmetricKeyCredential asymmetricKeyCredential, AzureEnvironment azureEnvironment) {
        if (tenant == null || tenant.trim().isEmpty()) {
            throw new IllegalArgumentException("tenant");
        }
        if (asymmetricKeyCredential == null) {
            throw new NullPointerException("asymmetricKeyCredential");
        }
        if (azureEnvironment == null) {
            throw new NullPointerException("azureEnvironment");
        }
        this.tenant = tenant;
        this.azureEnvironment = azureEnvironment;
        this.asymmetricKeyCredential = asymmetricKeyCredential;
        this.credentialType = AzureAdTokenCredentialType.ServicePrincipalWithClientCertificate;
    }
}

