/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.entityoperations;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.EntityListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import javax.ws.rs.core.MultivaluedMap;

public class DefaultListOperation<T>
extends EntityOperationBase
implements EntityListOperation<T> {
    private final MultivaluedMap<String, String> queryParameters = new MultivaluedMapImpl();
    private final GenericType<ListResult<T>> responseType;

    public DefaultListOperation(String entityUri, GenericType<ListResult<T>> responseType) {
        super(entityUri);
        this.responseType = responseType;
    }

    public DefaultListOperation(String entityUri, GenericType<ListResult<T>> responseType, MultivaluedMap<String, String> queryParameters) {
        this(entityUri, responseType);
        this.queryParameters.putAll(queryParameters);
    }

    public DefaultListOperation<T> setTop(int topValue) {
        this.queryParameters.add((Object)"$top", (Object)Integer.toString(topValue));
        return this;
    }

    public DefaultListOperation<T> setSkip(int skipValue) {
        this.queryParameters.add((Object)"$skip", (Object)Integer.toString(skipValue));
        return this;
    }

    public DefaultListOperation<T> set(String parameterName, String parameterValue) {
        this.queryParameters.add((Object)parameterName, (Object)parameterValue);
        return this;
    }

    @Override
    public MultivaluedMap<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    @Override
    public GenericType<ListResult<T>> getResponseGenericType() {
        return this.responseType;
    }

    @Override
    public Object processResponse(Object rawResponse) throws ServiceException {
        return rawResponse;
    }
}

