/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Named;
import javax.ws.rs.core.UriBuilder;

public class ResourceLocationManager {
    private URI baseURI;

    public ResourceLocationManager(@Named(value="media.azuread.account_api_uri") String baseUri) throws URISyntaxException {
        this.baseURI = new URI(baseUri);
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public URI getRedirectedURI(URI originalURI) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.baseURI).path(originalURI.getPath());
        String queryString = originalURI.getRawQuery();
        if (queryString != null && !queryString.isEmpty()) {
            uriBuilder.replaceQuery(queryString);
        }
        return uriBuilder.build(new Object[0]);
    }

    public void setRedirectedURI(String newURI) throws URISyntaxException {
        this.baseURI = new URI(newURI);
    }
}

