/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.ContentKeyAuthorizationPolicyOptionType;
import com.microsoft.windowsazure.services.media.implementation.content.ContentKeyAuthorizationPolicyRestrictionType;
import com.microsoft.windowsazure.services.media.models.ContentKeyAuthorizationPolicyOptionInfo;
import com.microsoft.windowsazure.services.media.models.ContentKeyAuthorizationPolicyRestriction;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.List;

public final class ContentKeyAuthorizationPolicyOption {
    private static final String ENTITY_SET = "ContentKeyAuthorizationPolicyOptions";

    private ContentKeyAuthorizationPolicyOption() {
    }

    public static EntityCreateOperation<ContentKeyAuthorizationPolicyOptionInfo> create(String name, int keyDeliveryType, String keyDeliveryConfiguration, List<ContentKeyAuthorizationPolicyRestriction> restrictions) {
        return new Creator(name, keyDeliveryType, keyDeliveryConfiguration, restrictions);
    }

    public static EntityGetOperation<ContentKeyAuthorizationPolicyOptionInfo> get(String contentKeyAuthorizationPolicyOptionId) {
        return new DefaultGetOperation<ContentKeyAuthorizationPolicyOptionInfo>(ENTITY_SET, contentKeyAuthorizationPolicyOptionId, ContentKeyAuthorizationPolicyOptionInfo.class);
    }

    public static DefaultListOperation<ContentKeyAuthorizationPolicyOptionInfo> list(LinkInfo<ContentKeyAuthorizationPolicyOptionInfo> link) {
        return new DefaultListOperation<ContentKeyAuthorizationPolicyOptionInfo>(link.getHref(), new GenericType<ListResult<ContentKeyAuthorizationPolicyOptionInfo>>(){});
    }

    public static DefaultListOperation<ContentKeyAuthorizationPolicyOptionInfo> list() {
        return new DefaultListOperation<ContentKeyAuthorizationPolicyOptionInfo>(ENTITY_SET, new GenericType<ListResult<ContentKeyAuthorizationPolicyOptionInfo>>(){});
    }

    public static EntityDeleteOperation delete(String contentKeyAuthorizationPolicyOptionId) {
        return new DefaultDeleteOperation(ENTITY_SET, contentKeyAuthorizationPolicyOptionId);
    }

    public static Updater update(String contentKeyAuthorizationPolicyOptionId) {
        return new Updater(contentKeyAuthorizationPolicyOptionId);
    }

    public static class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private int keyDeliveryType;
        private String keyDeliveryConfiguration;
        private List<ContentKeyAuthorizationPolicyRestrictionType> restrictions;

        protected Updater(String contentKeyAuthorizationPolicyOptionId) {
            super(new EntityOperationBase.EntityIdUriBuilder(ContentKeyAuthorizationPolicyOption.ENTITY_SET, contentKeyAuthorizationPolicyOptionId));
        }

        @Override
        public Object getRequestContents() {
            return new ContentKeyAuthorizationPolicyOptionType().setKeyDeliveryType(this.keyDeliveryType).setKeyDeliveryConfiguration(this.keyDeliveryConfiguration).setRestrictions(this.restrictions);
        }

        public Updater setKeyDeliveryType(int keyDeliveryType) {
            this.keyDeliveryType = keyDeliveryType;
            return this;
        }

        public Updater setKeyDeliveryConfiguration(String keyDeliveryConfiguration) {
            this.keyDeliveryConfiguration = keyDeliveryConfiguration;
            return this;
        }

        public Updater setRestrictions(List<ContentKeyAuthorizationPolicyRestriction> restrictions) {
            this.restrictions = new ArrayList<ContentKeyAuthorizationPolicyRestrictionType>();
            for (ContentKeyAuthorizationPolicyRestriction restriction : restrictions) {
                this.restrictions.add(new ContentKeyAuthorizationPolicyRestrictionType().setName(restriction.getName()).setKeyRestrictionType(restriction.getKeyRestrictionType()).setRequirements(restriction.getRequirements()));
            }
            return this;
        }
    }

    private static class Creator
    extends EntityOperationSingleResultBase<ContentKeyAuthorizationPolicyOptionInfo>
    implements EntityCreateOperation<ContentKeyAuthorizationPolicyOptionInfo> {
        private String name;
        private int keyDeliveryType;
        private String keyDeliveryConfiguration;
        private List<ContentKeyAuthorizationPolicyRestrictionType> restrictions;

        public Creator(String name, int keyDeliveryType, String keyDeliveryConfiguration, List<ContentKeyAuthorizationPolicyRestriction> restrictions) {
            super(ContentKeyAuthorizationPolicyOption.ENTITY_SET, ContentKeyAuthorizationPolicyOptionInfo.class);
            this.name = name;
            this.keyDeliveryType = keyDeliveryType;
            this.keyDeliveryConfiguration = keyDeliveryConfiguration;
            this.restrictions = new ArrayList<ContentKeyAuthorizationPolicyRestrictionType>();
            for (ContentKeyAuthorizationPolicyRestriction restriction : restrictions) {
                this.restrictions.add(new ContentKeyAuthorizationPolicyRestrictionType().setName(restriction.getName()).setKeyRestrictionType(restriction.getKeyRestrictionType()).setRequirements(restriction.getRequirements()));
            }
        }

        @Override
        public Object getRequestContents() {
            return new ContentKeyAuthorizationPolicyOptionType().setName(this.name).setKeyDeliveryType(this.keyDeliveryType).setKeyDeliveryConfiguration(this.keyDeliveryConfiguration).setRestrictions(this.restrictions);
        }
    }
}

