/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.LocatorRestType;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.microsoft.windowsazure.services.media.models.LocatorInfo;
import com.microsoft.windowsazure.services.media.models.LocatorType;
import com.sun.jersey.api.client.GenericType;
import java.util.Date;

public final class Locator {
    private static final String ENTITY_SET = "Locators";

    private Locator() {
    }

    public static Creator create(String accessPolicyId, String assetId, LocatorType locatorType) {
        return new Creator(accessPolicyId, assetId, locatorType);
    }

    public static EntityGetOperation<LocatorInfo> get(String locatorId) {
        return new DefaultGetOperation<LocatorInfo>(ENTITY_SET, locatorId, LocatorInfo.class);
    }

    public static DefaultListOperation<LocatorInfo> list() {
        return new DefaultListOperation<LocatorInfo>(ENTITY_SET, new GenericType<ListResult<LocatorInfo>>(){});
    }

    public static DefaultListOperation<LocatorInfo> list(LinkInfo<LocatorInfo> link) {
        return new DefaultListOperation<LocatorInfo>(link.getHref(), new GenericType<ListResult<LocatorInfo>>(){});
    }

    public static Updater update(String locatorId) {
        return new Updater(locatorId);
    }

    public static EntityDeleteOperation delete(String locatorId) {
        return new DefaultDeleteOperation(ENTITY_SET, locatorId);
    }

    public static class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private Date startDateTime;

        public Updater(String locatorId) {
            super(new EntityOperationBase.EntityIdUriBuilder(Locator.ENTITY_SET, locatorId));
        }

        @Override
        public Object getRequestContents() {
            return new LocatorRestType().setStartTime(this.startDateTime);
        }

        @Override
        public void setProxyData(EntityProxyData proxyData) {
        }

        public Updater setStartDateTime(Date startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }
    }

    public static class Creator
    extends EntityOperationSingleResultBase<LocatorInfo>
    implements EntityCreateOperation<LocatorInfo> {
        private final String accessPolicyId;
        private final String assetId;
        private String baseUri;
        private String contentAccessComponent;
        private final LocatorType locatorType;
        private String path;
        private Date startDateTime;
        private String id;

        protected Creator(String accessPolicyId, String assetId, LocatorType locatorType) {
            super(Locator.ENTITY_SET, LocatorInfo.class);
            this.accessPolicyId = accessPolicyId;
            this.assetId = assetId;
            this.locatorType = locatorType;
        }

        @Override
        public Object getRequestContents() {
            return new LocatorRestType().setId(this.id).setAccessPolicyId(this.accessPolicyId).setAssetId(this.assetId).setStartTime(this.startDateTime).setType(this.locatorType.getCode()).setBaseUri(this.baseUri).setContentAccessComponent(this.contentAccessComponent).setPath(this.path);
        }

        public Creator setBaseUri(String baseUri) {
            this.baseUri = baseUri;
            return this;
        }

        public Creator setPath(String path) {
            this.path = path;
            return this;
        }

        public Creator setStartDateTime(Date startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public Creator setContentAccessComponent(String contentAccessComponent) {
            this.contentAccessComponent = contentAccessComponent;
            return this;
        }

        public EntityCreateOperation<LocatorInfo> setId(String id) {
            this.id = id;
            return this;
        }
    }
}

