/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.NotificationEndPointType;
import com.microsoft.windowsazure.services.media.models.EndPointType;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.microsoft.windowsazure.services.media.models.NotificationEndPointInfo;
import com.sun.jersey.api.client.GenericType;

public final class NotificationEndPoint {
    private static final String ENTITY_SET = "NotificationEndPoints";

    private NotificationEndPoint() {
    }

    public static EntityCreateOperation<NotificationEndPointInfo> create(String name, EndPointType endPointType, String endPointAddress) {
        return new Creator(name, endPointType, endPointAddress);
    }

    public static EntityGetOperation<NotificationEndPointInfo> get(String notificationEndPointId) {
        return new DefaultGetOperation<NotificationEndPointInfo>(ENTITY_SET, notificationEndPointId, NotificationEndPointInfo.class);
    }

    public static EntityGetOperation<NotificationEndPointInfo> get(LinkInfo<NotificationEndPointInfo> link) {
        return new DefaultGetOperation<NotificationEndPointInfo>(link.getHref(), NotificationEndPointInfo.class);
    }

    public static DefaultListOperation<NotificationEndPointInfo> list() {
        return new DefaultListOperation<NotificationEndPointInfo>(ENTITY_SET, new GenericType<ListResult<NotificationEndPointInfo>>(){});
    }

    public static Updater update(String notificationEndPointId) {
        return new Updater(notificationEndPointId);
    }

    public static EntityDeleteOperation delete(String notificationEndPointId) {
        return new DefaultDeleteOperation(ENTITY_SET, notificationEndPointId);
    }

    public static class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private String name;

        protected Updater(String notificationEndPointId) {
            super(new EntityOperationBase.EntityIdUriBuilder(NotificationEndPoint.ENTITY_SET, notificationEndPointId));
        }

        @Override
        public Object getRequestContents() {
            NotificationEndPointType notificationEndPointType = new NotificationEndPointType();
            notificationEndPointType.setName(this.name);
            return notificationEndPointType;
        }

        public Updater setName(String name) {
            this.name = name;
            return this;
        }
    }

    public static class Creator
    extends EntityOperationSingleResultBase<NotificationEndPointInfo>
    implements EntityCreateOperation<NotificationEndPointInfo> {
        private final String name;
        private final EndPointType endPointType;
        private final String endPointAddress;

        public Creator(String name, EndPointType endPointType, String endPointAddress) {
            super(NotificationEndPoint.ENTITY_SET, NotificationEndPointInfo.class);
            this.name = name;
            this.endPointType = endPointType;
            this.endPointAddress = endPointAddress;
        }

        @Override
        public Object getRequestContents() {
            return new NotificationEndPointType().setName(this.name).setEndPointType(this.endPointType.getCode()).setEndPointAddress(this.endPointAddress);
        }
    }
}

