/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultEntityActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import com.microsoft.windowsazure.services.media.entityoperations.EntityUpdateOperation;
import com.microsoft.windowsazure.services.media.implementation.content.CrossSiteAccessPoliciesType;
import com.microsoft.windowsazure.services.media.implementation.content.StreamingEndpointAccessControlType;
import com.microsoft.windowsazure.services.media.implementation.content.StreamingEndpointCacheControlType;
import com.microsoft.windowsazure.services.media.implementation.content.StreamingEndpointType;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.microsoft.windowsazure.services.media.models.StreamingEndpointInfo;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.List;

public final class StreamingEndpoint {
    private static final String ENTITY_SET = "StreamingEndpoints";

    private StreamingEndpoint() {
    }

    public static Creator create() {
        return new Creator();
    }

    public static EntityGetOperation<StreamingEndpointInfo> get(String streamingEndpointId) {
        return new DefaultGetOperation<StreamingEndpointInfo>(ENTITY_SET, streamingEndpointId, StreamingEndpointInfo.class);
    }

    public static DefaultListOperation<StreamingEndpointInfo> list() {
        return new DefaultListOperation<StreamingEndpointInfo>(ENTITY_SET, new GenericType<ListResult<StreamingEndpointInfo>>(){});
    }

    public static Updater update(String streamingEndpointId) {
        return new Updater(streamingEndpointId);
    }

    public static Updater update(StreamingEndpointInfo streamingEndpointInfo) {
        return new Updater(streamingEndpointInfo);
    }

    public static EntityDeleteOperation delete(String streamingEndpointId) {
        return new DefaultDeleteOperation(ENTITY_SET, streamingEndpointId);
    }

    public static EntityActionOperation start(String streamingEndpointId) {
        return new DefaultEntityActionOperation(ENTITY_SET, streamingEndpointId, "Start");
    }

    public static EntityActionOperation stop(String streamingEndpointId) {
        return new DefaultEntityActionOperation(ENTITY_SET, streamingEndpointId, "Stop");
    }

    public static EntityActionOperation scale(String streamingEndpointId, int scaleUnits) {
        DefaultEntityActionOperation operation = new DefaultEntityActionOperation(ENTITY_SET, streamingEndpointId, "Scale");
        operation.addBodyParameter("scaleUnits", scaleUnits);
        return operation;
    }

    public static class Updater
    extends EntityOperationBase
    implements EntityUpdateOperation {
        private String description = null;
        private boolean cdnEnabled;
        private List<String> customHostNames = null;
        private StreamingEndpointAccessControlType streamingEndpointAccessControl = null;
        private StreamingEndpointCacheControlType streamingEndpointCacheControl = null;
        private CrossSiteAccessPoliciesType crossSiteAccessPolicies = null;

        protected Updater(String streamingEndpointId) {
            super(new EntityOperationBase.EntityIdUriBuilder(StreamingEndpoint.ENTITY_SET, streamingEndpointId));
        }

        protected Updater(StreamingEndpointInfo streamingEndpointInfo) {
            super(new EntityOperationBase.EntityIdUriBuilder(StreamingEndpoint.ENTITY_SET, streamingEndpointInfo.getId()));
            this.setCdnEnabled(streamingEndpointInfo.isCdnEnabled());
            this.setCustomHostNames(streamingEndpointInfo.getCustomHostNames());
            this.setDescription(streamingEndpointInfo.getDescription());
            this.setCrossSiteAccessPolicies(streamingEndpointInfo.getCrossSiteAccessPolicies());
            this.setAccessControl(streamingEndpointInfo.getAccessControl());
            this.setCacheControl(streamingEndpointInfo.getCacheControl());
        }

        @Override
        public void setProxyData(EntityProxyData proxyData) {
        }

        @Override
        public Object getRequestContents() {
            StreamingEndpointType streamingEndpointType = new StreamingEndpointType();
            streamingEndpointType.setDescription(this.description);
            streamingEndpointType.setCdnEnabled(this.cdnEnabled);
            streamingEndpointType.setCustomHostName(this.customHostNames);
            streamingEndpointType.setCrossSiteAccessPolicies(this.crossSiteAccessPolicies);
            streamingEndpointType.setAccessControl(this.streamingEndpointAccessControl);
            streamingEndpointType.setCacheControl(this.streamingEndpointCacheControl);
            return streamingEndpointType;
        }

        public Updater setDescription(String description) {
            this.description = description;
            return this;
        }

        public Updater setCdnEnabled(boolean cdnEnabled) {
            this.cdnEnabled = cdnEnabled;
            return this;
        }

        public Updater setAccessControl(StreamingEndpointAccessControlType streamingEndpointAccessControl) {
            this.streamingEndpointAccessControl = streamingEndpointAccessControl;
            return this;
        }

        public Updater setCustomHostNames(List<String> customHostNames) {
            this.customHostNames = customHostNames;
            return this;
        }

        public Updater setCacheControl(StreamingEndpointCacheControlType streamingEndpointCacheControl) {
            this.streamingEndpointCacheControl = streamingEndpointCacheControl;
            return this;
        }

        public Updater setCrossSiteAccessPolicies(CrossSiteAccessPoliciesType crossSiteAccessPolicies) {
            this.crossSiteAccessPolicies = crossSiteAccessPolicies;
            return this;
        }
    }

    public static class Creator
    extends EntityOperationSingleResultBase<StreamingEndpointInfo>
    implements EntityCreateOperation<StreamingEndpointInfo> {
        private String name;
        private String description;
        private int scaleUnits;
        private boolean cdnEnabled;
        private List<String> customHostNames;
        private StreamingEndpointAccessControlType streamingEndpointAccessControl;
        private StreamingEndpointCacheControlType streamingEndpointCacheControl;
        private CrossSiteAccessPoliciesType crossSiteAccessPolicies;

        public Creator() {
            super(StreamingEndpoint.ENTITY_SET, StreamingEndpointInfo.class);
        }

        @Override
        public Class getResponseClass() {
            return ClientResponse.class;
        }

        @Override
        public Object processResponse(Object rawResponse) throws ServiceException {
            List operationIds;
            ClientResponse clientResponse = (ClientResponse)rawResponse;
            if (clientResponse.getStatus() >= 300) {
                clientResponse.bufferEntity();
                throw new UniformInterfaceException(String.format("Received: %s", clientResponse.getEntity(String.class)), clientResponse);
            }
            StreamingEndpointInfo streamingEndpointInfo = (StreamingEndpointInfo)clientResponse.getEntity(StreamingEndpointInfo.class);
            if (clientResponse.getHeaders().containsKey((Object)"operation-id") && (operationIds = (List)clientResponse.getHeaders().get((Object)"operation-id")).size() >= 0) {
                streamingEndpointInfo.setOperationId((String)operationIds.get(0));
            }
            return streamingEndpointInfo;
        }

        @Override
        public Object getRequestContents() {
            StreamingEndpointType streamingEndpointType = new StreamingEndpointType();
            streamingEndpointType.setName(this.name);
            streamingEndpointType.setDescription(this.description);
            streamingEndpointType.setCdnEnabled(this.cdnEnabled);
            streamingEndpointType.setCustomHostName(this.customHostNames);
            streamingEndpointType.setCrossSiteAccessPolicies(this.crossSiteAccessPolicies);
            streamingEndpointType.setScaleUnits(this.scaleUnits);
            streamingEndpointType.setAccessControl(this.streamingEndpointAccessControl);
            streamingEndpointType.setCacheControl(this.streamingEndpointCacheControl);
            return streamingEndpointType;
        }

        public Creator setName(String name) {
            this.name = name;
            return this;
        }

        public Creator setDescription(String description) {
            this.description = description;
            return this;
        }

        public Creator setScaleUnits(int scaleUnits) {
            this.scaleUnits = scaleUnits;
            return this;
        }

        public Creator setCdnEnabled(boolean cdnEnabled) {
            this.cdnEnabled = cdnEnabled;
            return this;
        }

        public Creator setAccessControl(StreamingEndpointAccessControlType streamingEndpointAccessControl) {
            this.streamingEndpointAccessControl = streamingEndpointAccessControl;
            return this;
        }

        public Creator setCustomHostNames(List<String> customHostNames) {
            this.customHostNames = customHostNames;
            return this;
        }

        public Creator setCacheControl(StreamingEndpointCacheControlType streamingEndpointCacheControl) {
            this.streamingEndpointCacheControl = streamingEndpointCacheControl;
            return this;
        }

        public Creator setCrossSiteAccessPolicies(CrossSiteAccessPoliciesType crossSiteAccessPolicies) {
            this.crossSiteAccessPolicies = crossSiteAccessPolicies;
            return this;
        }
    }
}

