/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.implementation.ODataEntity;
import com.microsoft.windowsazure.services.media.implementation.atom.EntryType;
import com.microsoft.windowsazure.services.media.implementation.content.ErrorDetailType;
import com.microsoft.windowsazure.services.media.implementation.content.TaskHistoricalEventType;
import com.microsoft.windowsazure.services.media.implementation.content.TaskType;
import com.microsoft.windowsazure.services.media.models.AssetInfo;
import com.microsoft.windowsazure.services.media.models.ErrorDetail;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.TaskHistoricalEvent;
import com.microsoft.windowsazure.services.media.models.TaskOption;
import com.microsoft.windowsazure.services.media.models.TaskState;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TaskInfo
extends ODataEntity<TaskType> {
    public TaskInfo(EntryType entry, TaskType content) {
        super(entry, content);
    }

    public String getId() {
        return ((TaskType)this.getContent()).getId();
    }

    public String getConfiguration() {
        return ((TaskType)this.getContent()).getConfiguration();
    }

    public Date getEndTime() {
        return ((TaskType)this.getContent()).getEndTime();
    }

    public List<ErrorDetail> getErrorDetails() {
        ArrayList<ErrorDetail> result = new ArrayList<ErrorDetail>();
        List<ErrorDetailType> errorDetailTypes = ((TaskType)this.getContent()).getErrorDetails();
        if (errorDetailTypes != null) {
            for (ErrorDetailType errorDetailType : errorDetailTypes) {
                ErrorDetail errorDetail = new ErrorDetail(errorDetailType.getCode(), errorDetailType.getMessage());
                result.add(errorDetail);
            }
            return result;
        }
        return null;
    }

    public List<TaskHistoricalEvent> getHistoricalEvents() {
        ArrayList<TaskHistoricalEvent> result = new ArrayList<TaskHistoricalEvent>();
        List<TaskHistoricalEventType> historicalEventTypes = ((TaskType)this.getContent()).getHistoricalEventTypes();
        if (historicalEventTypes != null) {
            for (TaskHistoricalEventType taskHistoricalEventType : historicalEventTypes) {
                String message = taskHistoricalEventType.getMessage();
                if (message != null && message.isEmpty()) {
                    message = null;
                }
                TaskHistoricalEvent taskHistoricalEvent = new TaskHistoricalEvent(taskHistoricalEventType.getCode(), message, taskHistoricalEventType.getTimeStamp());
                result.add(taskHistoricalEvent);
            }
        }
        return result;
    }

    public String getMediaProcessorId() {
        return ((TaskType)this.getContent()).getMediaProcessorId();
    }

    public String getName() {
        return ((TaskType)this.getContent()).getName();
    }

    public String getPerfMessage() {
        return ((TaskType)this.getContent()).getPerfMessage();
    }

    public int getPriority() {
        return ((TaskType)this.getContent()).getPriority();
    }

    public double getProgress() {
        return ((TaskType)this.getContent()).getProgress();
    }

    public double getRunningDuration() {
        return ((TaskType)this.getContent()).getRunningDuration();
    }

    public Date getStartTime() {
        return ((TaskType)this.getContent()).getStartTime();
    }

    public TaskState getState() {
        return TaskState.fromCode(((TaskType)this.getContent()).getState());
    }

    public String getTaskBody() {
        return ((TaskType)this.getContent()).getTaskBody();
    }

    public TaskOption getOptions() {
        return TaskOption.fromCode(((TaskType)this.getContent()).getOptions());
    }

    public String getEncryptionKeyId() {
        return ((TaskType)this.getContent()).getEncryptionKeyId();
    }

    public String getEncryptionScheme() {
        return ((TaskType)this.getContent()).getEncryptionScheme();
    }

    public String getEncryptionVersion() {
        return ((TaskType)this.getContent()).getEncryptionVersion();
    }

    public String getInitializationVector() {
        return ((TaskType)this.getContent()).getInitializationVector();
    }

    public LinkInfo<AssetInfo> getInputAssetsLink() {
        return this.getRelationLink("InputMediaAssets");
    }

    public LinkInfo<AssetInfo> getOutputAssetsLink() {
        return this.getRelationLink("OutputMediaAssets");
    }
}

