/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.microsoft.azure.Page;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.AppSetting;
import com.microsoft.azure.management.appservice.ConnectionString;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.HostNameBinding;
import com.microsoft.azure.management.appservice.PublishingProfile;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebAppSourceControl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.ConnectionStringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.CsmPublishingProfileOptionsInner;
import com.microsoft.azure.management.appservice.implementation.CsmSlotEntityInner;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingImpl;
import com.microsoft.azure.management.appservice.implementation.HostNameBindingInner;
import com.microsoft.azure.management.appservice.implementation.IdentifierInner;
import com.microsoft.azure.management.appservice.implementation.MSDeployInner;
import com.microsoft.azure.management.appservice.implementation.MSDeployStatusInner;
import com.microsoft.azure.management.appservice.implementation.PublishingProfileImpl;
import com.microsoft.azure.management.appservice.implementation.SiteAuthSettingsInner;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.SiteSourceControlInner;
import com.microsoft.azure.management.appservice.implementation.SlotConfigNamesResourceInner;
import com.microsoft.azure.management.appservice.implementation.StringDictionaryInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppSourceControlImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class DeploymentSlotImpl
extends WebAppBaseImpl<DeploymentSlot, DeploymentSlotImpl>
implements DeploymentSlot,
DeploymentSlot.Definition,
DeploymentSlot.Update {
    private final WebAppImpl parent;
    private final String name;

    DeploymentSlotImpl(String name, SiteInner innerObject, SiteConfigResourceInner configObject, WebAppImpl parent) {
        super(name.replaceAll(".*/", ""), innerObject, configObject, (AppServiceManager)parent.manager());
        this.name = name.replaceAll(".*/", "");
        this.parent = parent;
        ((SiteInner)((Object)this.inner())).withServerFarmId(parent.appServicePlanId());
        ((SiteInner)((Object)this.inner())).withLocation(this.regionName());
    }

    public String name() {
        return this.name;
    }

    @Override
    public Map<String, HostNameBinding> getHostNameBindings() {
        return (Map)this.getHostNameBindingsAsync().toBlocking().single();
    }

    @Override
    public Observable<Map<String, HostNameBinding>> getHostNameBindingsAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listHostNameBindingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap((Func1)new Func1<Page<HostNameBindingInner>, Observable<HostNameBindingInner>>(){

            public Observable<HostNameBindingInner> call(Page<HostNameBindingInner> hostNameBindingInnerPage) {
                return Observable.from((Iterable)hostNameBindingInnerPage.items());
            }
        }).map((Func1)new Func1<HostNameBindingInner, HostNameBinding>(){

            public HostNameBinding call(HostNameBindingInner hostNameBindingInner) {
                return new HostNameBindingImpl(hostNameBindingInner, DeploymentSlotImpl.this);
            }
        }).toList().map((Func1)new Func1<List<HostNameBinding>, Map<String, HostNameBinding>>(){

            public Map<String, HostNameBinding> call(List<HostNameBinding> hostNameBindings) {
                return Collections.unmodifiableMap(Maps.uniqueIndex(hostNameBindings, (Function)new Function<HostNameBinding, String>(){

                    public String apply(HostNameBinding input) {
                        return input.name().replace(DeploymentSlotImpl.this.name() + "/", "");
                    }
                }));
            }
        });
    }

    @Override
    public PublishingProfile getPublishingProfile() {
        return (PublishingProfile)this.getPublishingProfileAsync().toBlocking().single();
    }

    @Override
    public Observable<PublishingProfile> getPublishingProfileAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listPublishingProfileXmlWithSecretsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), new CsmPublishingProfileOptionsInner()).map((Func1)new Func1<InputStream, PublishingProfile>(){

            public PublishingProfile call(InputStream stream) {
                try {
                    String xml = CharStreams.toString((Readable)new InputStreamReader(stream));
                    return new PublishingProfileImpl(xml, DeploymentSlotImpl.this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void start() {
        this.startAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable startAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().startSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void stop() {
        this.stopAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable stopAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().stopSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void restart() {
        this.restartAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable restartAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().restartSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public DeploymentSlotImpl withBrandNewConfiguration() {
        this.siteConfig = null;
        return this;
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromParent() {
        return this.withConfigurationFromWebApp(this.parent());
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromWebApp(WebApp webApp) {
        this.copyConfigurations(((WebAppBaseImpl)((Object)webApp)).siteConfig, webApp.appSettings().values(), webApp.connectionStrings().values());
        return this;
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromDeploymentSlot(DeploymentSlot slot) {
        this.copyConfigurations(((WebAppBaseImpl)((Object)slot)).siteConfig, slot.appSettings().values(), slot.connectionStrings().values());
        return this;
    }

    private void copyConfigurations(SiteConfigResourceInner configInner, Collection<AppSetting> appSettings, Collection<ConnectionString> connectionStrings) {
        this.siteConfig = configInner;
        for (AppSetting appSetting : appSettings) {
            if (appSetting.sticky()) {
                this.withStickyAppSetting(appSetting.key(), appSetting.value());
                continue;
            }
            this.withAppSetting(appSetting.key(), appSetting.value());
        }
        for (ConnectionString connectionString : connectionStrings) {
            if (connectionString.sticky()) {
                this.withStickyConnectionString(connectionString.name(), connectionString.value(), connectionString.type());
                continue;
            }
            this.withConnectionString(connectionString.name(), connectionString.value(), connectionString.type());
        }
    }

    public WebAppImpl parent() {
        return this.parent;
    }

    @Override
    Observable<SiteInner> createOrUpdateInner(SiteInner site) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), site);
    }

    @Override
    Observable<SiteInner> getInner() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<SiteConfigResourceInner> getConfigInner() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<SiteConfigResourceInner> createOrUpdateSiteConfig(SiteConfigResourceInner siteConfig) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), siteConfig);
    }

    @Override
    Observable<Void> deleteHostNameBinding(String hostname) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().deleteHostNameBindingSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), hostname);
    }

    @Override
    Observable<StringDictionaryInner> listAppSettings() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listApplicationSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<StringDictionaryInner> updateAppSettings(StringDictionaryInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateApplicationSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    Observable<ConnectionStringDictionaryInner> listConnectionStrings() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listConnectionStringsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<ConnectionStringDictionaryInner> updateConnectionStrings(ConnectionStringDictionaryInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateConnectionStringsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    Observable<SlotConfigNamesResourceInner> listSlotConfigurations() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().listSlotConfigurationNamesAsync(this.resourceGroupName(), this.parent().name());
    }

    @Override
    Observable<SlotConfigNamesResourceInner> updateSlotConfigurations(SlotConfigNamesResourceInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateSlotConfigurationNamesAsync(this.resourceGroupName(), this.parent().name(), inner);
    }

    @Override
    Observable<SiteSourceControlInner> createOrUpdateSourceControl(SiteSourceControlInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateSourceControlSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    public void swap(String slotName) {
        this.swapAsync(slotName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable swapAsync(String slotName) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().swapSlotSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), new CsmSlotEntityInner().withTargetSlot(slotName)).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void applySlotConfigurations(String slotName) {
        this.applySlotConfigurationsAsync(slotName).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable applySlotConfigurationsAsync(String slotName) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().applySlotConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), new CsmSlotEntityInner().withTargetSlot(slotName)).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void resetSlotConfigurations() {
        this.resetSlotConfigurationsAsync().toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable resetSlotConfigurationsAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().resetSlotConfigurationSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return DeploymentSlotImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    Observable<Void> deleteSourceControl() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().deleteSourceControlSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).map((Func1)new Func1<Object, Void>(){

            public Void call(Object o) {
                return null;
            }
        });
    }

    @Override
    Observable<SiteAuthSettingsInner> updateAuthentication(SiteAuthSettingsInner inner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().updateAuthSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), inner);
    }

    @Override
    Observable<SiteAuthSettingsInner> getAuthentication() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getAuthSettingsSlotAsync(this.resourceGroupName(), this.parent().name(), this.name());
    }

    @Override
    Observable<MSDeployStatusInner> createMSDeploy(MSDeployInner msDeployInner) {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.parent().manager()).inner())).webApps().createMSDeployOperationAsync(this.parent().resourceGroupName(), this.parent().name(), msDeployInner);
    }

    @Override
    public WebAppSourceControl getSourceControl() {
        return (WebAppSourceControl)this.getSourceControlAsync().toBlocking().single();
    }

    @Override
    public Observable<WebAppSourceControl> getSourceControlAsync() {
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().getSourceControlSlotAsync(this.resourceGroupName(), this.parent().name(), this.name()).map((Func1)new Func1<SiteSourceControlInner, WebAppSourceControl>(){

            public WebAppSourceControl call(SiteSourceControlInner siteSourceControlInner) {
                return new WebAppSourceControlImpl<DeploymentSlot, DeploymentSlotImpl>(siteSourceControlInner, DeploymentSlotImpl.this);
            }
        });
    }

    @Override
    public void verifyDomainOwnership(String certificateOrderName, String domainVerificationToken) {
        this.verifyDomainOwnershipAsync(certificateOrderName, domainVerificationToken).toObservable().toBlocking().subscribe();
    }

    @Override
    public Completable verifyDomainOwnershipAsync(String certificateOrderName, String domainVerificationToken) {
        IdentifierInner identifierInner = new IdentifierInner().withIdentifierId(domainVerificationToken);
        identifierInner.withLocation("global");
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.manager()).inner())).webApps().createOrUpdateDomainOwnershipIdentifierSlotAsync(this.resourceGroupName(), this.parent().name(), this.name(), certificateOrderName, identifierInner).map((Func1)new Func1<IdentifierInner, Void>(){

            public Void call(IdentifierInner identifierInner) {
                return null;
            }
        }).toCompletable();
    }
}

