/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.DeploymentSlots;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.DeploymentSlotImpl;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class DeploymentSlotsImpl
extends IndependentChildResourcesImpl<DeploymentSlot, DeploymentSlotImpl, SiteInner, WebAppsInner, AppServiceManager, WebApp>
implements DeploymentSlots {
    private final PagedListConverter<SiteInner, DeploymentSlot> converter;
    private final WebAppImpl parent;

    DeploymentSlotsImpl(final WebAppImpl parent) {
        super((Object)((WebSiteManagementClientImpl)((Object)((AppServiceManager)parent.manager()).inner())).webApps(), parent.manager());
        this.parent = parent;
        final WebAppsInner innerCollection = (WebAppsInner)this.inner();
        this.converter = new PagedListConverter<SiteInner, DeploymentSlot>(){

            public DeploymentSlot typeConvert(SiteInner siteInner) {
                return DeploymentSlotsImpl.this.wrapModelWithConfigChange(siteInner, innerCollection, parent);
            }
        };
    }

    private DeploymentSlot wrapModelWithConfigChange(SiteInner siteInner, WebAppsInner innerCollection, WebAppImpl parent) {
        return (DeploymentSlot)this.wrapModel(siteInner, innerCollection.getConfigurationSlot(siteInner.resourceGroup(), parent.name(), siteInner.name().replaceAll(".*/", ""))).cacheSiteProperties().toBlocking().single();
    }

    protected DeploymentSlotImpl wrapModel(String name) {
        return (DeploymentSlotImpl)((DeploymentSlotImpl)new DeploymentSlotImpl(name, new SiteInner(), null, this.parent).withRegion(this.parent.regionName())).withExistingResourceGroup(this.parent.resourceGroupName());
    }

    protected DeploymentSlotImpl wrapModel(SiteInner inner) {
        return this.wrapModel(inner, null);
    }

    protected PagedList<DeploymentSlot> wrapList(PagedList<SiteInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public DeploymentSlotImpl define(String name) {
        return this.wrapModel(name);
    }

    public Observable<DeploymentSlot> getByParentAsync(final String resourceGroup, final String parentName, final String name) {
        return ((WebAppsInner)this.innerCollection).getSlotAsync(resourceGroup, parentName, name).flatMap((Func1)new Func1<SiteInner, Observable<DeploymentSlot>>(){

            public Observable<DeploymentSlot> call(final SiteInner siteInner) {
                if (siteInner == null) {
                    return null;
                }
                return ((WebAppsInner)DeploymentSlotsImpl.this.innerCollection).getConfigurationSlotAsync(resourceGroup, parentName, name).flatMap((Func1)new Func1<SiteConfigResourceInner, Observable<DeploymentSlot>>(){

                    public Observable<DeploymentSlot> call(SiteConfigResourceInner siteConfigInner) {
                        return DeploymentSlotsImpl.this.wrapModel(siteInner, siteConfigInner).cacheSiteProperties();
                    }
                });
            }
        });
    }

    public PagedList<DeploymentSlot> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((WebAppsInner)this.innerCollection).listSlots(resourceGroupName, parentName));
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        return ((WebAppsInner)this.innerCollection).deleteSlotAsync(groupName, parentName, name).toCompletable();
    }

    public void deleteByName(String name) {
        this.deleteByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name, callback);
    }

    public Completable deleteByNameAsync(String name) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public PagedList<DeploymentSlot> list() {
        return this.listByParent(this.parent.resourceGroupName(), this.parent.name());
    }

    public DeploymentSlot getByName(String name) {
        return (DeploymentSlot)this.getByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public WebApp parent() {
        return this.parent;
    }

    public Observable<DeploymentSlot> listAsync() {
        return DeploymentSlotsImpl.convertPageToInnerAsync(((WebAppsInner)this.innerCollection).listSlotsAsync(this.parent.resourceGroupName(), this.parent.name())).map((Func1)new Func1<SiteInner, DeploymentSlot>(){

            public DeploymentSlot call(SiteInner siteInner) {
                return DeploymentSlotsImpl.this.wrapModelWithConfigChange(siteInner, (WebAppsInner)DeploymentSlotsImpl.this.innerCollection, DeploymentSlotsImpl.this.parent);
            }
        });
    }

    private DeploymentSlotImpl wrapModel(SiteInner inner, SiteConfigResourceInner configResourceInner) {
        if (inner == null) {
            return null;
        }
        return new DeploymentSlotImpl(inner.name(), inner, configResourceInner, this.parent);
    }
}

