/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ProvidersInner {
    private ProvidersService service;
    private WebSiteManagementClientImpl client;

    public ProvidersInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (ProvidersService)retrofit.create(ProvidersService.class);
        this.client = client;
    }

    public Object getAvailableStacks() {
        return ((ServiceResponse)this.getAvailableStacksWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<Object> getAvailableStacksAsync(ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAvailableStacksWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Object> getAvailableStacksAsync() {
        return this.getAvailableStacksWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    public Observable<ServiceResponse<Object>> getAvailableStacksWithServiceResponseAsync() {
        String apiVersion = "2016-03-01";
        return this.service.getAvailableStacks("2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getAvailableStacksDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getAvailableStacksDelegate(Response<ResponseBody> response) throws CloudException, IOException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public Object getAvailableStacksOnPrem() {
        return ((ServiceResponse)this.getAvailableStacksOnPremWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<Object> getAvailableStacksOnPremAsync(ServiceCallback<Object> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAvailableStacksOnPremWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Object> getAvailableStacksOnPremAsync() {
        return this.getAvailableStacksOnPremWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Object>, Object>(){

            public Object call(ServiceResponse<Object> response) {
                return response.body();
            }
        });
    }

    public Observable<ServiceResponse<Object>> getAvailableStacksOnPremWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-03-01";
        return this.service.getAvailableStacksOnPrem(this.client.subscriptionId(), "2016-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Object>>>(){

            public Observable<ServiceResponse<Object>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getAvailableStacksOnPremDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Object> getAvailableStacksOnPremDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Object>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ProvidersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacks"})
        @GET(value="providers/Microsoft.Web/availableStacks")
        public Observable<Response<ResponseBody>> getAvailableStacks(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.Providers getAvailableStacksOnPrem"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Web/availableStacks")
        public Observable<Response<ResponseBody>> getAvailableStacksOnPrem(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

