/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.BuiltInAuthenticationProvider;
import com.microsoft.azure.management.appservice.UnauthenticatedClientAction;
import com.microsoft.azure.management.appservice.WebAppAuthentication;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.implementation.SiteAuthSettingsInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.util.ArrayList;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class WebAppAuthenticationImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteAuthSettingsInner>
implements WebAppAuthentication,
WebAppAuthentication.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppAuthentication.UpdateDefinition<WebAppBase.Update<FluentT>>,
WebAppAuthentication.Update<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;

    WebAppAuthenticationImpl(SiteAuthSettingsInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super((Object)inner);
        this.parent = parent;
        inner.withLocation(parent.regionName());
        inner.withTokenStoreEnabled(true);
    }

    public FluentImplT attach() {
        this.parent.withAuthentication(this);
        return (FluentImplT)this.parent();
    }

    public FluentImplT parent() {
        this.parent.withAuthentication(this);
        return (FluentImplT)this.parent;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withAnonymousAuthentication() {
        ((SiteAuthSettingsInner)((Object)this.inner())).withUnauthenticatedClientAction(UnauthenticatedClientAction.ALLOW_ANONYMOUS);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withDefaultAuthenticationProvider(BuiltInAuthenticationProvider provider) {
        ((SiteAuthSettingsInner)((Object)this.inner())).withUnauthenticatedClientAction(UnauthenticatedClientAction.REDIRECT_TO_LOGIN_PAGE).withDefaultProvider(provider);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withActiveDirectory(String clientId, String issuerUrl) {
        ((SiteAuthSettingsInner)((Object)this.inner())).withClientId(clientId).withIssuer(issuerUrl);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withFacebook(String appId, String appSecret) {
        ((SiteAuthSettingsInner)((Object)this.inner())).withFacebookAppId(appId).withFacebookAppSecret(appSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withGoogle(String clientId, String clientSecret) {
        ((SiteAuthSettingsInner)((Object)this.inner())).withGoogleClientId(clientId).withGoogleClientSecret(clientSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withTwitter(String apiKey, String apiSecret) {
        ((SiteAuthSettingsInner)((Object)this.inner())).withTwitterConsumerKey(apiKey).withTwitterConsumerSecret(apiSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withMicrosoft(String clientId, String clientSecret) {
        ((SiteAuthSettingsInner)((Object)this.inner())).withMicrosoftAccountClientId(clientId).withMicrosoftAccountClientSecret(clientSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withTokenStore(boolean enabled) {
        ((SiteAuthSettingsInner)((Object)this.inner())).withTokenStoreEnabled(enabled);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withAllowedExternalRedirectUrl(String url) {
        if (((SiteAuthSettingsInner)((Object)this.inner())).allowedExternalRedirectUrls() == null) {
            ((SiteAuthSettingsInner)((Object)this.inner())).withAllowedExternalRedirectUrls(new ArrayList<String>());
        }
        ((SiteAuthSettingsInner)((Object)this.inner())).allowedExternalRedirectUrls().add(url);
        return this;
    }
}

