/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.RepositoryType;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.WebAppSourceControl;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.SiteSourceControlInner;
import com.microsoft.azure.management.appservice.implementation.SourceControlInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import rx.Observable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class WebAppSourceControlImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteSourceControlInner>
implements WebAppSourceControl,
WebAppSourceControl.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppSourceControl.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private String githubAccessToken;

    WebAppSourceControlImpl(SiteSourceControlInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public String name() {
        return ((SiteSourceControlInner)((Object)this.inner())).name();
    }

    @Override
    public String repositoryUrl() {
        return ((SiteSourceControlInner)((Object)this.inner())).repoUrl();
    }

    @Override
    public String branch() {
        return ((SiteSourceControlInner)((Object)this.inner())).branch();
    }

    @Override
    public boolean isManualIntegration() {
        return Utils.toPrimitiveBoolean((Boolean)((SiteSourceControlInner)((Object)this.inner())).isManualIntegration());
    }

    @Override
    public boolean deploymentRollbackEnabled() {
        return Utils.toPrimitiveBoolean((Boolean)((SiteSourceControlInner)((Object)this.inner())).deploymentRollbackEnabled());
    }

    @Override
    public RepositoryType repositoryType() {
        if (((SiteSourceControlInner)((Object)this.inner())).isMercurial() == null) {
            return null;
        }
        return ((SiteSourceControlInner)((Object)this.inner())).isMercurial() != false ? RepositoryType.MERCURIAL : RepositoryType.GIT;
    }

    public FluentImplT attach() {
        ((WebAppBaseImpl)this.parent()).withSourceControl(this);
        return (FluentImplT)this.parent();
    }

    public FluentImplT parent() {
        return (FluentImplT)this.parent;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withBranch(String branch) {
        ((SiteSourceControlInner)((Object)this.inner())).withBranch(branch);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withPublicGitRepository(String url) {
        ((SiteSourceControlInner)((Object)this.inner())).withIsManualIntegration(true).withIsMercurial(false).withRepoUrl(url);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withPublicMercurialRepository(String url) {
        ((SiteSourceControlInner)((Object)this.inner())).withIsManualIntegration(true).withIsMercurial(true).withRepoUrl(url);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withContinuouslyIntegratedGitHubRepository(String organization, String repository) {
        return this.withContinuouslyIntegratedGitHubRepository(String.format("https://github.com/%s/%s", organization, repository));
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withContinuouslyIntegratedGitHubRepository(String url) {
        ((SiteSourceControlInner)((Object)this.inner())).withRepoUrl(url).withIsMercurial(false).withIsManualIntegration(false);
        return this;
    }

    public WebAppSourceControlImpl<FluentT, FluentImplT> withGitHubAccessToken(String personalAccessToken) {
        this.githubAccessToken = personalAccessToken;
        return this;
    }

    Observable<SourceControlInner> registerGithubAccessToken() {
        if (this.githubAccessToken == null) {
            return Observable.just(null);
        }
        SourceControlInner sourceControlInner = new SourceControlInner().withToken(this.githubAccessToken);
        sourceControlInner.withLocation(this.parent().regionName());
        return ((WebSiteManagementClientImpl)((Object)((AppServiceManager)this.parent().manager()).inner())).updateSourceControlAsync("Github", sourceControlInner);
    }
}

