/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.WebApps;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppsInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import java.util.Arrays;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class WebAppsImpl
extends TopLevelModifiableResourcesImpl<WebApp, WebAppImpl, SiteInner, WebAppsInner, AppServiceManager>
implements WebApps {
    private final PagedListConverter<SiteInner, WebApp> converter;

    WebAppsImpl(final AppServiceManager manager) {
        super((InnerSupportsListing)((WebSiteManagementClientImpl)((Object)manager.inner())).webApps(), (ManagerBase)manager);
        this.converter = new PagedListConverter<SiteInner, WebApp>(){

            public WebApp typeConvert(SiteInner siteInner) {
                WebAppImpl impl = WebAppsImpl.this.wrapModel(siteInner, ((WebSiteManagementClientImpl)((Object)manager.inner())).webApps().getConfiguration(siteInner.resourceGroup(), siteInner.name()));
                return (WebApp)impl.cacheSiteProperties().toBlocking().single();
            }

            protected boolean filter(SiteInner inner) {
                List<String> kinds = Arrays.asList(inner.kind().split(","));
                return kinds.contains("app");
            }
        };
    }

    public Observable<WebApp> getByResourceGroupAsync(final String groupName, final String name) {
        final WebAppsImpl self = this;
        return ((WebAppsInner)this.inner()).getByResourceGroupAsync(groupName, name).flatMap((Func1)new Func1<SiteInner, Observable<WebApp>>(){

            public Observable<WebApp> call(final SiteInner siteInner) {
                if (siteInner == null) {
                    return null;
                }
                return ((WebAppsInner)self.inner()).getConfigurationAsync(groupName, name).flatMap((Func1)new Func1<SiteConfigResourceInner, Observable<WebApp>>(){

                    public Observable<WebApp> call(SiteConfigResourceInner siteConfigInner) {
                        return WebAppsImpl.this.wrapModel(siteInner, siteConfigInner).cacheSiteProperties();
                    }
                });
            }
        });
    }

    protected WebAppImpl wrapModel(String name) {
        return new WebAppImpl(name, new SiteInner().withKind("app"), null, (AppServiceManager)this.manager());
    }

    protected WebAppImpl wrapModel(SiteInner inner, SiteConfigResourceInner configResourceInner) {
        if (inner == null) {
            return null;
        }
        return new WebAppImpl(inner.name(), inner, configResourceInner, (AppServiceManager)this.manager());
    }

    protected WebAppImpl wrapModel(SiteInner inner) {
        return this.wrapModel(inner, null);
    }

    protected PagedList<WebApp> wrapList(PagedList<SiteInner> pagedList) {
        return this.converter.convert(pagedList);
    }

    public WebAppImpl define(String name) {
        return this.wrapModel(name);
    }
}

