/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.MSDeployCore;
import com.microsoft.azure.management.appservice.MSDeployParameterEntry;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.appservice.WebDeployment;
import com.microsoft.azure.management.appservice.implementation.MSDeployInner;
import com.microsoft.azure.management.appservice.implementation.MSDeployStatusInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.ExecutableImpl;
import java.util.ArrayList;
import org.joda.time.DateTime;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
public class WebDeploymentImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends ExecutableImpl<WebDeployment>
implements WebDeployment,
WebDeployment.Definition {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private MSDeployInner request;
    private MSDeployStatusInner result;

    WebDeploymentImpl(WebAppBaseImpl<FluentT, FluentImplT> parent) {
        this.parent = parent;
        this.request = new MSDeployInner();
    }

    public WebAppBase parent() {
        return this.parent;
    }

    @Override
    public String deployer() {
        return this.result.deployer();
    }

    @Override
    public DateTime startTime() {
        return this.result.startTime();
    }

    @Override
    public DateTime endTime() {
        return this.result.endTime();
    }

    @Override
    public boolean complete() {
        return this.result.complete();
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withPackageUri(String packageUri) {
        this.request.withAddOnPackages(new ArrayList<MSDeployCore>());
        this.request.addOnPackages().add(new MSDeployCore().withPackageUri(packageUri));
        return this;
    }

    public Observable<WebDeployment> executeWorkAsync() {
        return this.parent.createMSDeploy(this.request).map((Func1)new Func1<MSDeployStatusInner, WebDeployment>(){

            public WebDeployment call(MSDeployStatusInner msDeployStatusInner) {
                WebDeploymentImpl.this.result = msDeployStatusInner;
                return WebDeploymentImpl.this;
            }
        });
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withExistingDeploymentsDeleted(boolean deleteExisting) {
        if (deleteExisting) {
            MSDeployCore first = this.request.addOnPackages().remove(0);
            this.request.withPackageUri(first.packageUri());
        }
        return this;
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withAddOnPackage(String packageUri) {
        this.request.addOnPackages().add(new MSDeployCore().withPackageUri(packageUri));
        return this;
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withSetParametersXmlFile(String fileUri) {
        this.request.withSetParametersXmlFileUri(fileUri);
        return this;
    }

    @Override
    public WebDeploymentImpl<FluentT, FluentImplT> withSetParameter(String name, String value) {
        if (this.request.setParameters() == null) {
            this.request.withSetParameters(new ArrayList<MSDeployParameterEntry>());
        }
        this.request.setParameters().add(new MSDeployParameterEntry().withName(name).withValue(value));
        return this;
    }
}

