/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.ActivateApplicationPackageParameters;
import com.microsoft.azure.management.batch.implementation.ApplicationPackageInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ApplicationPackagesInner {
    private ApplicationPackagesService service;
    private BatchManagementClientImpl client;

    public ApplicationPackagesInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (ApplicationPackagesService)retrofit.create(ApplicationPackagesService.class);
        this.client = client;
    }

    public ApplicationPackageInner activate(String resourceGroupName, String accountName, String applicationName, String versionName, String format) {
        return (ApplicationPackageInner)((Object)((ServiceResponse)this.activateWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName, format).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationPackageInner> activateAsync(String resourceGroupName, String accountName, String applicationName, String versionName, String format, ServiceCallback<ApplicationPackageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.activateWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName, format), serviceCallback);
    }

    public Observable<ApplicationPackageInner> activateAsync(String resourceGroupName, String accountName, String applicationName, String versionName, String format) {
        return this.activateWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName, format).map((Func1)new Func1<ServiceResponse<ApplicationPackageInner>, ApplicationPackageInner>(){

            public ApplicationPackageInner call(ServiceResponse<ApplicationPackageInner> response) {
                return (ApplicationPackageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationPackageInner>> activateWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationName, String versionName, String format) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Parameter applicationName is required and cannot be null.");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Parameter versionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (format == null) {
            throw new IllegalArgumentException("Parameter format is required and cannot be null.");
        }
        ActivateApplicationPackageParameters parameters = new ActivateApplicationPackageParameters();
        parameters.withFormat(format);
        return this.service.activate(resourceGroupName, accountName, applicationName, versionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationPackageInner>>>(){

            public Observable<ServiceResponse<ApplicationPackageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationPackagesInner.this.activateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationPackageInner> activateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationPackageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationPackageInner create(String resourceGroupName, String accountName, String applicationName, String versionName) {
        return (ApplicationPackageInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationPackageInner> createAsync(String resourceGroupName, String accountName, String applicationName, String versionName, ServiceCallback<ApplicationPackageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName), serviceCallback);
    }

    public Observable<ApplicationPackageInner> createAsync(String resourceGroupName, String accountName, String applicationName, String versionName) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName).map((Func1)new Func1<ServiceResponse<ApplicationPackageInner>, ApplicationPackageInner>(){

            public ApplicationPackageInner call(ServiceResponse<ApplicationPackageInner> response) {
                return (ApplicationPackageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationPackageInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationName, String versionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Parameter applicationName is required and cannot be null.");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Parameter versionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        ApplicationPackageInner paramters = new ApplicationPackageInner();
        return this.service.create(resourceGroupName, accountName, applicationName, versionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), paramters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationPackageInner>>>(){

            public Observable<ServiceResponse<ApplicationPackageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationPackagesInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationPackageInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationPackageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName, String applicationName, String versionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String applicationName, String versionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String applicationName, String versionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationName, String versionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Parameter applicationName is required and cannot be null.");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Parameter versionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, applicationName, versionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationPackagesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationPackageInner get(String resourceGroupName, String accountName, String applicationName, String versionName) {
        return (ApplicationPackageInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName).toBlocking().single()).body());
    }

    public ServiceFuture<ApplicationPackageInner> getAsync(String resourceGroupName, String accountName, String applicationName, String versionName, ServiceCallback<ApplicationPackageInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName), serviceCallback);
    }

    public Observable<ApplicationPackageInner> getAsync(String resourceGroupName, String accountName, String applicationName, String versionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, applicationName, versionName).map((Func1)new Func1<ServiceResponse<ApplicationPackageInner>, ApplicationPackageInner>(){

            public ApplicationPackageInner call(ServiceResponse<ApplicationPackageInner> response) {
                return (ApplicationPackageInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ApplicationPackageInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationName, String versionName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Parameter applicationName is required and cannot be null.");
        }
        if (versionName == null) {
            throw new IllegalArgumentException("Parameter versionName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, applicationName, versionName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationPackageInner>>>(){

            public Observable<ServiceResponse<ApplicationPackageInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationPackagesInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationPackageInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationPackageInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationPackageInner> list(String resourceGroupName, String accountName, String applicationName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName, applicationName).toBlocking().single();
        return new PagedList<ApplicationPackageInner>((Page)response.body()){

            public Page<ApplicationPackageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationPackagesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationPackageInner>> listAsync(String resourceGroupName, String accountName, String applicationName, ListOperationCallback<ApplicationPackageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName, applicationName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(String nextPageLink) {
                return ApplicationPackagesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationPackageInner>> listAsync(String resourceGroupName, String accountName, String applicationName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName, applicationName).map((Func1)new Func1<ServiceResponse<Page<ApplicationPackageInner>>, Page<ApplicationPackageInner>>(){

            public Page<ApplicationPackageInner> call(ServiceResponse<Page<ApplicationPackageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationPackageInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationName) {
        return this.listSinglePageAsync(resourceGroupName, accountName, applicationName).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationPackageInner>>, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(ServiceResponse<Page<ApplicationPackageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationPackagesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationPackageInner>>> listSinglePageAsync(String resourceGroupName, String accountName, String applicationName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Parameter applicationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        return this.service.list(resourceGroupName, accountName, applicationName, this.client.subscriptionId(), maxresults, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationPackagesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ApplicationPackageInner> list(String resourceGroupName, String accountName, String applicationName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName, applicationName, maxresults).toBlocking().single();
        return new PagedList<ApplicationPackageInner>((Page)response.body()){

            public Page<ApplicationPackageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationPackagesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationPackageInner>> listAsync(String resourceGroupName, String accountName, String applicationName, Integer maxresults, ListOperationCallback<ApplicationPackageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName, applicationName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(String nextPageLink) {
                return ApplicationPackagesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationPackageInner>> listAsync(String resourceGroupName, String accountName, String applicationName, Integer maxresults) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName, applicationName, maxresults).map((Func1)new Func1<ServiceResponse<Page<ApplicationPackageInner>>, Page<ApplicationPackageInner>>(){

            public Page<ApplicationPackageInner> call(ServiceResponse<Page<ApplicationPackageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationPackageInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationName, Integer maxresults) {
        return this.listSinglePageAsync(resourceGroupName, accountName, applicationName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationPackageInner>>, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(ServiceResponse<Page<ApplicationPackageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationPackagesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationPackageInner>>> listSinglePageAsync(String resourceGroupName, String accountName, String applicationName, Integer maxresults) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationName == null) {
            throw new IllegalArgumentException("Parameter applicationName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, applicationName, this.client.subscriptionId(), maxresults, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationPackagesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationPackageInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationPackageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationPackageInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationPackageInner>((Page)response.body()){

            public Page<ApplicationPackageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationPackagesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationPackageInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ApplicationPackageInner>> serviceFuture, ListOperationCallback<ApplicationPackageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(String nextPageLink) {
                return ApplicationPackagesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationPackageInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationPackageInner>>, Page<ApplicationPackageInner>>(){

            public Page<ApplicationPackageInner> call(ServiceResponse<Page<ApplicationPackageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationPackageInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationPackageInner>>, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(ServiceResponse<Page<ApplicationPackageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationPackagesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationPackageInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationPackageInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationPackageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationPackagesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationPackageInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationPackageInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ApplicationPackagesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.ApplicationPackages activate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}/activate")
        public Observable<Response<ResponseBody>> activate(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationName") String var3, @Path(value="versionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ActivateApplicationPackageParameters var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.ApplicationPackages create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationName") String var3, @Path(value="versionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Body ApplicationPackageInner var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.ApplicationPackages delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationName") String var3, @Path(value="versionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.ApplicationPackages get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions/{versionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationName") String var3, @Path(value="versionName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.ApplicationPackages list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}/versions")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationName") String var3, @Path(value="subscriptionId") String var4, @Query(value="maxresults") Integer var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.ApplicationPackages listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

