/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.CheckNameAvailabilityInput;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.CheckNameAvailabilityOutputInner;
import com.microsoft.azure.management.cdn.implementation.CustomDomainsInner;
import com.microsoft.azure.management.cdn.implementation.EdgeNodesInner;
import com.microsoft.azure.management.cdn.implementation.EndpointsInner;
import com.microsoft.azure.management.cdn.implementation.OperationInner;
import com.microsoft.azure.management.cdn.implementation.OriginsInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.ProfilesInner;
import com.microsoft.azure.management.cdn.implementation.ResourceUsageInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class CdnManagementClientImpl
extends AzureServiceClient {
    private CdnManagementClientService service;
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ProfilesInner profiles;
    private EndpointsInner endpoints;
    private OriginsInner origins;
    private CustomDomainsInner customDomains;
    private EdgeNodesInner edgeNodes;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public CdnManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public CdnManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public CdnManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public CdnManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ProfilesInner profiles() {
        return this.profiles;
    }

    public EndpointsInner endpoints() {
        return this.endpoints;
    }

    public OriginsInner origins() {
        return this.origins;
    }

    public CustomDomainsInner customDomains() {
        return this.customDomains;
    }

    public EdgeNodesInner edgeNodes() {
        return this.edgeNodes;
    }

    public CdnManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public CdnManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public CdnManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2016-10-02";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.profiles = new ProfilesInner(this.restClient().retrofit(), this);
        this.endpoints = new EndpointsInner(this.restClient().retrofit(), this);
        this.origins = new OriginsInner(this.restClient().retrofit(), this);
        this.customDomains = new CustomDomainsInner(this.restClient().retrofit(), this);
        this.edgeNodes = new EdgeNodesInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "CdnManagementClient", "2016-10-02");
    }

    private void initializeService() {
        this.service = (CdnManagementClientService)this.restClient().retrofit().create(CdnManagementClientService.class);
    }

    public CheckNameAvailabilityOutputInner checkNameAvailability(String name) {
        return (CheckNameAvailabilityOutputInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<CheckNameAvailabilityOutputInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<CheckNameAvailabilityOutputInner>, CheckNameAvailabilityOutputInner>(){

            public CheckNameAvailabilityOutputInner call(ServiceResponse<CheckNameAvailabilityOutputInner> response) {
                return (CheckNameAvailabilityOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        CheckNameAvailabilityInput checkNameAvailabilityInput = new CheckNameAvailabilityInput();
        checkNameAvailabilityInput.withName(name);
        return this.service.checkNameAvailability(this.apiVersion(), this.acceptLanguage(), checkNameAvailabilityInput, this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CheckNameAvailabilityOutputInner>>>(){

            public Observable<ServiceResponse<CheckNameAvailabilityOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CdnManagementClientImpl.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CheckNameAvailabilityOutputInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CheckNameAvailabilityOutputInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ResourceUsageInner> listResourceUsage() {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageSinglePageAsync().toBlocking().single();
        return new PagedList<ResourceUsageInner>((Page)response.body()){

            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CdnManagementClientImpl.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageAsync(ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                return CdnManagementClientImpl.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceUsageInner>> listResourceUsageAsync() {
        return this.listResourceUsageWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>(){

            public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageWithServiceResponseAsync() {
        return this.listResourceUsageSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CdnManagementClientImpl.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageSinglePageAsync() {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listResourceUsage(this.subscriptionId(), this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CdnManagementClientImpl.this.listResourceUsageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceUsageInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<OperationInner> listOperations() {
        ServiceResponse response = (ServiceResponse)this.listOperationsSinglePageAsync().toBlocking().single();
        return new PagedList<OperationInner>((Page)response.body()){

            public Page<OperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CdnManagementClientImpl.this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OperationInner>> listOperationsAsync(ListOperationCallback<OperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOperationsSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<OperationInner>>>>(){

            public Observable<ServiceResponse<Page<OperationInner>>> call(String nextPageLink) {
                return CdnManagementClientImpl.this.listOperationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OperationInner>> listOperationsAsync() {
        return this.listOperationsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<OperationInner>>, Page<OperationInner>>(){

            public Page<OperationInner> call(ServiceResponse<Page<OperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OperationInner>>> listOperationsWithServiceResponseAsync() {
        return this.listOperationsSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<OperationInner>>, Observable<ServiceResponse<Page<OperationInner>>>>(){

            public Observable<ServiceResponse<Page<OperationInner>>> call(ServiceResponse<Page<OperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CdnManagementClientImpl.this.listOperationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OperationInner>>> listOperationsSinglePageAsync() {
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listOperations(this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OperationInner>>>>(){

            public Observable<ServiceResponse<Page<OperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CdnManagementClientImpl.this.listOperationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OperationInner>> listOperationsDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<OperationInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ResourceUsageInner> listResourceUsageNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceUsageInner>((Page)response.body()){

            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CdnManagementClientImpl.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageNextAsync(String nextPageLink, ServiceFuture<List<ResourceUsageInner>> serviceFuture, ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                return CdnManagementClientImpl.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceUsageInner>> listResourceUsageNextAsync(String nextPageLink) {
        return this.listResourceUsageNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>(){

            public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextWithServiceResponseAsync(String nextPageLink) {
        return this.listResourceUsageNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CdnManagementClientImpl.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listResourceUsageNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CdnManagementClientImpl.this.listResourceUsageNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceUsageInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<OperationInner> listOperationsNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<OperationInner>((Page)response.body()){

            public Page<OperationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)CdnManagementClientImpl.this.listOperationsNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<OperationInner>> listOperationsNextAsync(String nextPageLink, ServiceFuture<List<OperationInner>> serviceFuture, ListOperationCallback<OperationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOperationsNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<OperationInner>>>>(){

            public Observable<ServiceResponse<Page<OperationInner>>> call(String nextPageLink) {
                return CdnManagementClientImpl.this.listOperationsNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<OperationInner>> listOperationsNextAsync(String nextPageLink) {
        return this.listOperationsNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<OperationInner>>, Page<OperationInner>>(){

            public Page<OperationInner> call(ServiceResponse<Page<OperationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<OperationInner>>> listOperationsNextWithServiceResponseAsync(String nextPageLink) {
        return this.listOperationsNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<OperationInner>>, Observable<ServiceResponse<Page<OperationInner>>>>(){

            public Observable<ServiceResponse<Page<OperationInner>>> call(ServiceResponse<Page<OperationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(CdnManagementClientImpl.this.listOperationsNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<OperationInner>>> listOperationsNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listOperationsNext(nextUrl, this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<OperationInner>>>>(){

            public Observable<ServiceResponse<Page<OperationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CdnManagementClientImpl.this.listOperationsNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<OperationInner>> listOperationsNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<PageImpl<OperationInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface CdnManagementClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient checkNameAvailability"})
        @POST(value="providers/Microsoft.Cdn/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Body CheckNameAvailabilityInput var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient listResourceUsage"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.Cdn/checkResourceUsage")
        public Observable<Response<ResponseBody>> listResourceUsage(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient listOperations"})
        @GET(value="providers/Microsoft.Cdn/operations")
        public Observable<Response<ResponseBody>> listOperations(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient listResourceUsageNext"})
        @GET
        public Observable<Response<ResponseBody>> listResourceUsageNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.CdnManagementClient listOperationsNext"})
        @GET
        public Observable<Response<ResponseBody>> listOperationsNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

