/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.LoadParameters;
import com.microsoft.azure.management.cdn.PurgeParameters;
import com.microsoft.azure.management.cdn.ValidateCustomDomainInput;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.EndpointInner;
import com.microsoft.azure.management.cdn.implementation.EndpointUpdateParametersInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.azure.management.cdn.implementation.ResourceUsageInner;
import com.microsoft.azure.management.cdn.implementation.ValidateCustomDomainOutputInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class EndpointsInner {
    private EndpointsService service;
    private CdnManagementClientImpl client;

    public EndpointsInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (EndpointsService)retrofit.create(EndpointsService.class);
        this.client = client;
    }

    public PagedList<EndpointInner> listByProfile(String resourceGroupName, String profileName) {
        ServiceResponse response = (ServiceResponse)this.listByProfileSinglePageAsync(resourceGroupName, profileName).toBlocking().single();
        return new PagedList<EndpointInner>((Page)response.body()){

            public Page<EndpointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EndpointsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EndpointInner>> listByProfileAsync(String resourceGroupName, String profileName, ListOperationCallback<EndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileSinglePageAsync(resourceGroupName, profileName), (Func1)new Func1<String, Observable<ServiceResponse<Page<EndpointInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointInner>>> call(String nextPageLink) {
                return EndpointsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EndpointInner>> listByProfileAsync(String resourceGroupName, String profileName) {
        return this.listByProfileWithServiceResponseAsync(resourceGroupName, profileName).map((Func1)new Func1<ServiceResponse<Page<EndpointInner>>, Page<EndpointInner>>(){

            public Page<EndpointInner> call(ServiceResponse<Page<EndpointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileWithServiceResponseAsync(String resourceGroupName, String profileName) {
        return this.listByProfileSinglePageAsync(resourceGroupName, profileName).concatMap((Func1)new Func1<ServiceResponse<Page<EndpointInner>>, Observable<ServiceResponse<Page<EndpointInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointInner>>> call(ServiceResponse<Page<EndpointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EndpointsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileSinglePageAsync(String resourceGroupName, String profileName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByProfile(resourceGroupName, profileName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EndpointInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EndpointsInner.this.listByProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EndpointInner>> listByProfileDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EndpointInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EndpointInner get(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single()).body());
    }

    public ServiceFuture<EndpointInner> getAsync(String resourceGroupName, String profileName, String endpointName, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    public Observable<EndpointInner> getAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.getWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> getWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>(){

            public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EndpointInner> getDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EndpointInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EndpointInner create(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return (EndpointInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).toBlocking().last()).body());
    }

    public ServiceFuture<EndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint), serviceCallback);
    }

    public Observable<EndpointInner> createAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return this.createWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> createWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Parameter endpoint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)endpoint));
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpoint, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<EndpointInner>(){}.getType());
    }

    public EndpointInner beginCreate(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return (EndpointInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).toBlocking().single()).body());
    }

    public ServiceFuture<EndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint), serviceCallback);
    }

    public Observable<EndpointInner> beginCreateAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpoint).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("Parameter endpoint is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)endpoint));
        return this.service.beginCreate(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpoint, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>(){

            public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EndpointInner> beginCreateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EndpointInner>(){}.getType()).register(201, new TypeToken<EndpointInner>(){}.getType()).register(202, new TypeToken<EndpointInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EndpointInner update(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties) {
        return (EndpointInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).toBlocking().last()).body());
    }

    public ServiceFuture<EndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties), serviceCallback);
    }

    public Observable<EndpointInner> updateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties) {
        return this.updateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> updateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpointUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)endpointUpdateProperties);
        Observable<Response<ResponseBody>> observable = this.service.update(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpointUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<EndpointInner>(){}.getType());
    }

    public EndpointInner beginUpdate(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties) {
        return (EndpointInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).toBlocking().single()).body());
    }

    public ServiceFuture<EndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties), serviceCallback);
    }

    public Observable<EndpointInner> beginUpdateAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, EndpointUpdateParametersInner endpointUpdateProperties) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (endpointUpdateProperties == null) {
            throw new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)endpointUpdateProperties);
        return this.service.beginUpdate(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), endpointUpdateProperties, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>(){

            public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EndpointInner> beginUpdateDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<EndpointInner>(){}.getType()).register(202, new TypeToken<EndpointInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String profileName, String endpointName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String profileName, String endpointName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EndpointInner start(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)((ServiceResponse)this.startWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().last()).body());
    }

    public ServiceFuture<EndpointInner> startAsync(String resourceGroupName, String profileName, String endpointName, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.startWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    public Observable<EndpointInner> startAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.startWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> startWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.start(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<EndpointInner>(){}.getType());
    }

    public EndpointInner beginStart(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)((ServiceResponse)this.beginStartWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single()).body());
    }

    public ServiceFuture<EndpointInner> beginStartAsync(String resourceGroupName, String profileName, String endpointName, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStartWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    public Observable<EndpointInner> beginStartAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.beginStartWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> beginStartWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginStart(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>(){

            public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.beginStartDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EndpointInner> beginStartDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<EndpointInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public EndpointInner stop(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)((ServiceResponse)this.stopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().last()).body());
    }

    public ServiceFuture<EndpointInner> stopAsync(String resourceGroupName, String profileName, String endpointName, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.stopWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    public Observable<EndpointInner> stopAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.stopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> stopWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.stop(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<EndpointInner>(){}.getType());
    }

    public EndpointInner beginStop(String resourceGroupName, String profileName, String endpointName) {
        return (EndpointInner)((Object)((ServiceResponse)this.beginStopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).toBlocking().single()).body());
    }

    public ServiceFuture<EndpointInner> beginStopAsync(String resourceGroupName, String profileName, String endpointName, ServiceCallback<EndpointInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStopWithServiceResponseAsync(resourceGroupName, profileName, endpointName), serviceCallback);
    }

    public Observable<EndpointInner> beginStopAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.beginStopWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<EndpointInner>, EndpointInner>(){

            public EndpointInner call(ServiceResponse<EndpointInner> response) {
                return (EndpointInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<EndpointInner>> beginStopWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginStop(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<EndpointInner>>>(){

            public Observable<ServiceResponse<EndpointInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.beginStopDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<EndpointInner> beginStopDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<EndpointInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void purgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((ServiceResponse)this.purgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().last()).body();
    }

    public ServiceFuture<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.purgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    public Observable<Void> purgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.purgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> purgeContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        Observable<Response<ResponseBody>> observable = this.service.purgeContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginPurgeContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((ServiceResponse)this.beginPurgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPurgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    public Observable<Void> beginPurgeContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.beginPurgeContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginPurgeContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return this.service.beginPurgeContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.beginPurgeContentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginPurgeContentDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public void loadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((ServiceResponse)this.loadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().last()).body();
    }

    public ServiceFuture<Void> loadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.loadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    public Observable<Void> loadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.loadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> loadContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        Observable<Response<ResponseBody>> observable = this.service.loadContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginLoadContent(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        ((ServiceResponse)this.beginLoadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginLoadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginLoadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths), serviceCallback);
    }

    public Observable<Void> beginLoadContentAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return this.beginLoadContentWithServiceResponseAsync(resourceGroupName, profileName, endpointName, contentPaths).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginLoadContentWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (contentPaths == null) {
            throw new IllegalArgumentException("Parameter contentPaths is required and cannot be null.");
        }
        Validator.validate(contentPaths);
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return this.service.beginLoadContent(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), contentFilePaths, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.beginLoadContentDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginLoadContentDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public ValidateCustomDomainOutputInner validateCustomDomain(String resourceGroupName, String profileName, String endpointName, String hostName) {
        return (ValidateCustomDomainOutputInner)((ServiceResponse)this.validateCustomDomainWithServiceResponseAsync(resourceGroupName, profileName, endpointName, hostName).toBlocking().single()).body();
    }

    public ServiceFuture<ValidateCustomDomainOutputInner> validateCustomDomainAsync(String resourceGroupName, String profileName, String endpointName, String hostName, ServiceCallback<ValidateCustomDomainOutputInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.validateCustomDomainWithServiceResponseAsync(resourceGroupName, profileName, endpointName, hostName), serviceCallback);
    }

    public Observable<ValidateCustomDomainOutputInner> validateCustomDomainAsync(String resourceGroupName, String profileName, String endpointName, String hostName) {
        return this.validateCustomDomainWithServiceResponseAsync(resourceGroupName, profileName, endpointName, hostName).map((Func1)new Func1<ServiceResponse<ValidateCustomDomainOutputInner>, ValidateCustomDomainOutputInner>(){

            public ValidateCustomDomainOutputInner call(ServiceResponse<ValidateCustomDomainOutputInner> response) {
                return (ValidateCustomDomainOutputInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ValidateCustomDomainOutputInner>> validateCustomDomainWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName, String hostName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (hostName == null) {
            throw new IllegalArgumentException("Parameter hostName is required and cannot be null.");
        }
        ValidateCustomDomainInput customDomainProperties = new ValidateCustomDomainInput();
        customDomainProperties.withHostName(hostName);
        return this.service.validateCustomDomain(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), customDomainProperties, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ValidateCustomDomainOutputInner>>>(){

            public Observable<ServiceResponse<ValidateCustomDomainOutputInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = EndpointsInner.this.validateCustomDomainDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ValidateCustomDomainOutputInner> validateCustomDomainDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ValidateCustomDomainOutputInner>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ResourceUsageInner> listResourceUsage(String resourceGroupName, String profileName, String endpointName) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName).toBlocking().single();
        return new PagedList<ResourceUsageInner>((Page)response.body()){

            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EndpointsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName, String endpointName, ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                return EndpointsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceUsageInner>> listResourceUsageAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listResourceUsageWithServiceResponseAsync(resourceGroupName, profileName, endpointName).map((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>(){

            public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageWithServiceResponseAsync(String resourceGroupName, String profileName, String endpointName) {
        return this.listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EndpointsInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageSinglePageAsync(String resourceGroupName, String profileName, String endpointName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (profileName == null) {
            throw new IllegalArgumentException("Parameter profileName is required and cannot be null.");
        }
        if (endpointName == null) {
            throw new IllegalArgumentException("Parameter endpointName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listResourceUsage(resourceGroupName, profileName, endpointName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EndpointsInner.this.listResourceUsageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceUsageInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EndpointInner> listByProfileNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EndpointInner>((Page)response.body()){

            public Page<EndpointInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EndpointsInner.this.listByProfileNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EndpointInner>> listByProfileNextAsync(String nextPageLink, ServiceFuture<List<EndpointInner>> serviceFuture, ListOperationCallback<EndpointInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByProfileNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EndpointInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointInner>>> call(String nextPageLink) {
                return EndpointsInner.this.listByProfileNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EndpointInner>> listByProfileNextAsync(String nextPageLink) {
        return this.listByProfileNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EndpointInner>>, Page<EndpointInner>>(){

            public Page<EndpointInner> call(ServiceResponse<Page<EndpointInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByProfileNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EndpointInner>>, Observable<ServiceResponse<Page<EndpointInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointInner>>> call(ServiceResponse<Page<EndpointInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EndpointsInner.this.listByProfileNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EndpointInner>>> listByProfileNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByProfileNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EndpointInner>>>>(){

            public Observable<ServiceResponse<Page<EndpointInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EndpointsInner.this.listByProfileNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EndpointInner>> listByProfileNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EndpointInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<ResourceUsageInner> listResourceUsageNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceUsageInner>((Page)response.body()){

            public Page<ResourceUsageInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EndpointsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceUsageInner>> listResourceUsageNextAsync(String nextPageLink, ServiceFuture<List<ResourceUsageInner>> serviceFuture, ListOperationCallback<ResourceUsageInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listResourceUsageNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(String nextPageLink) {
                return EndpointsInner.this.listResourceUsageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceUsageInner>> listResourceUsageNextAsync(String nextPageLink) {
        return this.listResourceUsageNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Page<ResourceUsageInner>>(){

            public Page<ResourceUsageInner> call(ServiceResponse<Page<ResourceUsageInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextWithServiceResponseAsync(String nextPageLink) {
        return this.listResourceUsageNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceUsageInner>>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(ServiceResponse<Page<ResourceUsageInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EndpointsInner.this.listResourceUsageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceUsageInner>>> listResourceUsageNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listResourceUsageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceUsageInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceUsageInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EndpointsInner.this.listResourceUsageNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceUsageInner>> listResourceUsageNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceUsageInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface EndpointsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listByProfile"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints")
        public Observable<Response<ResponseBody>> listByProfile(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Body EndpointInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Body EndpointInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Body EndpointUpdateParametersInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Body EndpointUpdateParametersInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints start"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start")
        public Observable<Response<ResponseBody>> start(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginStart"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/start")
        public Observable<Response<ResponseBody>> beginStart(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints stop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop")
        public Observable<Response<ResponseBody>> stop(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginStop"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/stop")
        public Observable<Response<ResponseBody>> beginStop(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints purgeContent"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge")
        public Observable<Response<ResponseBody>> purgeContent(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body PurgeParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginPurgeContent"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/purge")
        public Observable<Response<ResponseBody>> beginPurgeContent(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body PurgeParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints loadContent"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load")
        public Observable<Response<ResponseBody>> loadContent(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body LoadParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints beginLoadContent"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/load")
        public Observable<Response<ResponseBody>> beginLoadContent(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body LoadParameters var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints validateCustomDomain"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/validateCustomDomain")
        public Observable<Response<ResponseBody>> validateCustomDomain(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body ValidateCustomDomainInput var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listResourceUsage"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/endpoints/{endpointName}/checkResourceUsage")
        public Observable<Response<ResponseBody>> listResourceUsage(@Path(value="resourceGroupName") String var1, @Path(value="profileName") String var2, @Path(value="endpointName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listByProfileNext"})
        @GET
        public Observable<Response<ResponseBody>> listByProfileNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.Endpoints listResourceUsageNext"})
        @GET
        public Observable<Response<ResponseBody>> listResourceUsageNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

