/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.AvailabilitySetOperations;
import com.microsoft.azure.management.compute.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.models.AvailabilitySet;
import com.microsoft.azure.management.compute.models.AvailabilitySetCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.AvailabilitySetGetResponse;
import com.microsoft.azure.management.compute.models.AvailabilitySetListResponse;
import com.microsoft.azure.management.compute.models.InstanceViewStatus;
import com.microsoft.azure.management.compute.models.VirtualMachineReference;
import com.microsoft.azure.management.compute.models.VirtualMachineSize;
import com.microsoft.azure.management.compute.models.VirtualMachineSizeListResponse;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class AvailabilitySetOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
AvailabilitySetOperations {
    private ComputeManagementClientImpl client;

    AvailabilitySetOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<AvailabilitySetCreateOrUpdateResponse> createOrUpdateAsync(final String resourceGroupName, final AvailabilitySet parameters) {
        return this.getClient().getExecutorService().submit(new Callable<AvailabilitySetCreateOrUpdateResponse>(){

            @Override
            public AvailabilitySetCreateOrUpdateResponse call() throws Exception {
                return AvailabilitySetOperationsImpl.this.createOrUpdate(resourceGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvailabilitySetCreateOrUpdateResponse createOrUpdate(String resourceGroupName, AvailabilitySet parameters) throws IOException, ServiceException, InterruptedException, ExecutionException {
        AvailabilitySetCreateOrUpdateResponse availabilitySetCreateOrUpdateResponse;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode availabilitySetJsonValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        if (parameters.getName() != null) {
            url = url + URLEncoder.encode(parameters.getName(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = availabilitySetJsonValue = objectMapper.createObjectNode();
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        availabilitySetJsonValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getPlatformUpdateDomainCount() != null) {
            propertiesValue.put("platformUpdateDomainCount", parameters.getPlatformUpdateDomainCount());
        }
        if (parameters.getPlatformFaultDomainCount() != null) {
            propertiesValue.put("platformFaultDomainCount", parameters.getPlatformFaultDomainCount());
        }
        if (parameters.getVirtualMachinesReferences() != null && (!(parameters.getVirtualMachinesReferences() instanceof LazyCollection) || ((LazyCollection)parameters.getVirtualMachinesReferences()).isInitialized())) {
            ArrayNode virtualMachinesArray = objectMapper.createArrayNode();
            for (VirtualMachineReference virtualMachineReference : parameters.getVirtualMachinesReferences()) {
                ObjectNode virtualMachineReferenceValue = objectMapper.createObjectNode();
                virtualMachinesArray.add((JsonNode)virtualMachineReferenceValue);
                if (virtualMachineReference.getReferenceUri() == null) continue;
                virtualMachineReferenceValue.put("id", virtualMachineReference.getReferenceUri());
            }
            propertiesValue.put("virtualMachines", (JsonNode)virtualMachinesArray);
        }
        if (parameters.getStatuses() != null && (!(parameters.getStatuses() instanceof LazyCollection) || ((LazyCollection)parameters.getStatuses()).isInitialized())) {
            ArrayNode statusesArray = objectMapper.createArrayNode();
            for (InstanceViewStatus instanceViewStatus : parameters.getStatuses()) {
                ObjectNode instanceViewStatusValue = objectMapper.createObjectNode();
                statusesArray.add((JsonNode)instanceViewStatusValue);
                if (instanceViewStatus.getCode() != null) {
                    instanceViewStatusValue.put("code", instanceViewStatus.getCode());
                }
                if (instanceViewStatus.getLevel() != null) {
                    instanceViewStatusValue.put("level", instanceViewStatus.getLevel());
                }
                if (instanceViewStatus.getDisplayStatus() != null) {
                    instanceViewStatusValue.put("displayStatus", instanceViewStatus.getDisplayStatus());
                }
                if (instanceViewStatus.getMessage() != null) {
                    instanceViewStatusValue.put("message", instanceViewStatus.getMessage());
                }
                if (instanceViewStatus.getTime() == null) continue;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                instanceViewStatusValue.put("time", simpleDateFormat.format(instanceViewStatus.getTime().getTime()));
            }
            propertiesValue.put("statuses", (JsonNode)statusesArray);
        }
        if (parameters.getId() != null) {
            availabilitySetJsonValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            availabilitySetJsonValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            availabilitySetJsonValue.put("type", parameters.getType());
        }
        availabilitySetJsonValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String tagsKey = (String)entry.getKey();
                String tagsValue = (String)entry.getValue();
                tagsDictionary.put(tagsKey, tagsValue);
            }
            availabilitySetJsonValue.put("tags", (JsonNode)tagsDictionary);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var16_21 = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((statusCode = closeableHttpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            AvailabilitySetCreateOrUpdateResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                result = new AvailabilitySetCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    JsonNode idValue2;
                    AvailabilitySet availabilitySetInstance = new AvailabilitySet();
                    result.setAvailabilitySet(availabilitySetInstance);
                    JsonNode propertiesValue2 = responseDoc.get("properties");
                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode)) {
                        JsonNode statusesArray2;
                        JsonNode virtualMachinesArray2;
                        JsonNode platformFaultDomainCountValue;
                        JsonNode platformUpdateDomainCountValue = propertiesValue2.get("platformUpdateDomainCount");
                        if (platformUpdateDomainCountValue != null && !(platformUpdateDomainCountValue instanceof NullNode)) {
                            int platformUpdateDomainCountInstance = platformUpdateDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformUpdateDomainCount(platformUpdateDomainCountInstance);
                        }
                        if ((platformFaultDomainCountValue = propertiesValue2.get("platformFaultDomainCount")) != null && !(platformFaultDomainCountValue instanceof NullNode)) {
                            int platformFaultDomainCountInstance = platformFaultDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformFaultDomainCount(platformFaultDomainCountInstance);
                        }
                        if ((virtualMachinesArray2 = propertiesValue2.get("virtualMachines")) != null && !(virtualMachinesArray2 instanceof NullNode)) {
                            for (Iterator virtualMachinesValue : (ArrayNode)virtualMachinesArray2) {
                                VirtualMachineReference virtualMachineReferenceInstance = new VirtualMachineReference();
                                availabilitySetInstance.getVirtualMachinesReferences().add(virtualMachineReferenceInstance);
                                JsonNode idValue = virtualMachinesValue.get("id");
                                if (idValue == null || idValue instanceof NullNode) continue;
                                String idInstance = idValue.getTextValue();
                                virtualMachineReferenceInstance.setReferenceUri(idInstance);
                            }
                        }
                        if ((statusesArray2 = propertiesValue2.get("statuses")) != null && !(statusesArray2 instanceof NullNode)) {
                            for (JsonNode statusesValue : (ArrayNode)statusesArray2) {
                                JsonNode timeValue;
                                JsonNode messageValue;
                                JsonNode displayStatusValue;
                                JsonNode levelValue;
                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                availabilitySetInstance.getStatuses().add(instanceViewStatusInstance);
                                JsonNode codeValue = statusesValue.get("code");
                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                    String codeInstance = codeValue.getTextValue();
                                    instanceViewStatusInstance.setCode(codeInstance);
                                }
                                if ((levelValue = statusesValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                    String levelInstance = levelValue.getTextValue();
                                    instanceViewStatusInstance.setLevel(levelInstance);
                                }
                                if ((displayStatusValue = statusesValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                    String displayStatusInstance = displayStatusValue.getTextValue();
                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                }
                                if ((messageValue = statusesValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                    String messageInstance = messageValue.getTextValue();
                                    instanceViewStatusInstance.setMessage(messageInstance);
                                }
                                if ((timeValue = statusesValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                instanceViewStatusInstance.setTime(timeInstance);
                            }
                        }
                    }
                    if ((idValue2 = responseDoc.get("id")) != null && !(idValue2 instanceof NullNode)) {
                        String idInstance2 = idValue2.getTextValue();
                        availabilitySetInstance.setId(idInstance2);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        availabilitySetInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        availabilitySetInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        availabilitySetInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey2 = (String)property.getKey();
                            String tagsValue2 = ((JsonNode)property.getValue()).getTextValue();
                            availabilitySetInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            availabilitySetCreateOrUpdateResponse = result;
        }
        catch (Throwable throwable) {
            if (var16_21 != null && var16_21.getEntity() != null) {
                var16_21.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return availabilitySetCreateOrUpdateResponse;
    }

    @Override
    public Future<OperationResponse> deleteAsync(final String resourceGroupName, final String availabilitySetName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return AvailabilitySetOperationsImpl.this.delete(resourceGroupName, availabilitySetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delete(String resourceGroupName, String availabilitySetName) throws IOException, ServiceException, InterruptedException, ExecutionException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (availabilitySetName == null) {
            throw new NullPointerException("availabilitySetName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("availabilitySetName", availabilitySetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        url = url + URLEncoder.encode(availabilitySetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AvailabilitySetGetResponse> getAsync(final String resourceGroupName, final String availabilitySetName) {
        return this.getClient().getExecutorService().submit(new Callable<AvailabilitySetGetResponse>(){

            @Override
            public AvailabilitySetGetResponse call() throws Exception {
                return AvailabilitySetOperationsImpl.this.get(resourceGroupName, availabilitySetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvailabilitySetGetResponse get(String resourceGroupName, String availabilitySetName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (availabilitySetName == null) {
            throw new NullPointerException("availabilitySetName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("availabilitySetName", availabilitySetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        url = url + URLEncoder.encode(availabilitySetName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            AvailabilitySetGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new AvailabilitySetGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement;
                    JsonNode locationValue;
                    JsonNode typeValue;
                    JsonNode nameValue;
                    JsonNode idValue2;
                    AvailabilitySet availabilitySetInstance = new AvailabilitySet();
                    result.setAvailabilitySet(availabilitySetInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode statusesArray;
                        JsonNode virtualMachinesArray;
                        JsonNode platformFaultDomainCountValue;
                        JsonNode platformUpdateDomainCountValue = propertiesValue.get("platformUpdateDomainCount");
                        if (platformUpdateDomainCountValue != null && !(platformUpdateDomainCountValue instanceof NullNode)) {
                            int platformUpdateDomainCountInstance = platformUpdateDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformUpdateDomainCount(platformUpdateDomainCountInstance);
                        }
                        if ((platformFaultDomainCountValue = propertiesValue.get("platformFaultDomainCount")) != null && !(platformFaultDomainCountValue instanceof NullNode)) {
                            int platformFaultDomainCountInstance = platformFaultDomainCountValue.getIntValue();
                            availabilitySetInstance.setPlatformFaultDomainCount(platformFaultDomainCountInstance);
                        }
                        if ((virtualMachinesArray = propertiesValue.get("virtualMachines")) != null && !(virtualMachinesArray instanceof NullNode)) {
                            for (Iterator virtualMachinesValue : (ArrayNode)virtualMachinesArray) {
                                VirtualMachineReference virtualMachineReferenceInstance = new VirtualMachineReference();
                                availabilitySetInstance.getVirtualMachinesReferences().add(virtualMachineReferenceInstance);
                                JsonNode idValue = virtualMachinesValue.get("id");
                                if (idValue == null || idValue instanceof NullNode) continue;
                                String idInstance = idValue.getTextValue();
                                virtualMachineReferenceInstance.setReferenceUri(idInstance);
                            }
                        }
                        if ((statusesArray = propertiesValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                            for (JsonNode statusesValue : (ArrayNode)statusesArray) {
                                JsonNode timeValue;
                                JsonNode messageValue;
                                JsonNode displayStatusValue;
                                JsonNode levelValue;
                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                availabilitySetInstance.getStatuses().add(instanceViewStatusInstance);
                                JsonNode codeValue = statusesValue.get("code");
                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                    String codeInstance = codeValue.getTextValue();
                                    instanceViewStatusInstance.setCode(codeInstance);
                                }
                                if ((levelValue = statusesValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                    String levelInstance = levelValue.getTextValue();
                                    instanceViewStatusInstance.setLevel(levelInstance);
                                }
                                if ((displayStatusValue = statusesValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                    String displayStatusInstance = displayStatusValue.getTextValue();
                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                }
                                if ((messageValue = statusesValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                    String messageInstance = messageValue.getTextValue();
                                    instanceViewStatusInstance.setMessage(messageInstance);
                                }
                                if ((timeValue = statusesValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                instanceViewStatusInstance.setTime(timeInstance);
                            }
                        }
                    }
                    if ((idValue2 = responseDoc.get("id")) != null && !(idValue2 instanceof NullNode)) {
                        String idInstance2 = idValue2.getTextValue();
                        availabilitySetInstance.setId(idInstance2);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        availabilitySetInstance.setName(nameInstance);
                    }
                    if ((typeValue = responseDoc.get("type")) != null && !(typeValue instanceof NullNode)) {
                        String typeInstance = typeValue.getTextValue();
                        availabilitySetInstance.setType(typeInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        availabilitySetInstance.setLocation(locationInstance);
                    }
                    if ((tagsSequenceElement = responseDoc.get("tags")) != null && !(tagsSequenceElement instanceof NullNode)) {
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            availabilitySetInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            AvailabilitySetGetResponse availabilitySetGetResponse = result;
            return availabilitySetGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<AvailabilitySetListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<AvailabilitySetListResponse>(){

            @Override
            public AvailabilitySetListResponse call() throws Exception {
                return AvailabilitySetOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AvailabilitySetListResponse list(String resourceGroupName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            AvailabilitySetListResponse result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new AvailabilitySetListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode tagsSequenceElement;
                        JsonNode locationValue;
                        JsonNode typeValue;
                        JsonNode nameValue;
                        JsonNode idValue2;
                        AvailabilitySet availabilitySetJsonInstance = new AvailabilitySet();
                        result.getAvailabilitySets().add(availabilitySetJsonInstance);
                        JsonNode propertiesValue = valueValue.get("properties");
                        if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                            JsonNode statusesArray;
                            JsonNode virtualMachinesArray;
                            JsonNode platformFaultDomainCountValue;
                            JsonNode platformUpdateDomainCountValue = propertiesValue.get("platformUpdateDomainCount");
                            if (platformUpdateDomainCountValue != null && !(platformUpdateDomainCountValue instanceof NullNode)) {
                                int platformUpdateDomainCountInstance = platformUpdateDomainCountValue.getIntValue();
                                availabilitySetJsonInstance.setPlatformUpdateDomainCount(platformUpdateDomainCountInstance);
                            }
                            if ((platformFaultDomainCountValue = propertiesValue.get("platformFaultDomainCount")) != null && !(platformFaultDomainCountValue instanceof NullNode)) {
                                int platformFaultDomainCountInstance = platformFaultDomainCountValue.getIntValue();
                                availabilitySetJsonInstance.setPlatformFaultDomainCount(platformFaultDomainCountInstance);
                            }
                            if ((virtualMachinesArray = propertiesValue.get("virtualMachines")) != null && !(virtualMachinesArray instanceof NullNode)) {
                                for (Iterator virtualMachinesValue : (ArrayNode)virtualMachinesArray) {
                                    VirtualMachineReference virtualMachineReferenceInstance = new VirtualMachineReference();
                                    availabilitySetJsonInstance.getVirtualMachinesReferences().add(virtualMachineReferenceInstance);
                                    JsonNode idValue = virtualMachinesValue.get("id");
                                    if (idValue == null || idValue instanceof NullNode) continue;
                                    String idInstance = idValue.getTextValue();
                                    virtualMachineReferenceInstance.setReferenceUri(idInstance);
                                }
                            }
                            if ((statusesArray = propertiesValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                Iterator virtualMachinesValue;
                                virtualMachinesValue = ((ArrayNode)statusesArray).iterator();
                                while (virtualMachinesValue.hasNext()) {
                                    JsonNode timeValue;
                                    JsonNode messageValue;
                                    JsonNode displayStatusValue;
                                    JsonNode levelValue;
                                    JsonNode statusesValue = (JsonNode)virtualMachinesValue.next();
                                    InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                    availabilitySetJsonInstance.getStatuses().add(instanceViewStatusInstance);
                                    JsonNode codeValue = statusesValue.get("code");
                                    if (codeValue != null && !(codeValue instanceof NullNode)) {
                                        String codeInstance = codeValue.getTextValue();
                                        instanceViewStatusInstance.setCode(codeInstance);
                                    }
                                    if ((levelValue = statusesValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                        String levelInstance = levelValue.getTextValue();
                                        instanceViewStatusInstance.setLevel(levelInstance);
                                    }
                                    if ((displayStatusValue = statusesValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                        String displayStatusInstance = displayStatusValue.getTextValue();
                                        instanceViewStatusInstance.setDisplayStatus(displayStatusInstance);
                                    }
                                    if ((messageValue = statusesValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                        String messageInstance = messageValue.getTextValue();
                                        instanceViewStatusInstance.setMessage(messageInstance);
                                    }
                                    if ((timeValue = statusesValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                    Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                    instanceViewStatusInstance.setTime(timeInstance);
                                }
                            }
                        }
                        if ((idValue2 = valueValue.get("id")) != null && !(idValue2 instanceof NullNode)) {
                            String idInstance2 = idValue2.getTextValue();
                            availabilitySetJsonInstance.setId(idInstance2);
                        }
                        if ((nameValue = valueValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            availabilitySetJsonInstance.setName(nameInstance);
                        }
                        if ((typeValue = valueValue.get("type")) != null && !(typeValue instanceof NullNode)) {
                            String typeInstance = typeValue.getTextValue();
                            availabilitySetJsonInstance.setType(typeInstance);
                        }
                        if ((locationValue = valueValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                            String locationInstance = locationValue.getTextValue();
                            availabilitySetJsonInstance.setLocation(locationInstance);
                        }
                        if ((tagsSequenceElement = valueValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                        Iterator itr = tagsSequenceElement.getFields();
                        while (itr.hasNext()) {
                            Map.Entry property = (Map.Entry)itr.next();
                            String tagsKey = (String)property.getKey();
                            String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                            availabilitySetJsonInstance.getTags().put(tagsKey, tagsValue);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            AvailabilitySetListResponse availabilitySetListResponse = result;
            return availabilitySetListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineSizeListResponse> listAvailableSizesAsync(final String resourceGroupName, final String availabilitySetName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineSizeListResponse>(){

            @Override
            public VirtualMachineSizeListResponse call() throws Exception {
                return AvailabilitySetOperationsImpl.this.listAvailableSizes(resourceGroupName, availabilitySetName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineSizeListResponse listAvailableSizes(String resourceGroupName, String availabilitySetName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (availabilitySetName == null) {
            throw new NullPointerException("availabilitySetName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("availabilitySetName", availabilitySetName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAvailableSizesAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/availabilitySets/";
        url = url + URLEncoder.encode(availabilitySetName, "UTF-8");
        url = url + "/vmSizes";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineSizeListResponse result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineSizeListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode maxDataDiskCountValue;
                        JsonNode memoryInMBValue;
                        JsonNode resourceDiskSizeInMBValue;
                        JsonNode osDiskSizeInMBValue;
                        JsonNode numberOfCoresValue;
                        VirtualMachineSize virtualMachineSizeInstance = new VirtualMachineSize();
                        result.getVirtualMachineSizes().add(virtualMachineSizeInstance);
                        JsonNode nameValue = valueValue.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineSizeInstance.setName(nameInstance);
                        }
                        if ((numberOfCoresValue = valueValue.get("numberOfCores")) != null && !(numberOfCoresValue instanceof NullNode)) {
                            int numberOfCoresInstance = numberOfCoresValue.getIntValue();
                            virtualMachineSizeInstance.setNumberOfCores(numberOfCoresInstance);
                        }
                        if ((osDiskSizeInMBValue = valueValue.get("osDiskSizeInMB")) != null && !(osDiskSizeInMBValue instanceof NullNode)) {
                            int osDiskSizeInMBInstance = osDiskSizeInMBValue.getIntValue();
                            virtualMachineSizeInstance.setOSDiskSizeInMB(osDiskSizeInMBInstance);
                        }
                        if ((resourceDiskSizeInMBValue = valueValue.get("resourceDiskSizeInMB")) != null && !(resourceDiskSizeInMBValue instanceof NullNode)) {
                            int resourceDiskSizeInMBInstance = resourceDiskSizeInMBValue.getIntValue();
                            virtualMachineSizeInstance.setResourceDiskSizeInMB(resourceDiskSizeInMBInstance);
                        }
                        if ((memoryInMBValue = valueValue.get("memoryInMB")) != null && !(memoryInMBValue instanceof NullNode)) {
                            int memoryInMBInstance = memoryInMBValue.getIntValue();
                            virtualMachineSizeInstance.setMemoryInMB(memoryInMBInstance);
                        }
                        if ((maxDataDiskCountValue = valueValue.get("maxDataDiskCount")) == null || maxDataDiskCountValue instanceof NullNode) continue;
                        int maxDataDiskCountInstance = maxDataDiskCountValue.getIntValue();
                        virtualMachineSizeInstance.setMaxDataDiskCount(maxDataDiskCountInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineSizeListResponse virtualMachineSizeListResponse = result;
            return virtualMachineSizeListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

