/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.VirtualMachineExtensionImageOperations;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImage;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageGetParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageListTypesParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionImageListVersionsParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResource;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResourceList;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class VirtualMachineExtensionImageOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineExtensionImageOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineExtensionImageOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualMachineExtensionImageGetResponse> getAsync(final VirtualMachineExtensionImageGetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineExtensionImageGetResponse>(){

            @Override
            public VirtualMachineExtensionImageGetResponse call() throws Exception {
                return VirtualMachineExtensionImageOperationsImpl.this.get(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineExtensionImageGetResponse get(VirtualMachineExtensionImageGetParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
            if (parameters.getType() == null) {
                throw new NullPointerException("parameters.Type");
            }
            if (parameters.getVersion() == null) {
                throw new NullPointerException("parameters.Version");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineExtensionImageGetParameters> tracingParameters = new HashMap<String, VirtualMachineExtensionImageGetParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmextension/types/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getType(), "UTF-8");
        }
        url = url + "/versions/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getVersion(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineExtensionImageGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineExtensionImageGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode locationValue;
                    JsonNode nameValue;
                    JsonNode idValue;
                    VirtualMachineExtensionImage virtualMachineExtensionImageInstance = new VirtualMachineExtensionImage();
                    result.setVirtualMachineExtensionImage(virtualMachineExtensionImageInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode supportsMultipleExtensionsValue;
                        JsonNode vmScaleSetEnabledValue;
                        JsonNode handlerSchemaValue;
                        JsonNode computeRoleValue;
                        JsonNode operatingSystemValue = propertiesValue.get("operatingSystem");
                        if (operatingSystemValue != null && !(operatingSystemValue instanceof NullNode)) {
                            String operatingSystemInstance = operatingSystemValue.getTextValue();
                            virtualMachineExtensionImageInstance.setOperatingSystem(operatingSystemInstance);
                        }
                        if ((computeRoleValue = propertiesValue.get("computeRole")) != null && !(computeRoleValue instanceof NullNode)) {
                            String computeRoleInstance = computeRoleValue.getTextValue();
                            virtualMachineExtensionImageInstance.setComputeRole(computeRoleInstance);
                        }
                        if ((handlerSchemaValue = propertiesValue.get("handlerSchema")) != null && !(handlerSchemaValue instanceof NullNode)) {
                            String handlerSchemaInstance = handlerSchemaValue.getTextValue();
                            virtualMachineExtensionImageInstance.setHandlerSchema(handlerSchemaInstance);
                        }
                        if ((vmScaleSetEnabledValue = propertiesValue.get("vmScaleSetEnabled")) != null && !(vmScaleSetEnabledValue instanceof NullNode)) {
                            boolean vmScaleSetEnabledInstance = vmScaleSetEnabledValue.getBooleanValue();
                            virtualMachineExtensionImageInstance.setVMScaleSetEnabled(vmScaleSetEnabledInstance);
                        }
                        if ((supportsMultipleExtensionsValue = propertiesValue.get("supportsMultipleExtensions")) != null && !(supportsMultipleExtensionsValue instanceof NullNode)) {
                            boolean supportsMultipleExtensionsInstance = supportsMultipleExtensionsValue.getBooleanValue();
                            virtualMachineExtensionImageInstance.setSupportsMultipleExtensions(supportsMultipleExtensionsInstance);
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        virtualMachineExtensionImageInstance.setId(idInstance);
                    }
                    if ((nameValue = responseDoc.get("name")) != null && !(nameValue instanceof NullNode)) {
                        String nameInstance = nameValue.getTextValue();
                        virtualMachineExtensionImageInstance.setName(nameInstance);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineExtensionImageInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineExtensionImageGetResponse virtualMachineExtensionImageGetResponse = result;
            return virtualMachineExtensionImageGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineImageResourceList> listTypesAsync(final VirtualMachineExtensionImageListTypesParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>(){

            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return VirtualMachineExtensionImageOperationsImpl.this.listTypes(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineImageResourceList listTypes(VirtualMachineExtensionImageListTypesParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineExtensionImageListTypesParameters> tracingParameters = new HashMap<String, VirtualMachineExtensionImageListTypesParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listTypesAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmextension/types";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineImageResourceList result = null;
            if (statusCode == 200) {
                JsonNode resourcesArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (resourcesArray = responseDoc) != null && !(resourcesArray instanceof NullNode)) {
                    for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                        JsonNode locationValue;
                        JsonNode nameValue;
                        VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                        result.getResources().add(virtualMachineImageResourceInstance);
                        JsonNode idValue = resourcesValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            virtualMachineImageResourceInstance.setId(idInstance);
                        }
                        if ((nameValue = resourcesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineImageResourceInstance.setName(nameInstance);
                        }
                        if ((locationValue = resourcesValue.get("location")) == null || locationValue instanceof NullNode) continue;
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineImageResourceInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineImageResourceList virtualMachineImageResourceList = result;
            return virtualMachineImageResourceList;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineImageResourceList> listVersionsAsync(final VirtualMachineExtensionImageListVersionsParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>(){

            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return VirtualMachineExtensionImageOperationsImpl.this.listVersions(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineImageResourceList listVersions(VirtualMachineExtensionImageListVersionsParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
            if (parameters.getType() == null) {
                throw new NullPointerException("parameters.Type");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineExtensionImageListVersionsParameters> tracingParameters = new HashMap<String, VirtualMachineExtensionImageListVersionsParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listVersionsAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmextension/types/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getType(), "UTF-8");
        }
        url = url + "/versions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (parameters != null && parameters.getFilterExpression() != null) {
            queryParameters.add(parameters.getFilterExpression());
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineImageResourceList result = null;
            if (statusCode == 200) {
                JsonNode resourcesArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (resourcesArray = responseDoc) != null && !(resourcesArray instanceof NullNode)) {
                    for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                        JsonNode locationValue;
                        JsonNode nameValue;
                        VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                        result.getResources().add(virtualMachineImageResourceInstance);
                        JsonNode idValue = resourcesValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            virtualMachineImageResourceInstance.setId(idInstance);
                        }
                        if ((nameValue = resourcesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineImageResourceInstance.setName(nameInstance);
                        }
                        if ((locationValue = resourcesValue.get("location")) == null || locationValue instanceof NullNode) continue;
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineImageResourceInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineImageResourceList virtualMachineImageResourceList = result;
            return virtualMachineImageResourceList;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

