/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.VirtualMachineImageOperations;
import com.microsoft.azure.management.compute.models.DataDiskImage;
import com.microsoft.azure.management.compute.models.OSDiskImage;
import com.microsoft.azure.management.compute.models.PurchasePlan;
import com.microsoft.azure.management.compute.models.VirtualMachineImage;
import com.microsoft.azure.management.compute.models.VirtualMachineImageGetParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListOffersParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListPublishersParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageListSkusParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResource;
import com.microsoft.azure.management.compute.models.VirtualMachineImageResourceList;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class VirtualMachineImageOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineImageOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineImageOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualMachineImageGetResponse> getAsync(final VirtualMachineImageGetParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageGetResponse>(){

            @Override
            public VirtualMachineImageGetResponse call() throws Exception {
                return VirtualMachineImageOperationsImpl.this.get(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineImageGetResponse get(VirtualMachineImageGetParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getOffer() == null) {
                throw new NullPointerException("parameters.Offer");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
            if (parameters.getSkus() == null) {
                throw new NullPointerException("parameters.Skus");
            }
            if (parameters.getVersion() == null) {
                throw new NullPointerException("parameters.Version");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineImageGetParameters> tracingParameters = new HashMap<String, VirtualMachineImageGetParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getOffer(), "UTF-8");
        }
        url = url + "/skus/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getSkus(), "UTF-8");
        }
        url = url + "/versions/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getVersion(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineImageGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode locationValue;
                    JsonNode nameValue2;
                    JsonNode idValue;
                    VirtualMachineImage virtualMachineImageInstance = new VirtualMachineImage();
                    result.setVirtualMachineImage(virtualMachineImageInstance);
                    JsonNode propertiesValue = responseDoc.get("properties");
                    if (propertiesValue != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode dataDiskImagesArray;
                        JsonNode osDiskImageValue;
                        JsonNode planValue = propertiesValue.get("plan");
                        if (planValue != null && !(planValue instanceof NullNode)) {
                            JsonNode productValue;
                            JsonNode nameValue;
                            PurchasePlan planInstance = new PurchasePlan();
                            virtualMachineImageInstance.setPurchasePlan(planInstance);
                            JsonNode publisherValue = planValue.get("publisher");
                            if (publisherValue != null && !(publisherValue instanceof NullNode)) {
                                String publisherInstance = publisherValue.getTextValue();
                                planInstance.setPublisher(publisherInstance);
                            }
                            if ((nameValue = planValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                                String nameInstance = nameValue.getTextValue();
                                planInstance.setName(nameInstance);
                            }
                            if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                                String productInstance = productValue.getTextValue();
                                planInstance.setProduct(productInstance);
                            }
                        }
                        if ((osDiskImageValue = propertiesValue.get("osDiskImage")) != null && !(osDiskImageValue instanceof NullNode)) {
                            OSDiskImage osDiskImageInstance = new OSDiskImage();
                            virtualMachineImageInstance.setOSDiskImage(osDiskImageInstance);
                            Iterator operatingSystemValue = osDiskImageValue.get("operatingSystem");
                            if (operatingSystemValue != null && !(operatingSystemValue instanceof NullNode)) {
                                String operatingSystemInstance = operatingSystemValue.getTextValue();
                                osDiskImageInstance.setOperatingSystem(operatingSystemInstance);
                            }
                        }
                        if ((dataDiskImagesArray = propertiesValue.get("dataDiskImages")) != null && !(dataDiskImagesArray instanceof NullNode)) {
                            for (JsonNode dataDiskImagesValue : (ArrayNode)dataDiskImagesArray) {
                                DataDiskImage dataDiskImageInstance = new DataDiskImage();
                                virtualMachineImageInstance.getDataDiskImages().add(dataDiskImageInstance);
                                JsonNode lunValue = dataDiskImagesValue.get("lun");
                                if (lunValue == null || lunValue instanceof NullNode) continue;
                                int lunInstance = lunValue.getIntValue();
                                dataDiskImageInstance.setLun(lunInstance);
                            }
                        }
                    }
                    if ((idValue = responseDoc.get("id")) != null && !(idValue instanceof NullNode)) {
                        String idInstance = idValue.getTextValue();
                        virtualMachineImageInstance.setId(idInstance);
                    }
                    if ((nameValue2 = responseDoc.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                        String nameInstance2 = nameValue2.getTextValue();
                        virtualMachineImageInstance.setName(nameInstance2);
                    }
                    if ((locationValue = responseDoc.get("location")) != null && !(locationValue instanceof NullNode)) {
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineImageInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineImageGetResponse virtualMachineImageGetResponse = result;
            return virtualMachineImageGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineImageResourceList> listAsync(final VirtualMachineImageListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>(){

            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return VirtualMachineImageOperationsImpl.this.list(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineImageResourceList list(VirtualMachineImageListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getOffer() == null) {
                throw new NullPointerException("parameters.Offer");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
            if (parameters.getSkus() == null) {
                throw new NullPointerException("parameters.Skus");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineImageListParameters> tracingParameters = new HashMap<String, VirtualMachineImageListParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getOffer(), "UTF-8");
        }
        url = url + "/skus/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getSkus(), "UTF-8");
        }
        url = url + "/versions";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (parameters != null && parameters.getFilterExpression() != null) {
            queryParameters.add(parameters.getFilterExpression());
        }
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineImageResourceList result = null;
            if (statusCode == 200) {
                JsonNode resourcesArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (resourcesArray = responseDoc) != null && !(resourcesArray instanceof NullNode)) {
                    for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                        JsonNode locationValue;
                        JsonNode nameValue;
                        VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                        result.getResources().add(virtualMachineImageResourceInstance);
                        JsonNode idValue = resourcesValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            virtualMachineImageResourceInstance.setId(idInstance);
                        }
                        if ((nameValue = resourcesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineImageResourceInstance.setName(nameInstance);
                        }
                        if ((locationValue = resourcesValue.get("location")) == null || locationValue instanceof NullNode) continue;
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineImageResourceInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineImageResourceList virtualMachineImageResourceList = result;
            return virtualMachineImageResourceList;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineImageResourceList> listOffersAsync(final VirtualMachineImageListOffersParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>(){

            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return VirtualMachineImageOperationsImpl.this.listOffers(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineImageResourceList listOffers(VirtualMachineImageListOffersParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineImageListOffersParameters> tracingParameters = new HashMap<String, VirtualMachineImageListOffersParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listOffersAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineImageResourceList result = null;
            if (statusCode == 200) {
                JsonNode resourcesArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (resourcesArray = responseDoc) != null && !(resourcesArray instanceof NullNode)) {
                    for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                        JsonNode locationValue;
                        JsonNode nameValue;
                        VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                        result.getResources().add(virtualMachineImageResourceInstance);
                        JsonNode idValue = resourcesValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            virtualMachineImageResourceInstance.setId(idInstance);
                        }
                        if ((nameValue = resourcesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineImageResourceInstance.setName(nameInstance);
                        }
                        if ((locationValue = resourcesValue.get("location")) == null || locationValue instanceof NullNode) continue;
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineImageResourceInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineImageResourceList virtualMachineImageResourceList = result;
            return virtualMachineImageResourceList;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineImageResourceList> listPublishersAsync(final VirtualMachineImageListPublishersParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>(){

            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return VirtualMachineImageOperationsImpl.this.listPublishers(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineImageResourceList listPublishers(VirtualMachineImageListPublishersParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (parameters != null && parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineImageListPublishersParameters> tracingParameters = new HashMap<String, VirtualMachineImageListPublishersParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listPublishersAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineImageResourceList result = null;
            if (statusCode == 200) {
                JsonNode resourcesArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (resourcesArray = responseDoc) != null && !(resourcesArray instanceof NullNode)) {
                    for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                        JsonNode locationValue;
                        JsonNode nameValue;
                        VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                        result.getResources().add(virtualMachineImageResourceInstance);
                        JsonNode idValue = resourcesValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            virtualMachineImageResourceInstance.setId(idInstance);
                        }
                        if ((nameValue = resourcesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineImageResourceInstance.setName(nameInstance);
                        }
                        if ((locationValue = resourcesValue.get("location")) == null || locationValue instanceof NullNode) continue;
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineImageResourceInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineImageResourceList virtualMachineImageResourceList = result;
            return virtualMachineImageResourceList;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineImageResourceList> listSkusAsync(final VirtualMachineImageListSkusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineImageResourceList>(){

            @Override
            public VirtualMachineImageResourceList call() throws Exception {
                return VirtualMachineImageOperationsImpl.this.listSkus(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineImageResourceList listSkus(VirtualMachineImageListSkusParameters parameters) throws IOException, ServiceException {
        String baseUrl;
        if (parameters != null) {
            if (parameters.getLocation() == null) {
                throw new NullPointerException("parameters.Location");
            }
            if (parameters.getOffer() == null) {
                throw new NullPointerException("parameters.Offer");
            }
            if (parameters.getPublisherName() == null) {
                throw new NullPointerException("parameters.PublisherName");
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, VirtualMachineImageListSkusParameters> tracingParameters = new HashMap<String, VirtualMachineImageListSkusParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listSkusAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getLocation(), "UTF-8");
        }
        url = url + "/publishers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getPublisherName(), "UTF-8");
        }
        url = url + "/artifacttypes/vmimage/offers/";
        if (parameters != null) {
            url = url + URLEncoder.encode(parameters.getOffer(), "UTF-8");
        }
        url = url + "/skus";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineImageResourceList result = null;
            if (statusCode == 200) {
                JsonNode resourcesArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineImageResourceList();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                if (!(responseContent == null)) {
                    responseDoc = objectMapper.readTree(responseContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (resourcesArray = responseDoc) != null && !(resourcesArray instanceof NullNode)) {
                    for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                        JsonNode locationValue;
                        JsonNode nameValue;
                        VirtualMachineImageResource virtualMachineImageResourceInstance = new VirtualMachineImageResource();
                        result.getResources().add(virtualMachineImageResourceInstance);
                        JsonNode idValue = resourcesValue.get("id");
                        if (idValue != null && !(idValue instanceof NullNode)) {
                            String idInstance = idValue.getTextValue();
                            virtualMachineImageResourceInstance.setId(idInstance);
                        }
                        if ((nameValue = resourcesValue.get("name")) != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineImageResourceInstance.setName(nameInstance);
                        }
                        if ((locationValue = resourcesValue.get("location")) == null || locationValue instanceof NullNode) continue;
                        String locationInstance = locationValue.getTextValue();
                        virtualMachineImageResourceInstance.setLocation(locationInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineImageResourceList virtualMachineImageResourceList = result;
            return virtualMachineImageResourceList;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

