/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.VirtualMachineSizeOperations;
import com.microsoft.azure.management.compute.models.VirtualMachineSize;
import com.microsoft.azure.management.compute.models.VirtualMachineSizeListResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;

public class VirtualMachineSizeOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineSizeOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineSizeOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<VirtualMachineSizeListResponse> listAsync(final String location) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineSizeListResponse>(){

            @Override
            public VirtualMachineSizeListResponse call() throws Exception {
                return VirtualMachineSizeOperationsImpl.this.list(location);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineSizeListResponse list(String location) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (location == null) {
            throw new NullPointerException("location");
        }
        if (location != null && location.length() > 1000) {
            throw new IllegalArgumentException("location");
        }
        if (!Pattern.matches("^[-\\w\\._]+$", location)) {
            throw new IllegalArgumentException("location");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("location", location);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/locations/";
        url = url + URLEncoder.encode(location, "UTF-8");
        url = url + "/vmSizes";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineSizeListResponse result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineSizeListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode maxDataDiskCountValue;
                        JsonNode memoryInMBValue;
                        JsonNode resourceDiskSizeInMBValue;
                        JsonNode osDiskSizeInMBValue;
                        JsonNode numberOfCoresValue;
                        VirtualMachineSize virtualMachineSizeInstance = new VirtualMachineSize();
                        result.getVirtualMachineSizes().add(virtualMachineSizeInstance);
                        JsonNode nameValue = valueValue.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineSizeInstance.setName(nameInstance);
                        }
                        if ((numberOfCoresValue = valueValue.get("numberOfCores")) != null && !(numberOfCoresValue instanceof NullNode)) {
                            int numberOfCoresInstance = numberOfCoresValue.getIntValue();
                            virtualMachineSizeInstance.setNumberOfCores(numberOfCoresInstance);
                        }
                        if ((osDiskSizeInMBValue = valueValue.get("osDiskSizeInMB")) != null && !(osDiskSizeInMBValue instanceof NullNode)) {
                            int osDiskSizeInMBInstance = osDiskSizeInMBValue.getIntValue();
                            virtualMachineSizeInstance.setOSDiskSizeInMB(osDiskSizeInMBInstance);
                        }
                        if ((resourceDiskSizeInMBValue = valueValue.get("resourceDiskSizeInMB")) != null && !(resourceDiskSizeInMBValue instanceof NullNode)) {
                            int resourceDiskSizeInMBInstance = resourceDiskSizeInMBValue.getIntValue();
                            virtualMachineSizeInstance.setResourceDiskSizeInMB(resourceDiskSizeInMBInstance);
                        }
                        if ((memoryInMBValue = valueValue.get("memoryInMB")) != null && !(memoryInMBValue instanceof NullNode)) {
                            int memoryInMBInstance = memoryInMBValue.getIntValue();
                            virtualMachineSizeInstance.setMemoryInMB(memoryInMBInstance);
                        }
                        if ((maxDataDiskCountValue = valueValue.get("maxDataDiskCount")) == null || maxDataDiskCountValue instanceof NullNode) continue;
                        int maxDataDiskCountInstance = maxDataDiskCountValue.getIntValue();
                        virtualMachineSizeInstance.setMaxDataDiskCount(maxDataDiskCountInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineSizeListResponse virtualMachineSizeListResponse = result;
            return virtualMachineSizeListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
}

