/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetsInner;
import com.microsoft.azure.management.compute.implementation.ContainerServicesInner;
import com.microsoft.azure.management.compute.implementation.DisksInner;
import com.microsoft.azure.management.compute.implementation.ImagesInner;
import com.microsoft.azure.management.compute.implementation.SnapshotsInner;
import com.microsoft.azure.management.compute.implementation.UsagesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionImagesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineExtensionsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineImagesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetVMsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineScaleSetsInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizesInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachinesInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ComputeManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private AvailabilitySetsInner availabilitySets;
    private VirtualMachineExtensionImagesInner virtualMachineExtensionImages;
    private VirtualMachineExtensionsInner virtualMachineExtensions;
    private VirtualMachineImagesInner virtualMachineImages;
    private UsagesInner usages;
    private VirtualMachineSizesInner virtualMachineSizes;
    private ImagesInner images;
    private VirtualMachinesInner virtualMachines;
    private VirtualMachineScaleSetsInner virtualMachineScaleSets;
    private VirtualMachineScaleSetVMsInner virtualMachineScaleSetVMs;
    private ContainerServicesInner containerServices;
    private DisksInner disks;
    private SnapshotsInner snapshots;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ComputeManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ComputeManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ComputeManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ComputeManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public AvailabilitySetsInner availabilitySets() {
        return this.availabilitySets;
    }

    public VirtualMachineExtensionImagesInner virtualMachineExtensionImages() {
        return this.virtualMachineExtensionImages;
    }

    public VirtualMachineExtensionsInner virtualMachineExtensions() {
        return this.virtualMachineExtensions;
    }

    public VirtualMachineImagesInner virtualMachineImages() {
        return this.virtualMachineImages;
    }

    public UsagesInner usages() {
        return this.usages;
    }

    public VirtualMachineSizesInner virtualMachineSizes() {
        return this.virtualMachineSizes;
    }

    public ImagesInner images() {
        return this.images;
    }

    public VirtualMachinesInner virtualMachines() {
        return this.virtualMachines;
    }

    public VirtualMachineScaleSetsInner virtualMachineScaleSets() {
        return this.virtualMachineScaleSets;
    }

    public VirtualMachineScaleSetVMsInner virtualMachineScaleSetVMs() {
        return this.virtualMachineScaleSetVMs;
    }

    public ContainerServicesInner containerServices() {
        return this.containerServices;
    }

    public DisksInner disks() {
        return this.disks;
    }

    public SnapshotsInner snapshots() {
        return this.snapshots;
    }

    public ComputeManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ComputeManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ComputeManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.availabilitySets = new AvailabilitySetsInner(this.restClient().retrofit(), this);
        this.virtualMachineExtensionImages = new VirtualMachineExtensionImagesInner(this.restClient().retrofit(), this);
        this.virtualMachineExtensions = new VirtualMachineExtensionsInner(this.restClient().retrofit(), this);
        this.virtualMachineImages = new VirtualMachineImagesInner(this.restClient().retrofit(), this);
        this.usages = new UsagesInner(this.restClient().retrofit(), this);
        this.virtualMachineSizes = new VirtualMachineSizesInner(this.restClient().retrofit(), this);
        this.images = new ImagesInner(this.restClient().retrofit(), this);
        this.virtualMachines = new VirtualMachinesInner(this.restClient().retrofit(), this);
        this.virtualMachineScaleSets = new VirtualMachineScaleSetsInner(this.restClient().retrofit(), this);
        this.virtualMachineScaleSetVMs = new VirtualMachineScaleSetVMsInner(this.restClient().retrofit(), this);
        this.containerServices = new ContainerServicesInner(this.restClient().retrofit(), this);
        this.disks = new DisksInner(this.restClient().retrofit(), this);
        this.snapshots = new SnapshotsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "ComputeManagementClient");
    }
}

