/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AccessLevel;
import com.microsoft.azure.management.compute.CreationData;
import com.microsoft.azure.management.compute.CreationSource;
import com.microsoft.azure.management.compute.Disk;
import com.microsoft.azure.management.compute.DiskCreateOption;
import com.microsoft.azure.management.compute.DiskSkuTypes;
import com.microsoft.azure.management.compute.OperatingSystemTypes;
import com.microsoft.azure.management.compute.Snapshot;
import com.microsoft.azure.management.compute.implementation.AccessUriInner;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.GrantAccessDataInner;
import com.microsoft.azure.management.compute.implementation.SnapshotInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SnapshotImpl
extends GroupableResourceImpl<Snapshot, SnapshotInner, SnapshotImpl, ComputeManager>
implements Snapshot,
Snapshot.Definition,
Snapshot.Update {
    SnapshotImpl(String name, SnapshotInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (ManagerBase)computeManager);
    }

    @Override
    public DiskSkuTypes sku() {
        return new DiskSkuTypes(((SnapshotInner)((Object)this.inner())).accountType());
    }

    @Override
    public DiskCreateOption creationMethod() {
        return ((SnapshotInner)((Object)this.inner())).creationData().createOption();
    }

    @Override
    public int sizeInGB() {
        return Utils.toPrimitiveInt((Integer)((SnapshotInner)((Object)this.inner())).diskSizeGB());
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((SnapshotInner)((Object)this.inner())).osType();
    }

    @Override
    public CreationSource source() {
        return new CreationSource(((SnapshotInner)((Object)this.inner())).creationData());
    }

    @Override
    public String grantAccess(int accessDurationInSeconds) {
        return (String)this.grantAccessAsync(accessDurationInSeconds).toBlocking().last();
    }

    @Override
    public Observable<String> grantAccessAsync(int accessDurationInSeconds) {
        GrantAccessDataInner grantAccessDataInner = new GrantAccessDataInner();
        grantAccessDataInner.withAccess(AccessLevel.READ).withDurationInSeconds(accessDurationInSeconds);
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).snapshots().grantAccessAsync(this.resourceGroupName(), this.name(), grantAccessDataInner).map((Func1)new Func1<AccessUriInner, String>(){

            public String call(AccessUriInner accessUriInner) {
                if (accessUriInner == null) {
                    return null;
                }
                return accessUriInner.accessSAS();
            }
        });
    }

    @Override
    public ServiceFuture<String> grantAccessAsync(int accessDurationInSeconds, ServiceCallback<String> callback) {
        return ServiceFuture.fromBody(this.grantAccessAsync(accessDurationInSeconds), callback);
    }

    @Override
    public void revokeAccess() {
        this.revokeAccessAsync().await();
    }

    @Override
    public Completable revokeAccessAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).snapshots().revokeAccessAsync(this.resourceGroupName(), this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> revokeAccessAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.revokeAccessAsync().toObservable(), callback);
    }

    @Override
    public SnapshotImpl withLinuxFromVhd(String vhdUrl) {
        ((SnapshotInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(String sourceDiskId) {
        ((SnapshotInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(Disk sourceDisk) {
        this.withLinuxFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)((Object)this.inner())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(Snapshot sourceSnapshot) {
        this.withLinuxFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.sku());
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromVhd(String vhdUrl) {
        ((SnapshotInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(String sourceDiskId) {
        ((SnapshotInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(Disk sourceDisk) {
        this.withWindowsFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)((Object)this.inner())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(Snapshot sourceSnapshot) {
        this.withWindowsFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.sku());
        return this;
    }

    @Override
    public SnapshotImpl withDataFromVhd(String vhdUrl) {
        ((SnapshotInner)((Object)this.inner())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(String snapshotId) {
        ((SnapshotInner)((Object)this.inner())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(snapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(Snapshot snapshot) {
        return this.withDataFromSnapshot(snapshot.id());
    }

    @Override
    public SnapshotImpl withDataFromDisk(String managedDiskId) {
        ((SnapshotInner)((Object)this.inner())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(managedDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromDisk(Disk managedDisk) {
        return this.withDataFromDisk(managedDisk.id()).withOSType(managedDisk.osType()).withSku(managedDisk.sku());
    }

    @Override
    public SnapshotImpl withSizeInGB(int sizeInGB) {
        ((SnapshotInner)((Object)this.inner())).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public SnapshotImpl withOSType(OperatingSystemTypes osType) {
        ((SnapshotInner)((Object)this.inner())).withOsType(osType);
        return this;
    }

    @Override
    public SnapshotImpl withSku(DiskSkuTypes sku) {
        ((SnapshotInner)((Object)this.inner())).withAccountType(sku.accountType());
        return this;
    }

    public Observable<Snapshot> createResourceAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).snapshots().createOrUpdateAsync(this.resourceGroupName(), this.name(), (SnapshotInner)((Object)this.inner())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<SnapshotInner> getInnerAsync() {
        return ((ComputeManagementClientImpl)((Object)((ComputeManager)this.manager()).inner())).snapshots().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }
}

