/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.compute.AccessLevel;
import com.microsoft.azure.management.compute.Snapshot;
import com.microsoft.azure.management.compute.Snapshots;
import com.microsoft.azure.management.compute.implementation.AccessUriInner;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.compute.implementation.GrantAccessDataInner;
import com.microsoft.azure.management.compute.implementation.SnapshotImpl;
import com.microsoft.azure.management.compute.implementation.SnapshotInner;
import com.microsoft.azure.management.compute.implementation.SnapshotsInner;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class SnapshotsImpl
extends TopLevelModifiableResourcesImpl<Snapshot, SnapshotImpl, SnapshotInner, SnapshotsInner, ComputeManager>
implements Snapshots {
    SnapshotsImpl(ComputeManager computeManager) {
        super((InnerSupportsListing)((ComputeManagementClientImpl)((Object)computeManager.inner())).snapshots(), (ManagerBase)computeManager);
    }

    @Override
    public Observable<String> grantAccessAsync(String resourceGroupName, String snapshotName, AccessLevel accessLevel, int accessDuration) {
        GrantAccessDataInner grantAccessDataInner = new GrantAccessDataInner();
        grantAccessDataInner.withAccess(accessLevel).withDurationInSeconds(accessDuration);
        return ((SnapshotsInner)this.inner()).grantAccessAsync(resourceGroupName, snapshotName, grantAccessDataInner).map((Func1)new Func1<AccessUriInner, String>(){

            public String call(AccessUriInner accessUriInner) {
                return accessUriInner.accessSAS();
            }
        });
    }

    @Override
    public ServiceFuture<String> grantAccessAsync(String resourceGroupName, String snapshotName, AccessLevel accessLevel, int accessDuration, ServiceCallback<String> callback) {
        return ServiceFuture.fromBody(this.grantAccessAsync(resourceGroupName, snapshotName, accessLevel, accessDuration), callback);
    }

    @Override
    public String grantAccess(String resourceGroupName, String snapshotName, AccessLevel accessLevel, int accessDuration) {
        return (String)this.grantAccessAsync(resourceGroupName, snapshotName, accessLevel, accessDuration).toBlocking().last();
    }

    @Override
    public Completable revokeAccessAsync(String resourceGroupName, String snapName) {
        return ((SnapshotsInner)this.inner()).revokeAccessAsync(resourceGroupName, snapName).toCompletable();
    }

    @Override
    public ServiceFuture<Void> revokeAccessAsync(String resourceGroupName, String snapName, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.revokeAccessAsync(resourceGroupName, snapName).toObservable(), callback);
    }

    @Override
    public void revokeAccess(String resourceGroupName, String snapName) {
        this.revokeAccessAsync(resourceGroupName, snapName).await();
    }

    protected SnapshotImpl wrapModel(String name) {
        return new SnapshotImpl(name, new SnapshotInner(), (ComputeManager)this.manager());
    }

    protected SnapshotImpl wrapModel(SnapshotInner inner) {
        return new SnapshotImpl(inner.name(), inner, (ComputeManager)this.manager());
    }

    public Snapshot.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }
}

