/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.InstanceViewTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.OperationStatusResponseInner;
import com.microsoft.azure.management.compute.implementation.PageImpl;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCaptureParametersInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineCaptureResultInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineInner;
import com.microsoft.azure.management.compute.implementation.VirtualMachineSizeInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualMachinesInner
implements InnerSupportsGet<VirtualMachineInner>,
InnerSupportsDelete<OperationStatusResponseInner>,
InnerSupportsListing<VirtualMachineInner> {
    private VirtualMachinesService service;
    private ComputeManagementClientImpl client;

    public VirtualMachinesInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (VirtualMachinesService)retrofit.create(VirtualMachinesService.class);
        this.client = client;
    }

    public VirtualMachineCaptureResultInner capture(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters) {
        return (VirtualMachineCaptureResultInner)((Object)((ServiceResponse)this.captureWithServiceResponseAsync(resourceGroupName, vmName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualMachineCaptureResultInner> captureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters, ServiceCallback<VirtualMachineCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.captureWithServiceResponseAsync(resourceGroupName, vmName, parameters), serviceCallback);
    }

    public Observable<VirtualMachineCaptureResultInner> captureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters) {
        return this.captureWithServiceResponseAsync(resourceGroupName, vmName, parameters).map((Func1)new Func1<ServiceResponse<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner>(){

            public VirtualMachineCaptureResultInner call(ServiceResponse<VirtualMachineCaptureResultInner> response) {
                return (VirtualMachineCaptureResultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineCaptureResultInner>> captureWithServiceResponseAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.capture(resourceGroupName, vmName, this.client.subscriptionId(), parameters, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<VirtualMachineCaptureResultInner>(){}.getType());
    }

    public VirtualMachineCaptureResultInner beginCapture(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters) {
        return (VirtualMachineCaptureResultInner)((Object)((ServiceResponse)this.beginCaptureWithServiceResponseAsync(resourceGroupName, vmName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineCaptureResultInner> beginCaptureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters, ServiceCallback<VirtualMachineCaptureResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCaptureWithServiceResponseAsync(resourceGroupName, vmName, parameters), serviceCallback);
    }

    public Observable<VirtualMachineCaptureResultInner> beginCaptureAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters) {
        return this.beginCaptureWithServiceResponseAsync(resourceGroupName, vmName, parameters).map((Func1)new Func1<ServiceResponse<VirtualMachineCaptureResultInner>, VirtualMachineCaptureResultInner>(){

            public VirtualMachineCaptureResultInner call(ServiceResponse<VirtualMachineCaptureResultInner> response) {
                return (VirtualMachineCaptureResultInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineCaptureResultInner>> beginCaptureWithServiceResponseAsync(String resourceGroupName, String vmName, VirtualMachineCaptureParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2016-04-30-preview";
        return this.service.beginCapture(resourceGroupName, vmName, this.client.subscriptionId(), parameters, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineCaptureResultInner>>>(){

            public Observable<ServiceResponse<VirtualMachineCaptureResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginCaptureDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineCaptureResultInner> beginCaptureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineCaptureResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineInner createOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        return (VirtualMachineInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualMachineInner> createOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters, ServiceCallback<VirtualMachineInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, parameters), serviceCallback);
    }

    public Observable<VirtualMachineInner> createOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, parameters).map((Func1)new Func1<ServiceResponse<VirtualMachineInner>, VirtualMachineInner>(){

            public VirtualMachineInner call(ServiceResponse<VirtualMachineInner> response) {
                return (VirtualMachineInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, vmName, this.client.subscriptionId(), parameters, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualMachineInner>(){}.getType());
    }

    public VirtualMachineInner beginCreateOrUpdate(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        return (VirtualMachineInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters, ServiceCallback<VirtualMachineInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, parameters), serviceCallback);
    }

    public Observable<VirtualMachineInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vmName, parameters).map((Func1)new Func1<ServiceResponse<VirtualMachineInner>, VirtualMachineInner>(){

            public VirtualMachineInner call(ServiceResponse<VirtualMachineInner> response) {
                return (VirtualMachineInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vmName, VirtualMachineInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2016-04-30-preview";
        return this.service.beginCreateOrUpdate(resourceGroupName, vmName, this.client.subscriptionId(), parameters, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineInner>>>(){

            public Observable<ServiceResponse<VirtualMachineInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineInner>(){}.getType()).register(201, new TypeToken<VirtualMachineInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner delete(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> deleteAsync(String resourceGroupName, String vmName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> deleteWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginDelete(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginDeleteAsync(String resourceGroupName, String vmName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginDelete(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VirtualMachineInner getByResourceGroup(String resourceGroupName, String vmName) {
        return (VirtualMachineInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineInner> getByResourceGroupAsync(String resourceGroupName, String vmName, ServiceCallback<VirtualMachineInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<VirtualMachineInner> getByResourceGroupAsync(String resourceGroupName, String vmName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<VirtualMachineInner>, VirtualMachineInner>(){

            public VirtualMachineInner call(ServiceResponse<VirtualMachineInner> response) {
                return (VirtualMachineInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        InstanceViewTypes expand = null;
        return this.service.getByResourceGroup(resourceGroupName, vmName, this.client.subscriptionId(), expand, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineInner>>>(){

            public Observable<ServiceResponse<VirtualMachineInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VirtualMachineInner getByResourceGroup(String resourceGroupName, String vmName, InstanceViewTypes expand) {
        return (VirtualMachineInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vmName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualMachineInner> getByResourceGroupAsync(String resourceGroupName, String vmName, InstanceViewTypes expand, ServiceCallback<VirtualMachineInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vmName, expand), serviceCallback);
    }

    public Observable<VirtualMachineInner> getByResourceGroupAsync(String resourceGroupName, String vmName, InstanceViewTypes expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vmName, expand).map((Func1)new Func1<ServiceResponse<VirtualMachineInner>, VirtualMachineInner>(){

            public VirtualMachineInner call(ServiceResponse<VirtualMachineInner> response) {
                return (VirtualMachineInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualMachineInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vmName, InstanceViewTypes expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.getByResourceGroup(resourceGroupName, vmName, this.client.subscriptionId(), expand, "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualMachineInner>>>(){

            public Observable<ServiceResponse<VirtualMachineInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualMachineInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualMachineInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner convertToManagedDisks(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.convertToManagedDisksWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> convertToManagedDisksAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.convertToManagedDisksWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> convertToManagedDisksAsync(String resourceGroupName, String vmName) {
        return this.convertToManagedDisksWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> convertToManagedDisksWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.convertToManagedDisks(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginConvertToManagedDisks(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginConvertToManagedDisksWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginConvertToManagedDisksAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginConvertToManagedDisksWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginConvertToManagedDisksAsync(String resourceGroupName, String vmName) {
        return this.beginConvertToManagedDisksWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginConvertToManagedDisksWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginConvertToManagedDisks(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginConvertToManagedDisksDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginConvertToManagedDisksDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner deallocate(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.deallocateWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> deallocateAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deallocateWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> deallocateAsync(String resourceGroupName, String vmName) {
        return this.deallocateWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> deallocateWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.deallocate(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginDeallocate(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginDeallocateWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginDeallocateAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeallocateWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginDeallocateAsync(String resourceGroupName, String vmName) {
        return this.beginDeallocateWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginDeallocateWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginDeallocate(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginDeallocateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginDeallocateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner generalize(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.generalizeWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> generalizeAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.generalizeWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> generalizeAsync(String resourceGroupName, String vmName) {
        return this.generalizeWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> generalizeWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.generalize(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.generalizeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> generalizeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VirtualMachineInner>((Page)response.body()){

            public Page<VirtualMachineInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachinesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VirtualMachineInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(String nextPageLink) {
                return VirtualMachinesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Page<VirtualMachineInner>>(){

            public Page<VirtualMachineInner> call(ServiceResponse<Page<VirtualMachineInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(ServiceResponse<Page<VirtualMachineInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachinesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachinesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VirtualMachineInner>((Page)response.body()){

            public Page<VirtualMachineInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachinesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineInner>> listAsync(ListOperationCallback<VirtualMachineInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(String nextPageLink) {
                return VirtualMachinesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Page<VirtualMachineInner>>(){

            public Page<VirtualMachineInner> call(ServiceResponse<Page<VirtualMachineInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(ServiceResponse<Page<VirtualMachineInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachinesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.list(this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachinesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<VirtualMachineSizeInner> listAvailableSizes(String resourceGroupName, String vmName) {
        return (List)((ServiceResponse)this.listAvailableSizesWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<List<VirtualMachineSizeInner>> listAvailableSizesAsync(String resourceGroupName, String vmName, ServiceCallback<List<VirtualMachineSizeInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listAvailableSizesWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<List<VirtualMachineSizeInner>> listAvailableSizesAsync(String resourceGroupName, String vmName) {
        return this.listAvailableSizesWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<List<VirtualMachineSizeInner>>, List<VirtualMachineSizeInner>>(){

            public List<VirtualMachineSizeInner> call(ServiceResponse<List<VirtualMachineSizeInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<VirtualMachineSizeInner>>> listAvailableSizesWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.listAvailableSizes(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<VirtualMachineSizeInner>>>>(){

            public Observable<ServiceResponse<List<VirtualMachineSizeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachinesInner.this.listAvailableSizesDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualMachineSizeInner>> listAvailableSizesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualMachineSizeInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner powerOff(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.powerOffWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> powerOffAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.powerOffWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> powerOffAsync(String resourceGroupName, String vmName) {
        return this.powerOffWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> powerOffWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.powerOff(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginPowerOff(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginPowerOffWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginPowerOffAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPowerOffWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginPowerOffAsync(String resourceGroupName, String vmName) {
        return this.beginPowerOffWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginPowerOffWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginPowerOff(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginPowerOffDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginPowerOffDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner restart(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.restartWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> restartAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.restartWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> restartAsync(String resourceGroupName, String vmName) {
        return this.restartWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> restartWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.restart(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginRestart(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginRestartWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginRestartAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRestartWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginRestartAsync(String resourceGroupName, String vmName) {
        return this.beginRestartWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginRestartWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginRestart(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginRestartDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginRestartDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner start(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.startWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> startAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.startWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> startAsync(String resourceGroupName, String vmName) {
        return this.startWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> startWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.start(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginStart(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginStartWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginStartAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginStartWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginStartAsync(String resourceGroupName, String vmName) {
        return this.beginStartWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginStartWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginStart(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginStartDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginStartDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public OperationStatusResponseInner redeploy(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.redeployWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().last()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> redeployAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.redeployWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> redeployAsync(String resourceGroupName, String vmName) {
        return this.redeployWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> redeployWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        Observable<Response<ResponseBody>> observable = this.service.redeploy(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<OperationStatusResponseInner>(){}.getType());
    }

    public OperationStatusResponseInner beginRedeploy(String resourceGroupName, String vmName) {
        return (OperationStatusResponseInner)((ServiceResponse)this.beginRedeployWithServiceResponseAsync(resourceGroupName, vmName).toBlocking().single()).body();
    }

    public ServiceFuture<OperationStatusResponseInner> beginRedeployAsync(String resourceGroupName, String vmName, ServiceCallback<OperationStatusResponseInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginRedeployWithServiceResponseAsync(resourceGroupName, vmName), serviceCallback);
    }

    public Observable<OperationStatusResponseInner> beginRedeployAsync(String resourceGroupName, String vmName) {
        return this.beginRedeployWithServiceResponseAsync(resourceGroupName, vmName).map((Func1)new Func1<ServiceResponse<OperationStatusResponseInner>, OperationStatusResponseInner>(){

            public OperationStatusResponseInner call(ServiceResponse<OperationStatusResponseInner> response) {
                return (OperationStatusResponseInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<OperationStatusResponseInner>> beginRedeployWithServiceResponseAsync(String resourceGroupName, String vmName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vmName == null) {
            throw new IllegalArgumentException("Parameter vmName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2016-04-30-preview";
        return this.service.beginRedeploy(resourceGroupName, vmName, this.client.subscriptionId(), "2016-04-30-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<OperationStatusResponseInner>>>(){

            public Observable<ServiceResponse<OperationStatusResponseInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualMachinesInner.this.beginRedeployDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<OperationStatusResponseInner> beginRedeployDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<OperationStatusResponseInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualMachineInner>((Page)response.body()){

            public Page<VirtualMachineInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachinesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VirtualMachineInner>> serviceFuture, ListOperationCallback<VirtualMachineInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(String nextPageLink) {
                return VirtualMachinesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Page<VirtualMachineInner>>(){

            public Page<VirtualMachineInner> call(ServiceResponse<Page<VirtualMachineInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(ServiceResponse<Page<VirtualMachineInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachinesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachinesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VirtualMachineInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualMachineInner>((Page)response.body()){

            public Page<VirtualMachineInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualMachinesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualMachineInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualMachineInner>> serviceFuture, ListOperationCallback<VirtualMachineInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(String nextPageLink) {
                return VirtualMachinesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualMachineInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Page<VirtualMachineInner>>(){

            public Page<VirtualMachineInner> call(ServiceResponse<Page<VirtualMachineInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualMachineInner>>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(ServiceResponse<Page<VirtualMachineInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualMachinesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualMachineInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualMachineInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualMachineInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualMachinesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<VirtualMachineInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<VirtualMachineInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VirtualMachinesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines capture"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/capture")
        public Observable<Response<ResponseBody>> capture(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualMachineCaptureParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginCapture"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/capture")
        public Observable<Response<ResponseBody>> beginCapture(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualMachineCaptureParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualMachineInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Body VirtualMachineInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="$expand") InstanceViewTypes var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines convertToManagedDisks"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/convertToManagedDisks")
        public Observable<Response<ResponseBody>> convertToManagedDisks(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginConvertToManagedDisks"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/convertToManagedDisks")
        public Observable<Response<ResponseBody>> beginConvertToManagedDisks(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines deallocate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/deallocate")
        public Observable<Response<ResponseBody>> deallocate(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginDeallocate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/deallocate")
        public Observable<Response<ResponseBody>> beginDeallocate(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines generalize"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/generalize")
        public Observable<Response<ResponseBody>> generalize(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Compute/virtualMachines")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines listAvailableSizes"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/vmSizes")
        public Observable<Response<ResponseBody>> listAvailableSizes(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines powerOff"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/powerOff")
        public Observable<Response<ResponseBody>> powerOff(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginPowerOff"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/powerOff")
        public Observable<Response<ResponseBody>> beginPowerOff(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines restart"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/restart")
        public Observable<Response<ResponseBody>> restart(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginRestart"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/restart")
        public Observable<Response<ResponseBody>> beginRestart(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines start"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/start")
        public Observable<Response<ResponseBody>> start(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginStart"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/start")
        public Observable<Response<ResponseBody>> beginStart(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines redeploy"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/redeploy")
        public Observable<Response<ResponseBody>> redeploy(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines beginRedeploy"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/redeploy")
        public Observable<Response<ResponseBody>> beginRedeploy(@Path(value="resourceGroupName") String var1, @Path(value="vmName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.VirtualMachines listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

