/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.compute.AvailabilitySetSkuTypes;
import com.microsoft.azure.management.compute.InstanceViewStatus;
import com.microsoft.azure.management.compute.ProximityPlacementGroup;
import com.microsoft.azure.management.compute.ProximityPlacementGroupType;
import com.microsoft.azure.management.compute.VirtualMachineSize;
import com.microsoft.azure.management.compute.implementation.AvailabilitySetInner;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Set;

@Fluent
public interface AvailabilitySet
extends GroupableResource<ComputeManager, AvailabilitySetInner>,
Refreshable<AvailabilitySet>,
Updatable<Update> {
    public int updateDomainCount();

    public int faultDomainCount();

    public AvailabilitySetSkuTypes sku();

    public Set<String> virtualMachineIds();

    public ProximityPlacementGroup proximityPlacementGroup();

    public List<InstanceViewStatus> statuses();

    public PagedList<VirtualMachineSize> listVirtualMachineSizes();

    public static interface Update
    extends Appliable<AvailabilitySet>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithProximityPlacementGroup {
    }

    public static interface UpdateStages {

        public static interface WithProximityPlacementGroup {
            public Update withProximityPlacementGroup(String var1);

            public Update withoutProximityPlacementGroup();
        }

        public static interface WithSku {
            public Update withSku(AvailabilitySetSkuTypes var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<AvailabilitySet>,
        Resource.DefinitionWithTags<WithCreate>,
        WithUpdateDomainCount,
        WithFaultDomainCount,
        WithSku,
        WithProximityPlacementGroup {
        }

        public static interface WithProximityPlacementGroup {
            public WithCreate withProximityPlacementGroup(String var1);

            public WithCreate withNewProximityPlacementGroup(String var1, ProximityPlacementGroupType var2);
        }

        public static interface WithSku {
            public WithCreate withSku(AvailabilitySetSkuTypes var1);
        }

        public static interface WithFaultDomainCount {
            public WithCreate withFaultDomainCount(int var1);
        }

        public static interface WithUpdateDomainCount {
            public WithCreate withUpdateDomainCount(int var1);
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithCreate {
    }
}

