/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.compute.GalleryImageVersionUpdate;
import com.microsoft.azure.management.compute.ReplicationStatusTypes;
import com.microsoft.azure.management.compute.implementation.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.implementation.GalleryImageVersionInner;
import com.microsoft.azure.management.compute.implementation.PageImpl1;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class GalleryImageVersionsInner {
    private GalleryImageVersionsService service;
    private ComputeManagementClientImpl client;

    public GalleryImageVersionsInner(Retrofit retrofit, ComputeManagementClientImpl client) {
        this.service = (GalleryImageVersionsService)retrofit.create(GalleryImageVersionsService.class);
        this.client = client;
    }

    public GalleryImageVersionInner createOrUpdate(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return (GalleryImageVersionInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).toBlocking().last()).body());
    }

    public ServiceFuture<GalleryImageVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion, ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion), serviceCallback);
    }

    public Observable<GalleryImageVersionInner> createOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).map((Func1)new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>(){

            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return (GalleryImageVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageVersionInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        if (galleryImageVersion == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryImageVersion));
        String apiVersion = "2019-07-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, "2019-07-01", galleryImageVersion, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryImageVersionInner>(){}.getType());
    }

    public GalleryImageVersionInner beginCreateOrUpdate(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return (GalleryImageVersionInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryImageVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion, ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion), serviceCallback);
    }

    public Observable<GalleryImageVersionInner> beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).map((Func1)new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>(){

            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return (GalleryImageVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageVersionInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionInner galleryImageVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        if (galleryImageVersion == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryImageVersion));
        String apiVersion = "2019-07-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, "2019-07-01", galleryImageVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageVersionInner>>>(){

            public Observable<ServiceResponse<GalleryImageVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImageVersionsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryImageVersionInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryImageVersionInner>(){}.getType()).register(201, new TypeToken<GalleryImageVersionInner>(){}.getType()).register(202, new TypeToken<GalleryImageVersionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GalleryImageVersionInner update(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        return (GalleryImageVersionInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).toBlocking().last()).body());
    }

    public ServiceFuture<GalleryImageVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion, ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion), serviceCallback);
    }

    public Observable<GalleryImageVersionInner> updateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        return this.updateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).map((Func1)new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>(){

            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return (GalleryImageVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageVersionInner>> updateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        if (galleryImageVersion == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryImageVersion));
        String apiVersion = "2019-07-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, "2019-07-01", galleryImageVersion, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<GalleryImageVersionInner>(){}.getType());
    }

    public GalleryImageVersionInner beginUpdate(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        return (GalleryImageVersionInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryImageVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion, ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion), serviceCallback);
    }

    public Observable<GalleryImageVersionInner> beginUpdateAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, galleryImageVersion).map((Func1)new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>(){

            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return (GalleryImageVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageVersionInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, GalleryImageVersionUpdate galleryImageVersion) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        if (galleryImageVersion == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersion is required and cannot be null.");
        }
        Validator.validate((Object)((Object)galleryImageVersion));
        String apiVersion = "2019-07-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, "2019-07-01", galleryImageVersion, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageVersionInner>>>(){

            public Observable<ServiceResponse<GalleryImageVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImageVersionsInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryImageVersionInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryImageVersionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public GalleryImageVersionInner get(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return (GalleryImageVersionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName), serviceCallback);
    }

    public Observable<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).map((Func1)new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>(){

            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return (GalleryImageVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        ReplicationStatusTypes expand = null;
        return this.service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageVersionInner>>>(){

            public Observable<ServiceResponse<GalleryImageVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImageVersionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public GalleryImageVersionInner get(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand) {
        return (GalleryImageVersionInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand, ServiceCallback<GalleryImageVersionInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand), serviceCallback);
    }

    public Observable<GalleryImageVersionInner> getAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand).map((Func1)new Func1<ServiceResponse<GalleryImageVersionInner>, GalleryImageVersionInner>(){

            public GalleryImageVersionInner call(ServiceResponse<GalleryImageVersionInner> response) {
                return (GalleryImageVersionInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<GalleryImageVersionInner>> getWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ReplicationStatusTypes expand) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, expand, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<GalleryImageVersionInner>>>(){

            public Observable<ServiceResponse<GalleryImageVersionInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImageVersionsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<GalleryImageVersionInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<GalleryImageVersionInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName, galleryImageVersionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName, String galleryImageVersionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        if (galleryImageVersionName == null) {
            throw new IllegalArgumentException("Parameter galleryImageVersionName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, galleryImageVersionName, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = GalleryImageVersionsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryImageVersionInner> listByGalleryImage(String resourceGroupName, String galleryName, String galleryImageName) {
        ServiceResponse response = (ServiceResponse)this.listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName).toBlocking().single();
        return new PagedList<GalleryImageVersionInner>((Page)response.body()){

            public Page<GalleryImageVersionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryImageVersionsInner.this.listByGalleryImageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryImageVersionInner>> listByGalleryImageAsync(String resourceGroupName, String galleryName, String galleryImageName, ListOperationCallback<GalleryImageVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(String nextPageLink) {
                return GalleryImageVersionsInner.this.listByGalleryImageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryImageVersionInner>> listByGalleryImageAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        return this.listByGalleryImageWithServiceResponseAsync(resourceGroupName, galleryName, galleryImageName).map((Func1)new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Page<GalleryImageVersionInner>>(){

            public Page<GalleryImageVersionInner> call(ServiceResponse<Page<GalleryImageVersionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageWithServiceResponseAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        return this.listByGalleryImageSinglePageAsync(resourceGroupName, galleryName, galleryImageName).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(ServiceResponse<Page<GalleryImageVersionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryImageVersionsInner.this.listByGalleryImageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageSinglePageAsync(String resourceGroupName, String galleryName, String galleryImageName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (galleryName == null) {
            throw new IllegalArgumentException("Parameter galleryName is required and cannot be null.");
        }
        if (galleryImageName == null) {
            throw new IllegalArgumentException("Parameter galleryImageName is required and cannot be null.");
        }
        String apiVersion = "2019-07-01";
        return this.service.listByGalleryImage(this.client.subscriptionId(), resourceGroupName, galleryName, galleryImageName, "2019-07-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryImageVersionsInner.this.listByGalleryImageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryImageVersionInner>> listByGalleryImageDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryImageVersionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<GalleryImageVersionInner> listByGalleryImageNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByGalleryImageNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<GalleryImageVersionInner>((Page)response.body()){

            public Page<GalleryImageVersionInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)GalleryImageVersionsInner.this.listByGalleryImageNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<GalleryImageVersionInner>> listByGalleryImageNextAsync(String nextPageLink, ServiceFuture<List<GalleryImageVersionInner>> serviceFuture, ListOperationCallback<GalleryImageVersionInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByGalleryImageNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(String nextPageLink) {
                return GalleryImageVersionsInner.this.listByGalleryImageNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<GalleryImageVersionInner>> listByGalleryImageNextAsync(String nextPageLink) {
        return this.listByGalleryImageNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Page<GalleryImageVersionInner>>(){

            public Page<GalleryImageVersionInner> call(ServiceResponse<Page<GalleryImageVersionInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByGalleryImageNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<GalleryImageVersionInner>>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(ServiceResponse<Page<GalleryImageVersionInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(GalleryImageVersionsInner.this.listByGalleryImageNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> listByGalleryImageNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByGalleryImageNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<GalleryImageVersionInner>>>>(){

            public Observable<ServiceResponse<Page<GalleryImageVersionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = GalleryImageVersionsInner.this.listByGalleryImageNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<GalleryImageVersionInner>> listByGalleryImageNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<GalleryImageVersionInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface GalleryImageVersionsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Path(value="galleryImageVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryImageVersionInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Path(value="galleryImageVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryImageVersionInner var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Path(value="galleryImageVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryImageVersionUpdate var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Path(value="galleryImageVersionName") String var5, @Query(value="api-version") String var6, @Body GalleryImageVersionUpdate var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Path(value="galleryImageVersionName") String var5, @Query(value="$expand") ReplicationStatusTypes var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Path(value="galleryImageVersionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Path(value="galleryImageVersionName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions listByGalleryImage"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions")
        public Observable<Response<ResponseBody>> listByGalleryImage(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="galleryName") String var3, @Path(value="galleryImageName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.compute.GalleryImageVersions listByGalleryImageNext"})
        @GET
        public Observable<Response<ResponseBody>> listByGalleryImageNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

