/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerinstance.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.containerinstance.implementation.CachedImagesListResultInner;
import com.microsoft.azure.management.containerinstance.implementation.CapabilitiesListResultInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupUsagesInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainerGroupsInner;
import com.microsoft.azure.management.containerinstance.implementation.ContainersInner;
import com.microsoft.azure.management.containerinstance.implementation.OperationsInner;
import com.microsoft.azure.management.containerinstance.implementation.ServiceAssociationLinksInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ContainerInstanceManagementClientImpl
extends AzureServiceClient {
    private ContainerInstanceManagementClientService service;
    private AzureClient azureClient;
    private String subscriptionId;
    private String apiVersion;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ContainerGroupsInner containerGroups;
    private OperationsInner operations;
    private ContainerGroupUsagesInner containerGroupUsages;
    private ContainersInner containers;
    private ServiceAssociationLinksInner serviceAssociationLinks;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ContainerInstanceManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String apiVersion() {
        return this.apiVersion;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ContainerInstanceManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ContainerInstanceManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ContainerInstanceManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ContainerGroupsInner containerGroups() {
        return this.containerGroups;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public ContainerGroupUsagesInner containerGroupUsages() {
        return this.containerGroupUsages;
    }

    public ContainersInner containers() {
        return this.containers;
    }

    public ServiceAssociationLinksInner serviceAssociationLinks() {
        return this.serviceAssociationLinks;
    }

    public ContainerInstanceManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ContainerInstanceManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ContainerInstanceManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.apiVersion = "2018-10-01";
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.containerGroups = new ContainerGroupsInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.containerGroupUsages = new ContainerGroupUsagesInner(this.restClient().retrofit(), this);
        this.containers = new ContainersInner(this.restClient().retrofit(), this);
        this.serviceAssociationLinks = new ServiceAssociationLinksInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
        this.initializeService();
    }

    public String userAgent() {
        return String.format("%s (%s, %s)", super.userAgent(), "ContainerInstanceManagementClient", "2018-10-01");
    }

    private void initializeService() {
        this.service = (ContainerInstanceManagementClientService)this.restClient().retrofit().create(ContainerInstanceManagementClientService.class);
    }

    public CachedImagesListResultInner listCachedImages(String location) {
        return (CachedImagesListResultInner)((ServiceResponse)this.listCachedImagesWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<CachedImagesListResultInner> listCachedImagesAsync(String location, ServiceCallback<CachedImagesListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCachedImagesWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<CachedImagesListResultInner> listCachedImagesAsync(String location) {
        return this.listCachedImagesWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<CachedImagesListResultInner>, CachedImagesListResultInner>(){

            public CachedImagesListResultInner call(ServiceResponse<CachedImagesListResultInner> response) {
                return (CachedImagesListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CachedImagesListResultInner>> listCachedImagesWithServiceResponseAsync(String location) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listCachedImages(this.subscriptionId(), location, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CachedImagesListResultInner>>>(){

            public Observable<ServiceResponse<CachedImagesListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerInstanceManagementClientImpl.this.listCachedImagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CachedImagesListResultInner> listCachedImagesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CachedImagesListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CapabilitiesListResultInner listCapabilities(String location) {
        return (CapabilitiesListResultInner)((ServiceResponse)this.listCapabilitiesWithServiceResponseAsync(location).toBlocking().single()).body();
    }

    public ServiceFuture<CapabilitiesListResultInner> listCapabilitiesAsync(String location, ServiceCallback<CapabilitiesListResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCapabilitiesWithServiceResponseAsync(location), serviceCallback);
    }

    public Observable<CapabilitiesListResultInner> listCapabilitiesAsync(String location) {
        return this.listCapabilitiesWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<CapabilitiesListResultInner>, CapabilitiesListResultInner>(){

            public CapabilitiesListResultInner call(ServiceResponse<CapabilitiesListResultInner> response) {
                return (CapabilitiesListResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<CapabilitiesListResultInner>> listCapabilitiesWithServiceResponseAsync(String location) {
        if (this.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.subscriptionId() is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.apiVersion() is required and cannot be null.");
        }
        return this.service.listCapabilities(this.subscriptionId(), location, this.apiVersion(), this.acceptLanguage(), this.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CapabilitiesListResultInner>>>(){

            public Observable<ServiceResponse<CapabilitiesListResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ContainerInstanceManagementClientImpl.this.listCapabilitiesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CapabilitiesListResultInner> listCapabilitiesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.restClient().responseBuilderFactory().newInstance(this.serializerAdapter()).register(200, new TypeToken<CapabilitiesListResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ContainerInstanceManagementClientService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerInstanceManagementClient listCachedImages"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/cachedImages")
        public Observable<Response<ResponseBody>> listCachedImages(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerinstance.ContainerInstanceManagementClient listCapabilities"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerInstance/locations/{location}/capabilities")
        public Observable<Response<ResponseBody>> listCapabilities(@Path(value="subscriptionId") String var1, @Path(value="location") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);
    }
}

