/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.containerregistry.PasswordName;
import com.microsoft.azure.management.containerregistry.Sku;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerregistry.implementation.RegistryInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryListCredentials;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.storage.StorageAccount;
import org.joda.time.DateTime;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_1_0)
public interface Registry
extends GroupableResource<ContainerRegistryManager, RegistryInner>,
Refreshable<Registry>,
Updatable<Update> {
    public Sku sku();

    public String loginServerUrl();

    public DateTime creationDate();

    public boolean adminUserEnabled();

    public String storageAccountName();

    public RegistryListCredentials listCredentials();

    public Observable<RegistryListCredentials> listCredentialsAsync();

    public RegistryListCredentials regenerateCredential(PasswordName var1);

    public Observable<RegistryListCredentials> regenerateCredentialAsync(PasswordName var1);

    public static interface UpdateStages {

        public static interface WithAdminUserEnabled {
            public Update withRegistryNameAsAdminUser();

            public Update withoutRegistryNameAsAdminUser();
        }
    }

    public static interface Update
    extends Resource.UpdateWithTags<Update>,
    Appliable<Registry>,
    UpdateStages.WithAdminUserEnabled {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Registry>,
        Resource.DefinitionWithTags<WithCreate>,
        WithAdminUserEnabled {
        }

        public static interface WithStorageAccount {
            public WithCreate withExistingStorageAccount(StorageAccount var1);

            public WithCreate withNewStorageAccount(String var1);

            public WithCreate withNewStorageAccount(Creatable<StorageAccount> var1);
        }

        public static interface WithAdminUserEnabled {
            public WithCreate withRegistryNameAsAdminUser();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithStorageAccount> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithStorageAccount,
    DefinitionStages.WithCreate {
    }
}

