/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.PasswordName;
import com.microsoft.azure.management.containerregistry.RegenerateCredentialParameters;
import com.microsoft.azure.management.containerregistry.RegistryNameCheckRequest;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.azure.management.containerregistry.implementation.RegistryCreateParametersInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryListCredentials;
import com.microsoft.azure.management.containerregistry.implementation.RegistryNameStatusInner;
import com.microsoft.azure.management.containerregistry.implementation.RegistryUpdateParametersInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class RegistriesInner
implements InnerSupportsGet<RegistryInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<RegistryInner> {
    private RegistriesService service;
    private ContainerRegistryManagementClientImpl client;

    public RegistriesInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (RegistriesService)retrofit.create(RegistriesService.class);
        this.client = client;
    }

    public RegistryNameStatusInner checkNameAvailability(String name) {
        return (RegistryNameStatusInner)((ServiceResponse)this.checkNameAvailabilityWithServiceResponseAsync(name).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryNameStatusInner> checkNameAvailabilityAsync(String name, ServiceCallback<RegistryNameStatusInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkNameAvailabilityWithServiceResponseAsync(name), serviceCallback);
    }

    public Observable<RegistryNameStatusInner> checkNameAvailabilityAsync(String name) {
        return this.checkNameAvailabilityWithServiceResponseAsync(name).map((Func1)new Func1<ServiceResponse<RegistryNameStatusInner>, RegistryNameStatusInner>(){

            public RegistryNameStatusInner call(ServiceResponse<RegistryNameStatusInner> response) {
                return (RegistryNameStatusInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryNameStatusInner>> checkNameAvailabilityWithServiceResponseAsync(String name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        RegistryNameCheckRequest registryNameCheckRequest = new RegistryNameCheckRequest();
        registryNameCheckRequest.withName(name);
        return this.service.checkNameAvailability(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), registryNameCheckRequest, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryNameStatusInner>>>(){

            public Observable<ServiceResponse<RegistryNameStatusInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.checkNameAvailabilityDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryNameStatusInner> checkNameAvailabilityDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryNameStatusInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryInner getByResourceGroup(String resourceGroupName, String registryName) {
        return (RegistryInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body());
    }

    public ServiceFuture<RegistryInner> getByResourceGroupAsync(String resourceGroupName, String registryName, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<RegistryInner> getByResourceGroupAsync(String resourceGroupName, String registryName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>(){

            public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryInner create(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters) {
        return (RegistryInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, registryCreateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<RegistryInner> createAsync(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, registryCreateParameters), serviceCallback);
    }

    public Observable<RegistryInner> createAsync(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, registryCreateParameters).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (registryCreateParameters == null) {
            throw new IllegalArgumentException("Parameter registryCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)registryCreateParameters);
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), registryCreateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<RegistryInner>(){}.getType());
    }

    public RegistryInner beginCreate(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters) {
        return (RegistryInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registryCreateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<RegistryInner> beginCreateAsync(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registryCreateParameters), serviceCallback);
    }

    public Observable<RegistryInner> beginCreateAsync(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, registryCreateParameters).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryCreateParametersInner registryCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (registryCreateParameters == null) {
            throw new IllegalArgumentException("Parameter registryCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)registryCreateParameters);
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), registryCreateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>(){

            public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String registryName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String registryName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryInner update(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        return (RegistryInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<RegistryInner> updateAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters, ServiceCallback<RegistryInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters), serviceCallback);
    }

    public Observable<RegistryInner> updateAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, registryUpdateParameters).map((Func1)new Func1<ServiceResponse<RegistryInner>, RegistryInner>(){

            public RegistryInner call(ServiceResponse<RegistryInner> response) {
                return (RegistryInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<RegistryInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, RegistryUpdateParametersInner registryUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (registryUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter registryUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)registryUpdateParameters);
        return this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), registryUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryInner>>>(){

            public Observable<ServiceResponse<RegistryInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listAsync(ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryListCredentials listCredentials(String resourceGroupName, String registryName) {
        return (RegistryListCredentials)((ServiceResponse)this.listCredentialsWithServiceResponseAsync(resourceGroupName, registryName).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryListCredentials> listCredentialsAsync(String resourceGroupName, String registryName, ServiceCallback<RegistryListCredentials> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCredentialsWithServiceResponseAsync(resourceGroupName, registryName), serviceCallback);
    }

    public Observable<RegistryListCredentials> listCredentialsAsync(String resourceGroupName, String registryName) {
        return this.listCredentialsWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<RegistryListCredentials>, RegistryListCredentials>(){

            public RegistryListCredentials call(ServiceResponse<RegistryListCredentials> response) {
                return (RegistryListCredentials)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryListCredentials>> listCredentialsWithServiceResponseAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCredentials(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryListCredentials>>>(){

            public Observable<ServiceResponse<RegistryListCredentials>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.listCredentialsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryListCredentials> listCredentialsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryListCredentials>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public RegistryListCredentials regenerateCredential(String resourceGroupName, String registryName, PasswordName name) {
        return (RegistryListCredentials)((ServiceResponse)this.regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name).toBlocking().single()).body();
    }

    public ServiceFuture<RegistryListCredentials> regenerateCredentialAsync(String resourceGroupName, String registryName, PasswordName name, ServiceCallback<RegistryListCredentials> serviceCallback) {
        return ServiceFuture.fromResponse(this.regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name), serviceCallback);
    }

    public Observable<RegistryListCredentials> regenerateCredentialAsync(String resourceGroupName, String registryName, PasswordName name) {
        return this.regenerateCredentialWithServiceResponseAsync(resourceGroupName, registryName, name).map((Func1)new Func1<ServiceResponse<RegistryListCredentials>, RegistryListCredentials>(){

            public RegistryListCredentials call(ServiceResponse<RegistryListCredentials> response) {
                return (RegistryListCredentials)response.body();
            }
        });
    }

    public Observable<ServiceResponse<RegistryListCredentials>> regenerateCredentialWithServiceResponseAsync(String resourceGroupName, String registryName, PasswordName name) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        RegenerateCredentialParameters regenerateCredentialParameters = new RegenerateCredentialParameters();
        regenerateCredentialParameters.withName(name);
        return this.service.regenerateCredential(this.client.subscriptionId(), resourceGroupName, registryName, this.client.apiVersion(), this.client.acceptLanguage(), regenerateCredentialParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<RegistryListCredentials>>>(){

            public Observable<ServiceResponse<RegistryListCredentials>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = RegistriesInner.this.regenerateCredentialDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<RegistryListCredentials> regenerateCredentialDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<RegistryListCredentials>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<RegistryInner>> serviceFuture, ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RegistryInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RegistryInner>((Page)response.body()){

            public Page<RegistryInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)RegistriesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RegistryInner>> listNextAsync(String nextPageLink, ServiceFuture<List<RegistryInner>> serviceFuture, ListOperationCallback<RegistryInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(String nextPageLink) {
                return RegistriesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RegistryInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Page<RegistryInner>>(){

            public Page<RegistryInner> call(ServiceResponse<Page<RegistryInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RegistryInner>>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(ServiceResponse<Page<RegistryInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(RegistriesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RegistryInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RegistryInner>>>>(){

            public Observable<ServiceResponse<Page<RegistryInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = RegistriesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RegistryInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RegistryInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface RegistriesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries checkNameAvailability"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/checkNameAvailability")
        public Observable<Response<ResponseBody>> checkNameAvailability(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Body RegistryNameCheckRequest var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryCreateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryCreateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Body RegistryUpdateParametersInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.ContainerRegistry/registries")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listCredentials"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/listCredentials")
        public Observable<Response<ResponseBody>> listCredentials(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries regenerateCredential"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/regenerateCredential")
        public Observable<Response<ResponseBody>> regenerateCredential(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body RegenerateCredentialParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Registries listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

