/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerregistry.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerregistry.TaskUpdateParameters;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManagementClientImpl;
import com.microsoft.azure.management.containerregistry.implementation.PageImpl;
import com.microsoft.azure.management.containerregistry.implementation.TaskInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class TasksInner {
    private TasksService service;
    private ContainerRegistryManagementClientImpl client;

    public TasksInner(Retrofit retrofit, ContainerRegistryManagementClientImpl client) {
        this.service = (TasksService)retrofit.create(TasksService.class);
        this.client = client;
    }

    public PagedList<TaskInner> list(String resourceGroupName, String registryName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, registryName).toBlocking().single();
        return new PagedList<TaskInner>((Page)response.body()){

            public Page<TaskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TasksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TaskInner>> listAsync(String resourceGroupName, String registryName, ListOperationCallback<TaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, registryName), (Func1)new Func1<String, Observable<ServiceResponse<Page<TaskInner>>>>(){

            public Observable<ServiceResponse<Page<TaskInner>>> call(String nextPageLink) {
                return TasksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TaskInner>> listAsync(String resourceGroupName, String registryName) {
        return this.listWithServiceResponseAsync(resourceGroupName, registryName).map((Func1)new Func1<ServiceResponse<Page<TaskInner>>, Page<TaskInner>>(){

            public Page<TaskInner> call(ServiceResponse<Page<TaskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TaskInner>>> listWithServiceResponseAsync(String resourceGroupName, String registryName) {
        return this.listSinglePageAsync(resourceGroupName, registryName).concatMap((Func1)new Func1<ServiceResponse<Page<TaskInner>>, Observable<ServiceResponse<Page<TaskInner>>>>(){

            public Observable<ServiceResponse<Page<TaskInner>>> call(ServiceResponse<Page<TaskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TasksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TaskInner>>> listSinglePageAsync(String resourceGroupName, String registryName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, registryName, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TaskInner>>>>(){

            public Observable<ServiceResponse<Page<TaskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TasksInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TaskInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TaskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TaskInner get(String resourceGroupName, String registryName, String taskName) {
        return (TaskInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().single()).body());
    }

    public ServiceFuture<TaskInner> getAsync(String resourceGroupName, String registryName, String taskName, ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    public Observable<TaskInner> getAsync(String resourceGroupName, String registryName, String taskName) {
        return this.getWithServiceResponseAsync(resourceGroupName, registryName, taskName).map((Func1)new Func1<ServiceResponse<TaskInner>, TaskInner>(){

            public TaskInner call(ServiceResponse<TaskInner> response) {
                return (TaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TaskInner>> getWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>(){

            public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TasksInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TaskInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TaskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TaskInner create(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return (TaskInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<TaskInner> createAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters, ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters), serviceCallback);
    }

    public Observable<TaskInner> createAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).map((Func1)new Func1<ServiceResponse<TaskInner>, TaskInner>(){

            public TaskInner call(ServiceResponse<TaskInner> response) {
                return (TaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TaskInner>> createWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter taskCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)taskCreateParameters));
        String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = this.service.create(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", taskCreateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TaskInner>(){}.getType());
    }

    public TaskInner beginCreate(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return (TaskInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<TaskInner> beginCreateAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters, ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters), serviceCallback);
    }

    public Observable<TaskInner> beginCreateAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskCreateParameters).map((Func1)new Func1<ServiceResponse<TaskInner>, TaskInner>(){

            public TaskInner call(ServiceResponse<TaskInner> response) {
                return (TaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TaskInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskInner taskCreateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskCreateParameters == null) {
            throw new IllegalArgumentException("Parameter taskCreateParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)taskCreateParameters));
        String apiVersion = "2018-09-01";
        return this.service.beginCreate(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", taskCreateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>(){

            public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TasksInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TaskInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TaskInner>(){}.getType()).register(201, new TypeToken<TaskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String registryName, String taskName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String registryName, String taskName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String registryName, String taskName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String registryName, String taskName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String registryName, String taskName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String registryName, String taskName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, registryName, taskName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TasksInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TaskInner update(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return (TaskInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).toBlocking().last()).body());
    }

    public ServiceFuture<TaskInner> updateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters, ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters), serviceCallback);
    }

    public Observable<TaskInner> updateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).map((Func1)new Func1<ServiceResponse<TaskInner>, TaskInner>(){

            public TaskInner call(ServiceResponse<TaskInner> response) {
                return (TaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TaskInner>> updateWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter taskUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)taskUpdateParameters);
        String apiVersion = "2018-09-01";
        Observable<Response<ResponseBody>> observable = this.service.update(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", taskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<TaskInner>(){}.getType());
    }

    public TaskInner beginUpdate(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return (TaskInner)((Object)((ServiceResponse)this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).toBlocking().single()).body());
    }

    public ServiceFuture<TaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters, ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters), serviceCallback);
    }

    public Observable<TaskInner> beginUpdateAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        return this.beginUpdateWithServiceResponseAsync(resourceGroupName, registryName, taskName, taskUpdateParameters).map((Func1)new Func1<ServiceResponse<TaskInner>, TaskInner>(){

            public TaskInner call(ServiceResponse<TaskInner> response) {
                return (TaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TaskInner>> beginUpdateWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName, TaskUpdateParameters taskUpdateParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        if (taskUpdateParameters == null) {
            throw new IllegalArgumentException("Parameter taskUpdateParameters is required and cannot be null.");
        }
        Validator.validate((Object)taskUpdateParameters);
        String apiVersion = "2018-09-01";
        return this.service.beginUpdate(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", taskUpdateParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>(){

            public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TasksInner.this.beginUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TaskInner> beginUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TaskInner>(){}.getType()).register(201, new TypeToken<TaskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public TaskInner getDetails(String resourceGroupName, String registryName, String taskName) {
        return (TaskInner)((Object)((ServiceResponse)this.getDetailsWithServiceResponseAsync(resourceGroupName, registryName, taskName).toBlocking().single()).body());
    }

    public ServiceFuture<TaskInner> getDetailsAsync(String resourceGroupName, String registryName, String taskName, ServiceCallback<TaskInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDetailsWithServiceResponseAsync(resourceGroupName, registryName, taskName), serviceCallback);
    }

    public Observable<TaskInner> getDetailsAsync(String resourceGroupName, String registryName, String taskName) {
        return this.getDetailsWithServiceResponseAsync(resourceGroupName, registryName, taskName).map((Func1)new Func1<ServiceResponse<TaskInner>, TaskInner>(){

            public TaskInner call(ServiceResponse<TaskInner> response) {
                return (TaskInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<TaskInner>> getDetailsWithServiceResponseAsync(String resourceGroupName, String registryName, String taskName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (registryName == null) {
            throw new IllegalArgumentException("Parameter registryName is required and cannot be null.");
        }
        if (taskName == null) {
            throw new IllegalArgumentException("Parameter taskName is required and cannot be null.");
        }
        String apiVersion = "2018-09-01";
        return this.service.getDetails(this.client.subscriptionId(), resourceGroupName, registryName, taskName, "2018-09-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<TaskInner>>>(){

            public Observable<ServiceResponse<TaskInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TasksInner.this.getDetailsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<TaskInner> getDetailsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<TaskInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<TaskInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<TaskInner>((Page)response.body()){

            public Page<TaskInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)TasksInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<TaskInner>> listNextAsync(String nextPageLink, ServiceFuture<List<TaskInner>> serviceFuture, ListOperationCallback<TaskInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<TaskInner>>>>(){

            public Observable<ServiceResponse<Page<TaskInner>>> call(String nextPageLink) {
                return TasksInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<TaskInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<TaskInner>>, Page<TaskInner>>(){

            public Page<TaskInner> call(ServiceResponse<Page<TaskInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<TaskInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<TaskInner>>, Observable<ServiceResponse<Page<TaskInner>>>>(){

            public Observable<ServiceResponse<Page<TaskInner>>> call(ServiceResponse<Page<TaskInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(TasksInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<TaskInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<TaskInner>>>>(){

            public Observable<ServiceResponse<Page<TaskInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = TasksInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<TaskInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<TaskInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TasksService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        public Observable<Response<ResponseBody>> create(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Body TaskInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Body TaskInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        public Observable<Response<ResponseBody>> update(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Body TaskUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks beginUpdate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}")
        public Observable<Response<ResponseBody>> beginUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Body TaskUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks getDetails"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerRegistry/registries/{registryName}/tasks/{taskName}/listDetails")
        public Observable<Response<ResponseBody>> getDetails(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="registryName") String var3, @Path(value="taskName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerregistry.Tasks listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

