/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.containerservice.implementation.AgentPoolAvailableVersionsInner;
import com.microsoft.azure.management.containerservice.implementation.AgentPoolInner;
import com.microsoft.azure.management.containerservice.implementation.AgentPoolUpgradeProfileInner;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManagementClientImpl;
import com.microsoft.azure.management.containerservice.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AgentPoolsInner {
    private AgentPoolsService service;
    private ContainerServiceManagementClientImpl client;

    public AgentPoolsInner(Retrofit retrofit, ContainerServiceManagementClientImpl client) {
        this.service = (AgentPoolsService)retrofit.create(AgentPoolsService.class);
        this.client = client;
    }

    public PagedList<AgentPoolInner> list(String resourceGroupName, String resourceName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, resourceName).toBlocking().single();
        return new PagedList<AgentPoolInner>((Page)response.body()){

            public Page<AgentPoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AgentPoolsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AgentPoolInner>> listAsync(String resourceGroupName, String resourceName, ListOperationCallback<AgentPoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, resourceName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AgentPoolInner>>>>(){

            public Observable<ServiceResponse<Page<AgentPoolInner>>> call(String nextPageLink) {
                return AgentPoolsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AgentPoolInner>> listAsync(String resourceGroupName, String resourceName) {
        return this.listWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<Page<AgentPoolInner>>, Page<AgentPoolInner>>(){

            public Page<AgentPoolInner> call(ServiceResponse<Page<AgentPoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AgentPoolInner>>> listWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        return this.listSinglePageAsync(resourceGroupName, resourceName).concatMap((Func1)new Func1<ServiceResponse<Page<AgentPoolInner>>, Observable<ServiceResponse<Page<AgentPoolInner>>>>(){

            public Observable<ServiceResponse<Page<AgentPoolInner>>> call(ServiceResponse<Page<AgentPoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AgentPoolsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AgentPoolInner>>> listSinglePageAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-03-01";
        return this.service.list(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AgentPoolInner>>>>(){

            public Observable<ServiceResponse<Page<AgentPoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AgentPoolsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AgentPoolInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AgentPoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AgentPoolInner get(String resourceGroupName, String resourceName, String agentPoolName) {
        return (AgentPoolInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().single()).body());
    }

    public ServiceFuture<AgentPoolInner> getAsync(String resourceGroupName, String resourceName, String agentPoolName, ServiceCallback<AgentPoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    public Observable<AgentPoolInner> getAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return this.getWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map((Func1)new Func1<ServiceResponse<AgentPoolInner>, AgentPoolInner>(){

            public AgentPoolInner call(ServiceResponse<AgentPoolInner> response) {
                return (AgentPoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AgentPoolInner>> getWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        String apiVersion = "2020-03-01";
        return this.service.get(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, "2020-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolInner>>>(){

            public Observable<ServiceResponse<AgentPoolInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AgentPoolsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AgentPoolInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AgentPoolInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AgentPoolInner createOrUpdate(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return (AgentPoolInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters, ServiceCallback<AgentPoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters), serviceCallback);
    }

    public Observable<AgentPoolInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).map((Func1)new Func1<ServiceResponse<AgentPoolInner>, AgentPoolInner>(){

            public AgentPoolInner call(ServiceResponse<AgentPoolInner> response) {
                return (AgentPoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AgentPoolInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2020-03-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, "2020-03-01", parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AgentPoolInner>(){}.getType());
    }

    public AgentPoolInner beginCreateOrUpdate(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return (AgentPoolInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters, ServiceCallback<AgentPoolInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters), serviceCallback);
    }

    public Observable<AgentPoolInner> beginCreateOrUpdateAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName, parameters).map((Func1)new Func1<ServiceResponse<AgentPoolInner>, AgentPoolInner>(){

            public AgentPoolInner call(ServiceResponse<AgentPoolInner> response) {
                return (AgentPoolInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AgentPoolInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName, AgentPoolInner parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2020-03-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, "2020-03-01", parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolInner>>>(){

            public Observable<ServiceResponse<AgentPoolInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AgentPoolsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AgentPoolInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AgentPoolInner>(){}.getType()).register(201, new TypeToken<AgentPoolInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String resourceName, String agentPoolName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String resourceName, String agentPoolName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        String apiVersion = "2020-03-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, "2020-03-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String resourceName, String agentPoolName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String resourceName, String agentPoolName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        String apiVersion = "2020-03-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, "2020-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AgentPoolsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AgentPoolUpgradeProfileInner getUpgradeProfile(String resourceGroupName, String resourceName, String agentPoolName) {
        return (AgentPoolUpgradeProfileInner)((ServiceResponse)this.getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).toBlocking().single()).body();
    }

    public ServiceFuture<AgentPoolUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName, String agentPoolName, ServiceCallback<AgentPoolUpgradeProfileInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName), serviceCallback);
    }

    public Observable<AgentPoolUpgradeProfileInner> getUpgradeProfileAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        return this.getUpgradeProfileWithServiceResponseAsync(resourceGroupName, resourceName, agentPoolName).map((Func1)new Func1<ServiceResponse<AgentPoolUpgradeProfileInner>, AgentPoolUpgradeProfileInner>(){

            public AgentPoolUpgradeProfileInner call(ServiceResponse<AgentPoolUpgradeProfileInner> response) {
                return (AgentPoolUpgradeProfileInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AgentPoolUpgradeProfileInner>> getUpgradeProfileWithServiceResponseAsync(String resourceGroupName, String resourceName, String agentPoolName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        if (agentPoolName == null) {
            throw new IllegalArgumentException("Parameter agentPoolName is required and cannot be null.");
        }
        String apiVersion = "2020-03-01";
        return this.service.getUpgradeProfile(this.client.subscriptionId(), resourceGroupName, resourceName, agentPoolName, "2020-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolUpgradeProfileInner>>>(){

            public Observable<ServiceResponse<AgentPoolUpgradeProfileInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AgentPoolsInner.this.getUpgradeProfileDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AgentPoolUpgradeProfileInner> getUpgradeProfileDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AgentPoolUpgradeProfileInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AgentPoolAvailableVersionsInner getAvailableAgentPoolVersions(String resourceGroupName, String resourceName) {
        return (AgentPoolAvailableVersionsInner)((ServiceResponse)this.getAvailableAgentPoolVersionsWithServiceResponseAsync(resourceGroupName, resourceName).toBlocking().single()).body();
    }

    public ServiceFuture<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsAsync(String resourceGroupName, String resourceName, ServiceCallback<AgentPoolAvailableVersionsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAvailableAgentPoolVersionsWithServiceResponseAsync(resourceGroupName, resourceName), serviceCallback);
    }

    public Observable<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsAsync(String resourceGroupName, String resourceName) {
        return this.getAvailableAgentPoolVersionsWithServiceResponseAsync(resourceGroupName, resourceName).map((Func1)new Func1<ServiceResponse<AgentPoolAvailableVersionsInner>, AgentPoolAvailableVersionsInner>(){

            public AgentPoolAvailableVersionsInner call(ServiceResponse<AgentPoolAvailableVersionsInner> response) {
                return (AgentPoolAvailableVersionsInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<AgentPoolAvailableVersionsInner>> getAvailableAgentPoolVersionsWithServiceResponseAsync(String resourceGroupName, String resourceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Parameter resourceName is required and cannot be null.");
        }
        String apiVersion = "2020-03-01";
        return this.service.getAvailableAgentPoolVersions(this.client.subscriptionId(), resourceGroupName, resourceName, "2020-03-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AgentPoolAvailableVersionsInner>>>(){

            public Observable<ServiceResponse<AgentPoolAvailableVersionsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AgentPoolsInner.this.getAvailableAgentPoolVersionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AgentPoolAvailableVersionsInner> getAvailableAgentPoolVersionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AgentPoolAvailableVersionsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AgentPoolInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AgentPoolInner>((Page)response.body()){

            public Page<AgentPoolInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AgentPoolsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AgentPoolInner>> listNextAsync(String nextPageLink, ServiceFuture<List<AgentPoolInner>> serviceFuture, ListOperationCallback<AgentPoolInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AgentPoolInner>>>>(){

            public Observable<ServiceResponse<Page<AgentPoolInner>>> call(String nextPageLink) {
                return AgentPoolsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AgentPoolInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AgentPoolInner>>, Page<AgentPoolInner>>(){

            public Page<AgentPoolInner> call(ServiceResponse<Page<AgentPoolInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AgentPoolInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AgentPoolInner>>, Observable<ServiceResponse<Page<AgentPoolInner>>>>(){

            public Observable<ServiceResponse<Page<AgentPoolInner>>> call(ServiceResponse<Page<AgentPoolInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AgentPoolsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AgentPoolInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AgentPoolInner>>>>(){

            public Observable<ServiceResponse<Page<AgentPoolInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AgentPoolsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AgentPoolInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AgentPoolInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AgentPoolsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="agentPoolName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="agentPoolName") String var4, @Query(value="api-version") String var5, @Body AgentPoolInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="agentPoolName") String var4, @Query(value="api-version") String var5, @Body AgentPoolInner var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="agentPoolName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="agentPoolName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools getUpgradeProfile"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/agentPools/{agentPoolName}/upgradeProfiles/default")
        public Observable<Response<ResponseBody>> getUpgradeProfile(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Path(value="agentPoolName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools getAvailableAgentPoolVersions"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{resourceName}/availableAgentPoolVersions")
        public Observable<Response<ResponseBody>> getAvailableAgentPoolVersions(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="resourceName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.containerservice.AgentPools listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

