/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.CassandraKeyspaceCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.CassandraTableCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputSettingsUpdateParameters;
import com.microsoft.azure.management.cosmosdb.implementation.CassandraKeyspaceGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.CassandraTableGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.ThroughputSettingsGetResultsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class CassandraResourcesInner {
    private CassandraResourcesService service;
    private CosmosDBImpl client;

    public CassandraResourcesInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (CassandraResourcesService)retrofit.create(CassandraResourcesService.class);
        this.client = client;
    }

    public List<CassandraKeyspaceGetResultsInner> listCassandraKeyspaces(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<CassandraKeyspaceGetResultsInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName, ServiceCallback<List<CassandraKeyspaceGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<CassandraKeyspaceGetResultsInner>> listCassandraKeyspacesAsync(String resourceGroupName, String accountName) {
        return this.listCassandraKeyspacesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<CassandraKeyspaceGetResultsInner>>, List<CassandraKeyspaceGetResultsInner>>(){

            public List<CassandraKeyspaceGetResultsInner> call(ServiceResponse<List<CassandraKeyspaceGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CassandraKeyspaceGetResultsInner>>> listCassandraKeyspacesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listCassandraKeyspaces(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraKeyspaceGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<CassandraKeyspaceGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CassandraResourcesInner.this.listCassandraKeyspacesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CassandraKeyspaceGetResultsInner>> listCassandraKeyspacesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CassandraKeyspaceGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraKeyspaceGetResultsInner getCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        return (CassandraKeyspaceGetResultsInner)((Object)((ServiceResponse)this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraKeyspaceGetResultsInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<CassandraKeyspaceGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<CassandraKeyspaceGetResultsInner> getCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.getCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceGetResultsInner>, CassandraKeyspaceGetResultsInner>(){

            public CassandraKeyspaceGetResultsInner call(ServiceResponse<CassandraKeyspaceGetResultsInner> response) {
                return (CassandraKeyspaceGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceGetResultsInner>> getCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceGetResultsInner>>>(){

            public Observable<ServiceResponse<CassandraKeyspaceGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.getCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraKeyspaceGetResultsInner> getCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraKeyspaceGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraKeyspaceGetResultsInner createUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return (CassandraKeyspaceGetResultsInner)((Object)((ServiceResponse)this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).toBlocking().last()).body());
    }

    public ServiceFuture<CassandraKeyspaceGetResultsInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, ServiceCallback<CassandraKeyspaceGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    public Observable<CassandraKeyspaceGetResultsInner> createUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return this.createUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceGetResultsInner>, CassandraKeyspaceGetResultsInner>(){

            public CassandraKeyspaceGetResultsInner call(ServiceResponse<CassandraKeyspaceGetResultsInner> response) {
                return (CassandraKeyspaceGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceGetResultsInner>> createUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateCassandraKeyspaceParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraKeyspaceGetResultsInner>(){}.getType());
    }

    public CassandraKeyspaceGetResultsInner beginCreateUpdateCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return (CassandraKeyspaceGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraKeyspaceGetResultsInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters, ServiceCallback<CassandraKeyspaceGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters), serviceCallback);
    }

    public Observable<CassandraKeyspaceGetResultsInner> beginCreateUpdateCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        return this.beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, createUpdateCassandraKeyspaceParameters).map((Func1)new Func1<ServiceResponse<CassandraKeyspaceGetResultsInner>, CassandraKeyspaceGetResultsInner>(){

            public CassandraKeyspaceGetResultsInner call(ServiceResponse<CassandraKeyspaceGetResultsInner> response) {
                return (CassandraKeyspaceGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraKeyspaceGetResultsInner>> beginCreateUpdateCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, CassandraKeyspaceCreateUpdateParameters createUpdateCassandraKeyspaceParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (createUpdateCassandraKeyspaceParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraKeyspaceParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateCassandraKeyspaceParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", createUpdateCassandraKeyspaceParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraKeyspaceGetResultsInner>>>(){

            public Observable<ServiceResponse<CassandraKeyspaceGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.beginCreateUpdateCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraKeyspaceGetResultsInner> beginCreateUpdateCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraKeyspaceGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        ((ServiceResponse)this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<Void> deleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.deleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteCassandraKeyspace(String resourceGroupName, String accountName, String keyspaceName) {
        ((ServiceResponse)this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<Void> beginDeleteCassandraKeyspaceAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.beginDeleteCassandraKeyspaceWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteCassandraKeyspaceWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteCassandraKeyspace(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.beginDeleteCassandraKeyspaceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteCassandraKeyspaceDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.getCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.getCassandraKeyspaceThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getCassandraKeyspaceThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateCassandraKeyspaceThroughput(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateCassandraKeyspaceThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateCassandraKeyspaceThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateCassandraKeyspaceThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.beginUpdateCassandraKeyspaceThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateCassandraKeyspaceThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<CassandraTableGetResultsInner> listCassandraTables(String resourceGroupName, String accountName, String keyspaceName) {
        return (List)((ServiceResponse)this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).toBlocking().single()).body();
    }

    public ServiceFuture<List<CassandraTableGetResultsInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceName, ServiceCallback<List<CassandraTableGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName), serviceCallback);
    }

    public Observable<List<CassandraTableGetResultsInner>> listCassandraTablesAsync(String resourceGroupName, String accountName, String keyspaceName) {
        return this.listCassandraTablesWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName).map((Func1)new Func1<ServiceResponse<List<CassandraTableGetResultsInner>>, List<CassandraTableGetResultsInner>>(){

            public List<CassandraTableGetResultsInner> call(ServiceResponse<List<CassandraTableGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CassandraTableGetResultsInner>>> listCassandraTablesWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listCassandraTables(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CassandraTableGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<CassandraTableGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = CassandraResourcesInner.this.listCassandraTablesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<CassandraTableGetResultsInner>> listCassandraTablesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<CassandraTableGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraTableGetResultsInner getCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return (CassandraTableGetResultsInner)((Object)((ServiceResponse)this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraTableGetResultsInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<CassandraTableGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<CassandraTableGetResultsInner> getCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.getCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<CassandraTableGetResultsInner>, CassandraTableGetResultsInner>(){

            public CassandraTableGetResultsInner call(ServiceResponse<CassandraTableGetResultsInner> response) {
                return (CassandraTableGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableGetResultsInner>> getCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableGetResultsInner>>>(){

            public Observable<ServiceResponse<CassandraTableGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.getCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraTableGetResultsInner> getCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraTableGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public CassandraTableGetResultsInner createUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return (CassandraTableGetResultsInner)((Object)((ServiceResponse)this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).toBlocking().last()).body());
    }

    public ServiceFuture<CassandraTableGetResultsInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, ServiceCallback<CassandraTableGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters), serviceCallback);
    }

    public Observable<CassandraTableGetResultsInner> createUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return this.createUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).map((Func1)new Func1<ServiceResponse<CassandraTableGetResultsInner>, CassandraTableGetResultsInner>(){

            public CassandraTableGetResultsInner call(ServiceResponse<CassandraTableGetResultsInner> response) {
                return (CassandraTableGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableGetResultsInner>> createUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateCassandraTableParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<CassandraTableGetResultsInner>(){}.getType());
    }

    public CassandraTableGetResultsInner beginCreateUpdateCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return (CassandraTableGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).toBlocking().single()).body());
    }

    public ServiceFuture<CassandraTableGetResultsInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters, ServiceCallback<CassandraTableGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters), serviceCallback);
    }

    public Observable<CassandraTableGetResultsInner> beginCreateUpdateCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        return this.beginCreateUpdateCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, createUpdateCassandraTableParameters).map((Func1)new Func1<ServiceResponse<CassandraTableGetResultsInner>, CassandraTableGetResultsInner>(){

            public CassandraTableGetResultsInner call(ServiceResponse<CassandraTableGetResultsInner> response) {
                return (CassandraTableGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<CassandraTableGetResultsInner>> beginCreateUpdateCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, CassandraTableCreateUpdateParameters createUpdateCassandraTableParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (createUpdateCassandraTableParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateCassandraTableParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateCassandraTableParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", createUpdateCassandraTableParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<CassandraTableGetResultsInner>>>(){

            public Observable<ServiceResponse<CassandraTableGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.beginCreateUpdateCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<CassandraTableGetResultsInner> beginCreateUpdateCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<CassandraTableGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        ((ServiceResponse)this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<Void> deleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.deleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteCassandraTable(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        ((ServiceResponse)this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<Void> beginDeleteCassandraTableAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.beginDeleteCassandraTableWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteCassandraTableWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteCassandraTable(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.beginDeleteCassandraTableDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteCassandraTableDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        return this.getCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.getCassandraTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getCassandraTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateCassandraTableThroughput(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateCassandraTableThroughputAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateCassandraTableThroughputWithServiceResponseAsync(resourceGroupName, accountName, keyspaceName, tableName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateCassandraTableThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String keyspaceName, String tableName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (keyspaceName == null) {
            throw new IllegalArgumentException("Parameter keyspaceName is required and cannot be null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("Parameter tableName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateCassandraTableThroughput(this.client.subscriptionId(), resourceGroupName, accountName, keyspaceName, tableName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = CassandraResourcesInner.this.beginUpdateCassandraTableThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateCassandraTableThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface CassandraResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources listCassandraKeyspaces"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces")
        public Observable<Response<ResponseBody>> listCassandraKeyspaces(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources getCassandraKeyspace"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}")
        public Observable<Response<ResponseBody>> getCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources createUpdateCassandraKeyspace"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}")
        public Observable<Response<ResponseBody>> createUpdateCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Body CassandraKeyspaceCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources beginCreateUpdateCassandraKeyspace"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Body CassandraKeyspaceCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources deleteCassandraKeyspace"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources beginDeleteCassandraKeyspace"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteCassandraKeyspace(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources getCassandraKeyspaceThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getCassandraKeyspaceThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources updateCassandraKeyspaceThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateCassandraKeyspaceThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources beginUpdateCassandraKeyspaceThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateCassandraKeyspaceThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources listCassandraTables"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables")
        public Observable<Response<ResponseBody>> listCassandraTables(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources getCassandraTable"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> getCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources createUpdateCassandraTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> createUpdateCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Body CassandraTableCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources beginCreateUpdateCassandraTable"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Body CassandraTableCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources deleteCassandraTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources beginDeleteCassandraTable"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteCassandraTable(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources getCassandraTableThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getCassandraTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources updateCassandraTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateCassandraTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.CassandraResources beginUpdateCassandraTableThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/cassandraKeyspaces/{keyspaceName}/tables/{tableName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateCassandraTableThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="keyspaceName") String var4, @Path(value="tableName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);
    }
}

