/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.SqlContainerCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlDatabaseCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlStoredProcedureCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlTriggerCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.SqlUserDefinedFunctionCreateUpdateParameters;
import com.microsoft.azure.management.cosmosdb.ThroughputSettingsUpdateParameters;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.SqlContainerGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.SqlDatabaseGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.SqlStoredProcedureGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.SqlTriggerGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.SqlUserDefinedFunctionGetResultsInner;
import com.microsoft.azure.management.cosmosdb.implementation.ThroughputSettingsGetResultsInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class SqlResourcesInner {
    private SqlResourcesService service;
    private CosmosDBImpl client;

    public SqlResourcesInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (SqlResourcesService)retrofit.create(SqlResourcesService.class);
        this.client = client;
    }

    public List<SqlDatabaseGetResultsInner> listSqlDatabases(String resourceGroupName, String accountName) {
        return (List)((ServiceResponse)this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlDatabaseGetResultsInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName, ServiceCallback<List<SqlDatabaseGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName), serviceCallback);
    }

    public Observable<List<SqlDatabaseGetResultsInner>> listSqlDatabasesAsync(String resourceGroupName, String accountName) {
        return this.listSqlDatabasesWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<List<SqlDatabaseGetResultsInner>>, List<SqlDatabaseGetResultsInner>>(){

            public List<SqlDatabaseGetResultsInner> call(ServiceResponse<List<SqlDatabaseGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlDatabaseGetResultsInner>>> listSqlDatabasesWithServiceResponseAsync(String resourceGroupName, String accountName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listSqlDatabases(this.client.subscriptionId(), resourceGroupName, accountName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlDatabaseGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<SqlDatabaseGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SqlResourcesInner.this.listSqlDatabasesDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlDatabaseGetResultsInner>> listSqlDatabasesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlDatabaseGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlDatabaseGetResultsInner getSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        return (SqlDatabaseGetResultsInner)((Object)((ServiceResponse)this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<SqlDatabaseGetResultsInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<SqlDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<SqlDatabaseGetResultsInner> getSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>(){

            public SqlDatabaseGetResultsInner call(ServiceResponse<SqlDatabaseGetResultsInner> response) {
                return (SqlDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> getSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.getSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlDatabaseGetResultsInner> getSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlDatabaseGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlDatabaseGetResultsInner createUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return (SqlDatabaseGetResultsInner)((Object)((ServiceResponse)this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, ServiceCallback<SqlDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    public Observable<SqlDatabaseGetResultsInner> createUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.createUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map((Func1)new Func1<ServiceResponse<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>(){

            public SqlDatabaseGetResultsInner call(ServiceResponse<SqlDatabaseGetResultsInner> response) {
                return (SqlDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> createUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlDatabaseParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlDatabaseGetResultsInner>(){}.getType());
    }

    public SqlDatabaseGetResultsInner beginCreateUpdateSqlDatabase(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return (SqlDatabaseGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters, ServiceCallback<SqlDatabaseGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters), serviceCallback);
    }

    public Observable<SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        return this.beginCreateUpdateSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName, createUpdateSqlDatabaseParameters).map((Func1)new Func1<ServiceResponse<SqlDatabaseGetResultsInner>, SqlDatabaseGetResultsInner>(){

            public SqlDatabaseGetResultsInner call(ServiceResponse<SqlDatabaseGetResultsInner> response) {
                return (SqlDatabaseGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> beginCreateUpdateSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, SqlDatabaseCreateUpdateParameters createUpdateSqlDatabaseParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (createUpdateSqlDatabaseParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlDatabaseParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlDatabaseParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", createUpdateSqlDatabaseParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlDatabaseGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlDatabaseGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginCreateUpdateSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlDatabaseGetResultsInner> beginCreateUpdateSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlDatabaseGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> deleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.deleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlDatabase(String resourceGroupName, String accountName, String databaseName) {
        ((ServiceResponse)this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlDatabaseAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.beginDeleteSqlDatabaseWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlDatabaseWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteSqlDatabase(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginDeleteSqlDatabaseDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlDatabaseDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.getSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.getSqlDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateSqlDatabaseThroughput(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateSqlDatabaseThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateSqlDatabaseThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginUpdateSqlDatabaseThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateSqlDatabaseThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SqlContainerGetResultsInner> listSqlContainers(String resourceGroupName, String accountName, String databaseName) {
        return (List)((ServiceResponse)this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlContainerGetResultsInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName, ServiceCallback<List<SqlContainerGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName), serviceCallback);
    }

    public Observable<List<SqlContainerGetResultsInner>> listSqlContainersAsync(String resourceGroupName, String accountName, String databaseName) {
        return this.listSqlContainersWithServiceResponseAsync(resourceGroupName, accountName, databaseName).map((Func1)new Func1<ServiceResponse<List<SqlContainerGetResultsInner>>, List<SqlContainerGetResultsInner>>(){

            public List<SqlContainerGetResultsInner> call(ServiceResponse<List<SqlContainerGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlContainerGetResultsInner>>> listSqlContainersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listSqlContainers(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlContainerGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<SqlContainerGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SqlResourcesInner.this.listSqlContainersDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlContainerGetResultsInner>> listSqlContainersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlContainerGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlContainerGetResultsInner getSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (SqlContainerGetResultsInner)((Object)((ServiceResponse)this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<SqlContainerGetResultsInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<SqlContainerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<SqlContainerGetResultsInner> getSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.getSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>(){

            public SqlContainerGetResultsInner call(ServiceResponse<SqlContainerGetResultsInner> response) {
                return (SqlContainerGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlContainerGetResultsInner>> getSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlContainerGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.getSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlContainerGetResultsInner> getSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlContainerGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlContainerGetResultsInner createUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return (SqlContainerGetResultsInner)((Object)((ServiceResponse)this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, ServiceCallback<SqlContainerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    public Observable<SqlContainerGetResultsInner> createUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.createUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map((Func1)new Func1<ServiceResponse<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>(){

            public SqlContainerGetResultsInner call(ServiceResponse<SqlContainerGetResultsInner> response) {
                return (SqlContainerGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlContainerGetResultsInner>> createUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlContainerParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlContainerGetResultsInner>(){}.getType());
    }

    public SqlContainerGetResultsInner beginCreateUpdateSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return (SqlContainerGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlContainerGetResultsInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters, ServiceCallback<SqlContainerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters), serviceCallback);
    }

    public Observable<SqlContainerGetResultsInner> beginCreateUpdateSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        return this.beginCreateUpdateSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, createUpdateSqlContainerParameters).map((Func1)new Func1<ServiceResponse<SqlContainerGetResultsInner>, SqlContainerGetResultsInner>(){

            public SqlContainerGetResultsInner call(ServiceResponse<SqlContainerGetResultsInner> response) {
                return (SqlContainerGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlContainerGetResultsInner>> beginCreateUpdateSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, SqlContainerCreateUpdateParameters createUpdateSqlContainerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (createUpdateSqlContainerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlContainerParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlContainerParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", createUpdateSqlContainerParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlContainerGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlContainerGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginCreateUpdateSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlContainerGetResultsInner> beginCreateUpdateSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlContainerGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        ((ServiceResponse)this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<Void> deleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.deleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlContainer(String resourceGroupName, String accountName, String databaseName, String containerName) {
        ((ServiceResponse)this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlContainerAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.beginDeleteSqlContainerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlContainerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteSqlContainer(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginDeleteSqlContainerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlContainerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner getSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> getSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.getSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> getSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.getSqlContainerThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> getSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ThroughputSettingsGetResultsInner updateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> updateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.updateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> updateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.updateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType());
    }

    public ThroughputSettingsGetResultsInner beginUpdateSqlContainerThroughput(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return (ThroughputSettingsGetResultsInner)((Object)((ServiceResponse)this.beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters, ServiceCallback<ThroughputSettingsGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters), serviceCallback);
    }

    public Observable<ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        return this.beginUpdateSqlContainerThroughputWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, updateThroughputParameters).map((Func1)new Func1<ServiceResponse<ThroughputSettingsGetResultsInner>, ThroughputSettingsGetResultsInner>(){

            public ThroughputSettingsGetResultsInner call(ServiceResponse<ThroughputSettingsGetResultsInner> response) {
                return (ThroughputSettingsGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> beginUpdateSqlContainerThroughputWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ThroughputSettingsUpdateParameters updateThroughputParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (updateThroughputParameters == null) {
            throw new IllegalArgumentException("Parameter updateThroughputParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)updateThroughputParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginUpdateSqlContainerThroughput(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", updateThroughputParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ThroughputSettingsGetResultsInner>>>(){

            public Observable<ServiceResponse<ThroughputSettingsGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginUpdateSqlContainerThroughputDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ThroughputSettingsGetResultsInner> beginUpdateSqlContainerThroughputDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ThroughputSettingsGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SqlStoredProcedureGetResultsInner> listSqlStoredProcedures(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (List)((ServiceResponse)this.listSqlStoredProceduresWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<List<SqlStoredProcedureGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlStoredProceduresWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<List<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.listSqlStoredProceduresWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>, List<SqlStoredProcedureGetResultsInner>>(){

            public List<SqlStoredProcedureGetResultsInner> call(ServiceResponse<List<SqlStoredProcedureGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>> listSqlStoredProceduresWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listSqlStoredProcedures(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<SqlStoredProcedureGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SqlResourcesInner.this.listSqlStoredProceduresDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlStoredProcedureGetResultsInner>> listSqlStoredProceduresDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlStoredProcedureGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlStoredProcedureGetResultsInner getSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return (SqlStoredProcedureGetResultsInner)((Object)((ServiceResponse)this.getSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).toBlocking().single()).body());
    }

    public ServiceFuture<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, ServiceCallback<SqlStoredProcedureGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName), serviceCallback);
    }

    public Observable<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return this.getSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).map((Func1)new Func1<ServiceResponse<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>(){

            public SqlStoredProcedureGetResultsInner call(ServiceResponse<SqlStoredProcedureGetResultsInner> response) {
                return (SqlStoredProcedureGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> getSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.getSqlStoredProcedureDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlStoredProcedureGetResultsInner> getSqlStoredProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlStoredProcedureGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlStoredProcedureGetResultsInner createUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return (SqlStoredProcedureGetResultsInner)((Object)((ServiceResponse)this.createUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, ServiceCallback<SqlStoredProcedureGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters), serviceCallback);
    }

    public Observable<SqlStoredProcedureGetResultsInner> createUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return this.createUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).map((Func1)new Func1<ServiceResponse<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>(){

            public SqlStoredProcedureGetResultsInner call(ServiceResponse<SqlStoredProcedureGetResultsInner> response) {
                return (SqlStoredProcedureGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> createUpdateSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlStoredProcedureParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", createUpdateSqlStoredProcedureParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlStoredProcedureGetResultsInner>(){}.getType());
    }

    public SqlStoredProcedureGetResultsInner beginCreateUpdateSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return (SqlStoredProcedureGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters, ServiceCallback<SqlStoredProcedureGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters), serviceCallback);
    }

    public Observable<SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        return this.beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName, createUpdateSqlStoredProcedureParameters).map((Func1)new Func1<ServiceResponse<SqlStoredProcedureGetResultsInner>, SqlStoredProcedureGetResultsInner>(){

            public SqlStoredProcedureGetResultsInner call(ServiceResponse<SqlStoredProcedureGetResultsInner> response) {
                return (SqlStoredProcedureGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> beginCreateUpdateSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, SqlStoredProcedureCreateUpdateParameters createUpdateSqlStoredProcedureParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        if (createUpdateSqlStoredProcedureParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlStoredProcedureParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlStoredProcedureParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", createUpdateSqlStoredProcedureParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlStoredProcedureGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginCreateUpdateSqlStoredProcedureDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlStoredProcedureGetResultsInner> beginCreateUpdateSqlStoredProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlStoredProcedureGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        ((ServiceResponse)this.deleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName), serviceCallback);
    }

    public Observable<Void> deleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return this.deleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlStoredProcedure(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        ((ServiceResponse)this.beginDeleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlStoredProcedureAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        return this.beginDeleteSqlStoredProcedureWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, storedProcedureName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlStoredProcedureWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String storedProcedureName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (storedProcedureName == null) {
            throw new IllegalArgumentException("Parameter storedProcedureName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteSqlStoredProcedure(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, storedProcedureName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginDeleteSqlStoredProcedureDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlStoredProcedureDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SqlUserDefinedFunctionGetResultsInner> listSqlUserDefinedFunctions(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (List)((ServiceResponse)this.listSqlUserDefinedFunctionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<List<SqlUserDefinedFunctionGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlUserDefinedFunctionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<List<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.listSqlUserDefinedFunctionsWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>, List<SqlUserDefinedFunctionGetResultsInner>>(){

            public List<SqlUserDefinedFunctionGetResultsInner> call(ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>> listSqlUserDefinedFunctionsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listSqlUserDefinedFunctions(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<SqlUserDefinedFunctionGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SqlResourcesInner.this.listSqlUserDefinedFunctionsDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlUserDefinedFunctionGetResultsInner>> listSqlUserDefinedFunctionsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlUserDefinedFunctionGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlUserDefinedFunctionGetResultsInner getSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return (SqlUserDefinedFunctionGetResultsInner)((Object)((ServiceResponse)this.getSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).toBlocking().single()).body());
    }

    public ServiceFuture<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, ServiceCallback<SqlUserDefinedFunctionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName), serviceCallback);
    }

    public Observable<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return this.getSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).map((Func1)new Func1<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>(){

            public SqlUserDefinedFunctionGetResultsInner call(ServiceResponse<SqlUserDefinedFunctionGetResultsInner> response) {
                return (SqlUserDefinedFunctionGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> getSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.getSqlUserDefinedFunctionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlUserDefinedFunctionGetResultsInner> getSqlUserDefinedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlUserDefinedFunctionGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlUserDefinedFunctionGetResultsInner createUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return (SqlUserDefinedFunctionGetResultsInner)((Object)((ServiceResponse)this.createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, ServiceCallback<SqlUserDefinedFunctionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters), serviceCallback);
    }

    public Observable<SqlUserDefinedFunctionGetResultsInner> createUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return this.createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).map((Func1)new Func1<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>(){

            public SqlUserDefinedFunctionGetResultsInner call(ServiceResponse<SqlUserDefinedFunctionGetResultsInner> response) {
                return (SqlUserDefinedFunctionGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> createUpdateSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlUserDefinedFunctionParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", createUpdateSqlUserDefinedFunctionParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlUserDefinedFunctionGetResultsInner>(){}.getType());
    }

    public SqlUserDefinedFunctionGetResultsInner beginCreateUpdateSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return (SqlUserDefinedFunctionGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters, ServiceCallback<SqlUserDefinedFunctionGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters), serviceCallback);
    }

    public Observable<SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        return this.beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, createUpdateSqlUserDefinedFunctionParameters).map((Func1)new Func1<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>, SqlUserDefinedFunctionGetResultsInner>(){

            public SqlUserDefinedFunctionGetResultsInner call(ServiceResponse<SqlUserDefinedFunctionGetResultsInner> response) {
                return (SqlUserDefinedFunctionGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> beginCreateUpdateSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, SqlUserDefinedFunctionCreateUpdateParameters createUpdateSqlUserDefinedFunctionParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        if (createUpdateSqlUserDefinedFunctionParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlUserDefinedFunctionParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlUserDefinedFunctionParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", createUpdateSqlUserDefinedFunctionParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlUserDefinedFunctionGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginCreateUpdateSqlUserDefinedFunctionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlUserDefinedFunctionGetResultsInner> beginCreateUpdateSqlUserDefinedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlUserDefinedFunctionGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        ((ServiceResponse)this.deleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName), serviceCallback);
    }

    public Observable<Void> deleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return this.deleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlUserDefinedFunction(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        ((ServiceResponse)this.beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlUserDefinedFunctionAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        return this.beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlUserDefinedFunctionWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String userDefinedFunctionName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (userDefinedFunctionName == null) {
            throw new IllegalArgumentException("Parameter userDefinedFunctionName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteSqlUserDefinedFunction(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, userDefinedFunctionName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginDeleteSqlUserDefinedFunctionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlUserDefinedFunctionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<SqlTriggerGetResultsInner> listSqlTriggers(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return (List)((ServiceResponse)this.listSqlTriggersWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).toBlocking().single()).body();
    }

    public ServiceFuture<List<SqlTriggerGetResultsInner>> listSqlTriggersAsync(String resourceGroupName, String accountName, String databaseName, String containerName, ServiceCallback<List<SqlTriggerGetResultsInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listSqlTriggersWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName), serviceCallback);
    }

    public Observable<List<SqlTriggerGetResultsInner>> listSqlTriggersAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        return this.listSqlTriggersWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName).map((Func1)new Func1<ServiceResponse<List<SqlTriggerGetResultsInner>>, List<SqlTriggerGetResultsInner>>(){

            public List<SqlTriggerGetResultsInner> call(ServiceResponse<List<SqlTriggerGetResultsInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<SqlTriggerGetResultsInner>>> listSqlTriggersWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.listSqlTriggers(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<SqlTriggerGetResultsInner>>>>(){

            public Observable<ServiceResponse<List<SqlTriggerGetResultsInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SqlResourcesInner.this.listSqlTriggersDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SqlTriggerGetResultsInner>> listSqlTriggersDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SqlTriggerGetResultsInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlTriggerGetResultsInner getSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return (SqlTriggerGetResultsInner)((Object)((ServiceResponse)this.getSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).toBlocking().single()).body());
    }

    public ServiceFuture<SqlTriggerGetResultsInner> getSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, ServiceCallback<SqlTriggerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName), serviceCallback);
    }

    public Observable<SqlTriggerGetResultsInner> getSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return this.getSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).map((Func1)new Func1<ServiceResponse<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>(){

            public SqlTriggerGetResultsInner call(ServiceResponse<SqlTriggerGetResultsInner> response) {
                return (SqlTriggerGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlTriggerGetResultsInner>> getSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.getSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlTriggerGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlTriggerGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.getSqlTriggerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlTriggerGetResultsInner> getSqlTriggerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlTriggerGetResultsInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SqlTriggerGetResultsInner createUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return (SqlTriggerGetResultsInner)((Object)((ServiceResponse)this.createUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, ServiceCallback<SqlTriggerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters), serviceCallback);
    }

    public Observable<SqlTriggerGetResultsInner> createUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return this.createUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).map((Func1)new Func1<ServiceResponse<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>(){

            public SqlTriggerGetResultsInner call(ServiceResponse<SqlTriggerGetResultsInner> response) {
                return (SqlTriggerGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlTriggerGetResultsInner>> createUpdateSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        if (createUpdateSqlTriggerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlTriggerParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlTriggerParameters));
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.createUpdateSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", createUpdateSqlTriggerParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SqlTriggerGetResultsInner>(){}.getType());
    }

    public SqlTriggerGetResultsInner beginCreateUpdateSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return (SqlTriggerGetResultsInner)((Object)((ServiceResponse)this.beginCreateUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters, ServiceCallback<SqlTriggerGetResultsInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters), serviceCallback);
    }

    public Observable<SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        return this.beginCreateUpdateSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName, createUpdateSqlTriggerParameters).map((Func1)new Func1<ServiceResponse<SqlTriggerGetResultsInner>, SqlTriggerGetResultsInner>(){

            public SqlTriggerGetResultsInner call(ServiceResponse<SqlTriggerGetResultsInner> response) {
                return (SqlTriggerGetResultsInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SqlTriggerGetResultsInner>> beginCreateUpdateSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, SqlTriggerCreateUpdateParameters createUpdateSqlTriggerParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        if (createUpdateSqlTriggerParameters == null) {
            throw new IllegalArgumentException("Parameter createUpdateSqlTriggerParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)createUpdateSqlTriggerParameters));
        String apiVersion = "2019-08-01";
        return this.service.beginCreateUpdateSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", createUpdateSqlTriggerParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SqlTriggerGetResultsInner>>>(){

            public Observable<ServiceResponse<SqlTriggerGetResultsInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginCreateUpdateSqlTriggerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SqlTriggerGetResultsInner> beginCreateUpdateSqlTriggerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SqlTriggerGetResultsInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void deleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        ((ServiceResponse)this.deleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName), serviceCallback);
    }

    public Observable<Void> deleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return this.deleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        Observable<Response<ResponseBody>> observable = this.service.deleteSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDeleteSqlTrigger(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        ((ServiceResponse)this.beginDeleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName), serviceCallback);
    }

    public Observable<Void> beginDeleteSqlTriggerAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        return this.beginDeleteSqlTriggerWithServiceResponseAsync(resourceGroupName, accountName, databaseName, containerName, triggerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteSqlTriggerWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseName, String containerName, String triggerName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseName == null) {
            throw new IllegalArgumentException("Parameter databaseName is required and cannot be null.");
        }
        if (containerName == null) {
            throw new IllegalArgumentException("Parameter containerName is required and cannot be null.");
        }
        if (triggerName == null) {
            throw new IllegalArgumentException("Parameter triggerName is required and cannot be null.");
        }
        String apiVersion = "2019-08-01";
        return this.service.beginDeleteSqlTrigger(this.client.subscriptionId(), resourceGroupName, accountName, databaseName, containerName, triggerName, "2019-08-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SqlResourcesInner.this.beginDeleteSqlTriggerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteSqlTriggerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SqlResourcesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlDatabases"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases")
        public Observable<Response<ResponseBody>> listSqlDatabases(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlDatabase"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> getSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> createUpdateSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body SqlDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlDatabase"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body SqlDatabaseCreateUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlDatabase"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlDatabase(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlDatabaseThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getSqlDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources updateSqlDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateSqlDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginUpdateSqlDatabaseThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateSqlDatabaseThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Body ThroughputSettingsUpdateParameters var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlContainers"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers")
        public Observable<Response<ResponseBody>> listSqlContainers(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlContainer"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        public Observable<Response<ResponseBody>> getSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        public Observable<Response<ResponseBody>> createUpdateSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Body SqlContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlContainer"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Body SqlContainerCreateUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlContainer"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlContainer(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlContainerThroughput"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> getSqlContainerThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources updateSqlContainerThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> updateSqlContainerThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginUpdateSqlContainerThroughput"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/throughputSettings/default")
        public Observable<Response<ResponseBody>> beginUpdateSqlContainerThroughput(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Body ThroughputSettingsUpdateParameters var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlStoredProcedures"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/")
        public Observable<Response<ResponseBody>> listSqlStoredProcedures(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlStoredProcedure"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        public Observable<Response<ResponseBody>> getSqlStoredProcedure(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="storedProcedureName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlStoredProcedure"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        public Observable<Response<ResponseBody>> createUpdateSqlStoredProcedure(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="storedProcedureName") String var6, @Query(value="api-version") String var7, @Body SqlStoredProcedureCreateUpdateParameters var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlStoredProcedure"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlStoredProcedure(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="storedProcedureName") String var6, @Query(value="api-version") String var7, @Body SqlStoredProcedureCreateUpdateParameters var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlStoredProcedure"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlStoredProcedure(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="storedProcedureName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlStoredProcedure"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/storedProcedures/{storedProcedureName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlStoredProcedure(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="storedProcedureName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlUserDefinedFunctions"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/")
        public Observable<Response<ResponseBody>> listSqlUserDefinedFunctions(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlUserDefinedFunction"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        public Observable<Response<ResponseBody>> getSqlUserDefinedFunction(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="userDefinedFunctionName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlUserDefinedFunction"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        public Observable<Response<ResponseBody>> createUpdateSqlUserDefinedFunction(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="userDefinedFunctionName") String var6, @Query(value="api-version") String var7, @Body SqlUserDefinedFunctionCreateUpdateParameters var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlUserDefinedFunction"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlUserDefinedFunction(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="userDefinedFunctionName") String var6, @Query(value="api-version") String var7, @Body SqlUserDefinedFunctionCreateUpdateParameters var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlUserDefinedFunction"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlUserDefinedFunction(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="userDefinedFunctionName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlUserDefinedFunction"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/userDefinedFunctions/{userDefinedFunctionName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlUserDefinedFunction(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="userDefinedFunctionName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources listSqlTriggers"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/")
        public Observable<Response<ResponseBody>> listSqlTriggers(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources getSqlTrigger"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        public Observable<Response<ResponseBody>> getSqlTrigger(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="triggerName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources createUpdateSqlTrigger"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        public Observable<Response<ResponseBody>> createUpdateSqlTrigger(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="triggerName") String var6, @Query(value="api-version") String var7, @Body SqlTriggerCreateUpdateParameters var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginCreateUpdateSqlTrigger"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}")
        public Observable<Response<ResponseBody>> beginCreateUpdateSqlTrigger(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="triggerName") String var6, @Query(value="api-version") String var7, @Body SqlTriggerCreateUpdateParameters var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources deleteSqlTrigger"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteSqlTrigger(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="triggerName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.SqlResources beginDeleteSqlTrigger"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/sqlDatabases/{databaseName}/containers/{containerName}/triggers/{triggerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDeleteSqlTrigger(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseName") String var4, @Path(value="containerName") String var5, @Path(value="triggerName") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);
    }
}

