/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import com.microsoft.azure.management.datalake.store.implementation.DataLakeStoreFileSystemManagementClientImpl;
import com.microsoft.azure.management.datalake.store.models.AdlsErrorException;
import com.microsoft.azure.management.datalake.store.models.FileStatusResult;
import com.microsoft.azure.management.datalake.store.uploader.FrontEndAdapter;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class DataLakeStoreFrontEndAdapterImpl
implements FrontEndAdapter {
    private String accountName;
    private DataLakeStoreFileSystemManagementClientImpl client;

    public DataLakeStoreFrontEndAdapterImpl(String accountName, DataLakeStoreFileSystemManagementClientImpl client) {
        this.accountName = accountName;
        this.client = client;
    }

    @Override
    public void createStream(String streamPath, boolean overwrite, byte[] data, int byteCount) throws RestException, IOException {
        if (data == null) {
            byte[] toCreate = new byte[]{};
        } else {
            byte[] toCreate = new byte[byteCount];
            System.arraycopy(data, 0, toCreate, 0, byteCount);
        }
        this.client.fileSystems().create(this.accountName, streamPath, data, Boolean.valueOf(overwrite));
    }

    @Override
    public void deleteStream(String streamPath, boolean recurse) throws IOException, RestException {
        this.client.fileSystems().delete(this.accountName, streamPath, Boolean.valueOf(recurse));
    }

    @Override
    public void appendToStream(String streamPath, byte[] data, long offset, int byteCount) throws IOException, RestException {
        byte[] toAppend = new byte[byteCount];
        System.arraycopy(data, 0, toAppend, 0, byteCount);
        this.client.fileSystems().append(this.accountName, streamPath, toAppend);
    }

    @Override
    public boolean streamExists(String streamPath) throws RestException, IOException {
        try {
            this.client.fileSystems().getFileStatus(this.accountName, streamPath);
        }
        catch (AdlsErrorException cloudEx) {
            if (cloudEx.getResponse().code() == 404) {
                return false;
            }
            throw cloudEx;
        }
        return true;
    }

    @Override
    public long getStreamLength(String streamPath) throws IOException, RestException {
        FileStatusResult fileInfoResponse = (FileStatusResult)this.client.fileSystems().getFileStatus(this.accountName, streamPath).getBody();
        return fileInfoResponse.fileStatus().length();
    }

    @Override
    public void concatenate(String targetStreamPath, String[] inputStreamPaths) throws IOException, RestException {
        String paths = MessageFormat.format("sources={0}", StringUtils.join((Object[])inputStreamPaths, (char)','));
        this.client.fileSystems().msConcat(this.accountName, targetStreamPath, paths.getBytes(StandardCharsets.UTF_8), Boolean.valueOf(true));
    }
}

