/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.datalake.store.uploader;

import com.microsoft.azure.management.datalake.store.uploader.FrontEndAdapter;
import com.microsoft.azure.management.datalake.store.uploader.StringExtensions;
import com.microsoft.azure.management.datalake.store.uploader.UploadFailedException;
import com.microsoft.azure.management.datalake.store.uploader.UploadMetadata;
import com.microsoft.azure.management.datalake.store.uploader.UploadSegmentMetadata;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;

public class SingleSegmentUploader {
    public static final int BUFFER_LENGTH = 0x400000;
    public static final int MAX_RECORD_LENGTH = 0x400000;
    public static final int MAXIMUM_BACKOFF_WAIT_SECONDS = 32;
    public static final int MAX_BUFFER_UPLOAD_ATTEMPT_COUNT = 4;
    private FrontEndAdapter frontEndAdapter;
    private UploadSegmentMetadata segmentMetadata;
    private UploadMetadata metadata;
    private boolean useBackOffRetryStrategy;

    public SingleSegmentUploader(int segmentNumber, UploadMetadata uploadMetadata, FrontEndAdapter frontEnd) {
        this.metadata = uploadMetadata;
        this.segmentMetadata = uploadMetadata.getSegments()[segmentNumber];
        this.frontEndAdapter = frontEnd;
        this.useBackOffRetryStrategy = true;
    }

    public boolean useBackOffRetryStrategy() {
        return this.useBackOffRetryStrategy;
    }

    public void setUseBackOffRetryStrategy(boolean isEnabled) {
        this.useBackOffRetryStrategy = isEnabled;
    }

    public void upload() throws Exception {
        File fileInfo = new File(this.metadata.getInputFilePath());
        if (!fileInfo.exists()) {
            throw new FileNotFoundException("Unable to locate input file: " + this.metadata.getInputFilePath());
        }
        try (RandomAccessFile inputStream = this.openInputStream();){
            long endPosition = this.segmentMetadata.getOffset() + this.segmentMetadata.getLength();
            if (endPosition > fileInfo.length()) {
                throw new IllegalArgumentException("StartOffset+UploadLength is beyond the end of the input file");
            }
            this.uploadSegmentContents(inputStream, endPosition);
            this.verifyUploadedStream();
        }
    }

    private void verifyUploadedStream() throws Exception {
        long remoteLength = -1L;
        for (int retryCount = 0; retryCount < 4; ++retryCount) {
            try {
                remoteLength = this.frontEndAdapter.getStreamLength(this.segmentMetadata.getPath());
                break;
            }
            catch (Exception ex) {
                if (retryCount >= 4) {
                    throw ex;
                }
                SingleSegmentUploader.waitForRetry(retryCount, this.useBackOffRetryStrategy);
                continue;
            }
        }
        if (this.segmentMetadata.getLength() != remoteLength) {
            throw new UploadFailedException(MessageFormat.format("Post-upload stream verification failed: target stream has a length of {0}, expected {1}", remoteLength, this.segmentMetadata.getLength()));
        }
    }

    private void uploadSegmentContents(RandomAccessFile inputStream, long endPosition) throws Exception {
        long bytesCopiedSoFar = 0L;
        byte[] buffer = new byte[0x400000];
        int residualBufferLength = 0;
        while (inputStream.getFilePointer() < endPosition) {
            int bufferDataLength;
            int bytesRead = this.readIntoBuffer(inputStream, buffer, residualBufferLength, endPosition);
            int uploadCutoff = bufferDataLength = residualBufferLength + bytesRead;
            if (!this.metadata.isBinary()) {
                uploadCutoff = this.determineUploadCutoffForTextFile(buffer, bufferDataLength, inputStream);
            }
            bytesCopiedSoFar = this.uploadBuffer(buffer, uploadCutoff, bytesCopiedSoFar);
            residualBufferLength = bufferDataLength - uploadCutoff;
            if (residualBufferLength <= 0) continue;
            System.arraycopy(buffer, uploadCutoff, buffer, 0, residualBufferLength);
        }
        if (residualBufferLength > 0) {
            this.uploadBuffer(buffer, residualBufferLength, bytesCopiedSoFar);
        }
        buffer = null;
    }

    private int determineUploadCutoffForTextFile(byte[] buffer, int bufferDataLength, RandomAccessFile inputStream) throws UploadFailedException, IOException {
        int newCutoff;
        Charset encoding = Charset.forName(this.metadata.getEncodingName());
        int uploadCutoff = StringExtensions.findNewline(buffer, bufferDataLength - 1, bufferDataLength, true, encoding, this.metadata.getDelimiter()) + 1;
        if (uploadCutoff <= 0 && (this.metadata.getSegmentCount() > 1 || bufferDataLength >= 0x400000)) {
            throw new UploadFailedException(MessageFormat.format("Found a record that exceeds the maximum allowed record length around offset {0}", inputStream.getFilePointer()));
        }
        if ((this.metadata.getDelimiter() == null || StringUtils.isEmpty((CharSequence)this.metadata.getDelimiter())) && uploadCutoff == buffer.length && buffer[buffer.length - 1] == 13 && (newCutoff = StringExtensions.findNewline(buffer, bufferDataLength - 2, bufferDataLength - 1, true, encoding, this.metadata.getDelimiter()) + 1) > 0) {
            uploadCutoff = newCutoff;
        }
        return uploadCutoff;
    }

    private long uploadBuffer(byte[] buffer, int bytesToCopy, long targetStreamOffset) throws Exception {
        int attemptCount = 0;
        boolean uploadCompleted = false;
        while (!uploadCompleted && attemptCount < 4) {
            ++attemptCount;
            try {
                if (targetStreamOffset == 0L) {
                    this.frontEndAdapter.createStream(this.segmentMetadata.getPath(), true, buffer, bytesToCopy);
                } else {
                    this.frontEndAdapter.appendToStream(this.segmentMetadata.getPath(), buffer, targetStreamOffset, bytesToCopy);
                }
                uploadCompleted = true;
                targetStreamOffset += (long)bytesToCopy;
            }
            catch (Exception ex) {
                if (attemptCount >= 4) {
                    throw ex;
                }
                SingleSegmentUploader.waitForRetry(attemptCount, this.useBackOffRetryStrategy);
            }
        }
        return targetStreamOffset;
    }

    private int readIntoBuffer(RandomAccessFile inputStream, byte[] buffer, int bufferOffset, long streamEndPosition) throws IOException {
        int bytesToRead = buffer.length - bufferOffset;
        if ((long)bytesToRead > streamEndPosition - inputStream.getFilePointer()) {
            bytesToRead = (int)(streamEndPosition - inputStream.getFilePointer());
        }
        int remainingBytes = bytesToRead;
        while (remainingBytes > 0) {
            int bytesRead = inputStream.read(buffer, bufferOffset, remainingBytes);
            remainingBytes = bytesToRead - (bufferOffset += bytesRead);
        }
        return bytesToRead;
    }

    public static void waitForRetry(int attemptCount, boolean useBackOffRetryStrategy) throws InterruptedException {
        if (!useBackOffRetryStrategy) {
            return;
        }
        int intervalSeconds = Math.max(32, (int)Math.pow(2.0, attemptCount));
        Thread.sleep(intervalSeconds * 1000);
    }

    private RandomAccessFile openInputStream() throws IOException {
        RandomAccessFile stream = new RandomAccessFile(this.metadata.getInputFilePath(), "r");
        if (this.segmentMetadata.getOffset() >= stream.length()) {
            throw new IllegalArgumentException("StartOffset is beyond the end of the input file");
        }
        stream.seek(0L);
        stream.seek(this.segmentMetadata.getOffset());
        return stream;
    }
}

